package io.github.atkawa7.codegen.annotations.processing;



import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import java.util.List;

public final class CodegenUtils {
    private CodegenUtils() {
        throw new UnsupportedOperationException("Cannot create an instance of this class");
    }


    public static boolean isInternalClass(TypeMirror typeMirror) {
        return typeMirror.toString().equalsIgnoreCase("java.") ||
                typeMirror.toString().equalsIgnoreCase("javax.");
    }

    public static boolean isInternalClass(String classType) {
        return classType.startsWith("java.") ||
                classType.startsWith("javax.");
    }

    public static <T> T last(final T[] array) {
        if (array != null && array.length > 0) {
            return array[array.length - 1];
        }

        return null;
    }

    public static TypeElement convertToTypeElement(TypeMirror element){
        return ((TypeElement) ((DeclaredType) element).asElement());
    }



    public static <T> T last(final List<T> list) {
        int len;
        if (list != null && (len = list.size()) > 0) {
            return list.get(len - 1);
        }
        return null;
    }

    public static <T> T first(final T[] array) {
        if (array != null && array.length > 0) {
            return array[0];
        }
        return null;
    }

    public static <T> T first(final List<T> list) {
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }
}
