package io.github.atkawa7.codegen.annotations.processing.models;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import java.lang.annotation.Annotation;
import java.util.*;

public class DomainModelMeta {
    private String name;
    private String fullyQualifiedName;
    private TypeElement typeElement;
    private String primaryKeyClass;
    private boolean noRepositoryBean;
    private List<QueryablesMeta> metas = new ArrayList<>(0);
    private Map<String, FieldMeta> allFields  = new HashMap<>(0);
    private List<FieldMeta> fieldMetas = new ArrayList<>(0);

    public List<FieldMeta> getFieldMetas() {
        return fieldMetas;
    }

    public void setFieldMetas(List<FieldMeta> fieldMetas) {
        this.fieldMetas = fieldMetas;
    }

    public Map<String, FieldMeta> getAllFields() {
        return allFields;
    }

    public void setAllFields(Map<String, FieldMeta> allFields) {
        this.allFields = allFields;
    }

    public String getPrimaryKeyClass() {
        return primaryKeyClass;
    }

    public void setPrimaryKeyClass(String primaryKeyClass) {
        this.primaryKeyClass = primaryKeyClass;
    }

    public boolean isNoRepositoryBean() {
        return noRepositoryBean;
    }

    public void setNoRepositoryBean(boolean noRepositoryBean) {
        this.noRepositoryBean = noRepositoryBean;
    }

    public List<QueryablesMeta> getMetas() {
        return metas;
    }

    public void setMetas(List<QueryablesMeta> metas) {
        this.metas = metas;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TypeElement getTypeElement() {
        return typeElement;
    }

    public void setTypeElement(TypeElement typeElement) {
        this.typeElement = typeElement;
    }

    public String getFullyQualifiedName() {
        return fullyQualifiedName;
    }

    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }



    public Optional<AnnotationMirror> findAnnotationMirrorForField(Class<? extends Annotation> annotationClass) {
        for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
            DeclaredType declaredType = annotationMirror.getAnnotationType();

            if (declaredType.toString().equals(annotationClass.getCanonicalName())) {
                return Optional.of(annotationMirror);
            }
        }
        return Optional.empty();
    }
}
