package io.github.atkawa7.codegen.annotations.processing.models;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import java.lang.annotation.Annotation;
import java.util.Optional;

public class FieldMeta {
    protected String fullyQualifiedName;
    protected String name;
    protected Element element;
    protected FieldMeta source;
    private QueryableMeta queryableMeta;

    public QueryableMeta getQueryableMeta() {
        return queryableMeta;
    }

    public void setQueryableMeta(QueryableMeta queryableMeta) {
        this.queryableMeta = queryableMeta;
    }

    protected AnnotationMirror annotationMirror;

    public AnnotationMirror getAnnotationMirror() {
        return annotationMirror;
    }

    public void setAnnotationMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
    }

    public FieldMeta getSource() {
        return source;
    }

    public void setSource(FieldMeta source) {
        this.source = source;
    }


    public Element getElement() {
        return element;
    }

    public Optional<AnnotationMirror> findAnnotationMirrorForField(Class<? extends Annotation> annotationClass) {
        for (AnnotationMirror a : element.getAnnotationMirrors()) {
            DeclaredType declaredType = a.getAnnotationType();
            if (declaredType.toString().equals(annotationClass.getName())) {
                return Optional.of(a);
            }
        }
        return Optional.empty();
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public String getFullyQualifiedName() {
        return fullyQualifiedName;
    }

    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "FieldMeta{" +
                "fullyQualifiedName='" + fullyQualifiedName + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
