/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.codegen.annotations.processing;

import io.github.atkawa7.codegen.annotations.DomainModel;
import io.github.atkawa7.codegen.annotations.Queryable;
import io.github.atkawa7.codegen.annotations.processing.CodegenUtils;
import io.github.atkawa7.codegen.annotations.processing.models.DomainModelMeta;
import io.github.atkawa7.codegen.annotations.processing.models.FieldMeta;
import io.github.atkawa7.codegen.annotations.processing.models.QueryableMeta;
import io.github.atkawa7.codegen.annotations.processing.models.QueryablesMeta;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.persistence.Id;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.commons.lang3.StringUtils;

public class RepositoryCodegen
extends AbstractProcessor {
    private Messager messager;
    public static Map<String, List<FieldMeta>> cache = new HashMap<String, List<FieldMeta>>();
    private Map<String, String> options;
    private Types typesUtils;

    public static List<String> getClassNames(Class<?> ... args) {
        if (args != null) {
            ArrayList<String> names = new ArrayList<String>(args.length);
            for (Class<?> classType : args) {
                names.add(classType.getCanonicalName());
            }
            return names;
        }
        return Collections.emptyList();
    }

    public static boolean isDate(TypeMirror typeMirror) {
        String fullQualified = typeMirror.toString();
        for (String className : RepositoryCodegen.getClassNames(java.util.Date.class, Date.class, Time.class, Timestamp.class, LocalDate.class, LocalDateTime.class, ZonedDateTime.class, Instant.class, OffsetDateTime.class, OffsetTime.class, Year.class, YearMonth.class, ZonedDateTime.class, LocalTime.class)) {
            if (!className.equalsIgnoreCase(fullQualified)) continue;
            return true;
        }
        return false;
    }

    public static boolean isString(TypeMirror typeMirror) {
        String fullQualified = typeMirror.toString();
        for (String className : RepositoryCodegen.getClassNames(String.class)) {
            if (!className.equalsIgnoreCase(fullQualified)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArrayOfType(TypeMirror typeMirror, Class<?> type) {
        return typeMirror.toString().equalsIgnoreCase(String.format("%s[]", type.getCanonicalName()));
    }

    public static Map<ExecutableElement, AnnotationValue> getAnnotationValuesWithDefaults(AnnotationMirror annotation) {
        HashMap<ExecutableElement, AnnotationValue> values = new HashMap<ExecutableElement, AnnotationValue>();
        Map<? extends ExecutableElement, ? extends AnnotationValue> declaredValues = annotation.getElementValues();
        for (ExecutableElement method : ElementFilter.methodsIn(annotation.getAnnotationType().asElement().getEnclosedElements())) {
            if (declaredValues.containsKey(method)) {
                values.put(method, declaredValues.get(method));
                continue;
            }
            if (method.getDefaultValue() != null) {
                values.put(method, method.getDefaultValue());
                continue;
            }
            throw new IllegalStateException("Unset annotation value without default should never happen: ");
        }
        return values;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.options = processingEnv.getOptions();
        this.typesUtils = processingEnv.getTypeUtils();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(DomainModel.class.getName());
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.singleton("codegen.packageName");
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public Set<TypeElement> getTypeElementsAnnotatedWith(Class<? extends Annotation> classType, RoundEnvironment roundEnv) {
        Set<? extends Element> annotatedWith = roundEnv.getElementsAnnotatedWith(classType);
        return ElementFilter.typesIn(annotatedWith);
    }

    public List<FieldMeta> getFieldsForType(TypeElement typeElement) {
        List<FieldMeta> cached = cache.get(typeElement.getQualifiedName().toString());
        if (cached != null) {
            return cached;
        }
        ArrayList<FieldMeta> metas = new ArrayList<FieldMeta>(5);
        for (Element element : typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD) continue;
            FieldMeta meta = new FieldMeta();
            meta.setName(element.getSimpleName().toString());
            meta.setFullyQualifiedName(element.asType().toString());
            meta.setElement(element);
            metas.add(meta);
        }
        return metas;
    }

    public List<FieldMeta> getAllFieldsForType(TypeElement typeElement) {
        ArrayList<FieldMeta> metas = new ArrayList<FieldMeta>(0);
        for (TypeMirror typeMirror : this.typesUtils.directSupertypes(typeElement.asType())) {
            metas.addAll(this.getFieldsForType(CodegenUtils.convertToTypeElement(typeMirror)));
        }
        metas.addAll(this.getFieldsForType(typeElement));
        return metas;
    }

    public Map<String, Object> getValues(AnnotationMirror annotationMirror) {
        Map<ExecutableElement, AnnotationValue> values = RepositoryCodegen.getAnnotationValuesWithDefaults(annotationMirror);
        HashMap<String, Object> out = new HashMap<String, Object>(values.size());
        for (Map.Entry<ExecutableElement, AnnotationValue> entry : values.entrySet()) {
            String key = entry.getKey().getSimpleName().toString();
            Object value = entry.getValue().getValue();
            out.put(key, value);
        }
        return out;
    }

    public String json(Map<String, Object> map) {
        return "{" + map.entrySet().stream().map(e -> "\"" + (String)e.getKey() + "\":\"" + e.getValue() + "\"").collect(Collectors.joining(", ")) + "}";
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<TypeElement> elements = this.getTypeElementsAnnotatedWith(DomainModel.class, roundEnv);
        if (elements.isEmpty()) {
            return false;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("---------------------Processing----------------\n\n");
        builder.append(String.format("Codegen processing started %s\n", new java.util.Date()));
        builder.append(String.format("Processing %d classes \n", elements.size()));
        int classesProcessed = 0;
        ArrayList<DomainModelMeta> classMetaList = new ArrayList<DomainModelMeta>();
        for (TypeElement typeElement : elements) {
            Object typeMirror;
            DomainModelMeta domainModelMeta = new DomainModelMeta();
            domainModelMeta.setName(typeElement.getSimpleName().toString());
            domainModelMeta.setFullyQualifiedName(typeElement.getQualifiedName().toString());
            domainModelMeta.setTypeElement(typeElement);
            builder.append(String.format("%-2d. Processing Class <%s>\n", ++classesProcessed, domainModelMeta.getFullyQualifiedName()));
            List<FieldMeta> metaList = this.getAllFieldsForType(typeElement);
            for (int i = 0; i < metaList.size(); ++i) {
                FieldMeta meta = metaList.get(i);
                Optional<AnnotationMirror> hasQueryable = meta.findAnnotationMirrorForField(Queryable.class);
                builder.append(String.format("\t\t%-2d. name=%s type=%s hasQueryable=%s\n", i + 1, meta.getName(), meta.getFullyQualifiedName(), hasQueryable.isPresent()));
                domainModelMeta.getAllFields().put(meta.getName(), meta);
                if (hasQueryable.isPresent()) {
                    meta.setAnnotationMirror(hasQueryable.get());
                    domainModelMeta.getFieldMetas().add(meta);
                    Map<String, Object> values = this.getValues(hasQueryable.get());
                    QueryableMeta queryableMeta = new QueryableMeta();
                    queryableMeta.setMany((Boolean)values.get("many"));
                    queryableMeta.setPageable((Boolean)values.get("pageable"));
                    queryableMeta.setOptional((Boolean)values.get("optional"));
                    meta.setQueryableMeta(queryableMeta);
                }
                int nestedCounter = 0;
                if (CodegenUtils.isInternalClass(meta.getFullyQualifiedName()) || !((typeMirror = meta.getElement().asType()) instanceof DeclaredType)) continue;
                for (FieldMeta nested : this.getAllFieldsForType(CodegenUtils.convertToTypeElement(meta.getElement().asType()))) {
                    nested.setSource(meta);
                    Optional<AnnotationMirror> hasId = nested.findAnnotationMirrorForField(Id.class);
                    String key = meta.getName() + StringUtils.capitalize((String)nested.getName());
                    if (hasQueryable.isPresent() && hasId.isPresent()) {
                        domainModelMeta.getFieldMetas().add(nested);
                        nested.setQueryableMeta(meta.getQueryableMeta());
                    }
                    domainModelMeta.getAllFields().put(key, nested);
                    builder.append(String.format("\t\t\t\t%-2d. name=%s type=%s hasId=%s\n", ++nestedCounter, nested.getName(), nested.getFullyQualifiedName(), hasId.isPresent()));
                }
            }
            classMetaList.add(domainModelMeta);
            Optional<AnnotationMirror> hasDomainModel = domainModelMeta.findAnnotationMirrorForField(DomainModel.class);
            if (hasDomainModel.isPresent()) {
                builder.append("\n\nDomainModel Annotation Values\n\n");
                Map<ExecutableElement, AnnotationValue> values = RepositoryCodegen.getAnnotationValuesWithDefaults(hasDomainModel.get());
                builder.append(String.format("Found %d Annotation Values\n", values.size()));
                int counter = 0;
                HashMap<String, Object> context = new HashMap<String, Object>(values.size());
                typeMirror = values.entrySet().iterator();
                while (typeMirror.hasNext()) {
                    Map.Entry<ExecutableElement, AnnotationValue> entry = typeMirror.next();
                    ++counter;
                    ExecutableElement key = entry.getKey();
                    String name = key.getSimpleName().toString();
                    Object value = entry.getValue().getValue();
                    if (value instanceof List) {
                        ArrayList contexts = new ArrayList(((List)value).size());
                        for (Object v1 : (List)value) {
                            if (v1 instanceof AnnotationMirror) {
                                int[] nestedCounter = new int[]{0};
                                HashMap nestedContext = new HashMap(values.size());
                                Map<ExecutableElement, AnnotationValue> nested = RepositoryCodegen.getAnnotationValuesWithDefaults((AnnotationMirror)v1);
                                nested.forEach((k, v) -> {
                                    nestedCounter[0] = nestedCounter[0] + 1;
                                    Object v2 = v.getValue();
                                    if (v2 instanceof List) {
                                        ArrayList<String> attributes = new ArrayList<String>(((List)v2).size());
                                        for (Object f : (List)v2) {
                                            if (!(f instanceof AnnotationValue)) continue;
                                            attributes.add(Objects.toString(((AnnotationValue)f).getValue()));
                                        }
                                        nestedContext.put(k.getSimpleName().toString(), attributes);
                                    } else {
                                        nestedContext.put(k.getSimpleName().toString(), v2);
                                    }
                                    builder.append(String.format("\t\t\t\t%-2d. key=%s value=%s\n", nestedCounter[0], k.getSimpleName(), v.getValue()));
                                });
                                contexts.add(nestedContext);
                                continue;
                            }
                            contexts.add(v1);
                        }
                        context.put(name, contexts);
                        continue;
                    }
                    context.put(name, value);
                    builder.append(String.format("\t\t%-2d. key=%s value=%s\n", counter, name, value));
                }
                domainModelMeta.setPrimaryKeyClass(Objects.toString(context.get("primaryKeyClass")));
                domainModelMeta.setNoRepositoryBean((Boolean)context.get("noRepositoryBean"));
                Object nestedData = context.get("queryables");
                if (nestedData != null) {
                    ArrayList<QueryablesMeta> queryablesMetas = new ArrayList<QueryablesMeta>(((List)nestedData).size());
                    for (Map data : (List)nestedData) {
                        this.messager.printMessage(Diagnostic.Kind.WARNING, this.json(data));
                        QueryablesMeta queryablesMeta = new QueryablesMeta();
                        queryablesMeta.setMany((Boolean)data.get("many"));
                        queryablesMeta.setOptional((Boolean)data.get("optional"));
                        queryablesMeta.setPageable((Boolean)data.get("pageable"));
                        queryablesMeta.setFieldNames((List)data.get("fieldNames"));
                        queryablesMetas.add(queryablesMeta);
                    }
                    domainModelMeta.setMetas(queryablesMetas);
                }
            }
            builder.append("\n\n");
        }
        this.generate(classMetaList);
        this.messager.printMessage(Diagnostic.Kind.WARNING, builder.toString());
        return false;
    }

    public void generate(List<DomainModelMeta> classMetaList) {
        for (DomainModelMeta domainModelMeta : classMetaList) {
            String repositoryName = domainModelMeta.getName() + "Repository";
            String qualifiedName = domainModelMeta.getFullyQualifiedName();
            String packageName = this.options.getOrDefault("codegen.packageName", qualifiedName.substring(0, qualifiedName.lastIndexOf(".")) + ".repositories");
            List<String> methods = this.getMethods(domainModelMeta);
            StringJoiner imports = new StringJoiner(";\nimport ", "import ", ";\n\n");
            imports.add("org.springframework.data.domain.Page");
            imports.add("org.springframework.data.domain.Pageable");
            imports.add("org.springframework.data.jpa.repository.JpaRepository");
            imports.add("org.springframework.data.jpa.repository.JpaSpecificationExecutor");
            imports.add("org.springframework.data.repository.NoRepositoryBean");
            imports.add("org.springframework.stereotype.Repository");
            imports.add("java.util.List");
            imports.add("java.util.Optional");
            StringBuilder source = new StringBuilder();
            source.append("package ");
            source.append(packageName);
            source.append(";\n\n");
            source.append(imports);
            if (domainModelMeta.isNoRepositoryBean()) {
                source.append("@NoRepositoryBean\n");
            } else {
                source.append("@Repository\n");
            }
            source.append("public interface ");
            source.append(repositoryName);
            source.append(String.format(" extends JpaRepository<%s, %s>, JpaSpecificationExecutor<%s>", domainModelMeta.getFullyQualifiedName(), domainModelMeta.getPrimaryKeyClass(), domainModelMeta.getFullyQualifiedName()));
            source.append(" {\n\n");
            source.append(String.join((CharSequence)";\n\n", methods));
            if (methods.size() > 0) {
                source.append(";");
            }
            source.append("\n\n}\n");
            try {
                JavaFileObject javaFileObject = this.processingEnv.getFiler().createSourceFile(packageName + '.' + repositoryName, new Element[0]);
                Writer writer = javaFileObject.openWriter();
                try {
                    writer.write(source.toString());
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private List<String> getMethods(DomainModelMeta domainModelMeta) {
        ArrayList<String> methods = new ArrayList<String>(0);
        for (QueryablesMeta queryablesMeta : domainModelMeta.getMetas()) {
            String methodTemplate;
            String returnType;
            List<String> fieldNames = queryablesMeta.getFieldNames();
            if (fieldNames == null || fieldNames.size() <= 0) continue;
            ArrayList<String> capitalized = new ArrayList<String>(fieldNames.size());
            ArrayList<String> parameters = new ArrayList<String>(fieldNames.size());
            for (String fieldName : fieldNames) {
                FieldMeta fieldMeta = domainModelMeta.getAllFields().get(fieldName);
                if (fieldMeta == null) {
                    throw new IllegalArgumentException(String.format("FieldName(%s) doesn't exists on (%s)", fieldName, domainModelMeta.getFullyQualifiedName()));
                }
                capitalized.add(StringUtils.capitalize((String)fieldName));
                parameters.add(fieldMeta.getFullyQualifiedName() + "  " + fieldName);
            }
            if (queryablesMeta.isMany() || queryablesMeta.isPageable()) {
                if (queryablesMeta.isPageable()) {
                    returnType = String.format("Page<%s>", domainModelMeta.getFullyQualifiedName());
                    methodTemplate = String.format("findAllBy%s(%s, Pageable pageable)", StringUtils.join(capitalized, (String)"And"), StringUtils.join(parameters, (String)", "));
                } else {
                    returnType = String.format("List<%s>", domainModelMeta.getFullyQualifiedName());
                    methodTemplate = String.format("findAllBy%s(%s)", StringUtils.join(capitalized, (String)"And"), StringUtils.join(parameters, (String)", "));
                }
            } else {
                returnType = queryablesMeta.isOptional() ? String.format("Optional<%s>", domainModelMeta.getFullyQualifiedName()) : domainModelMeta.getFullyQualifiedName();
                methodTemplate = String.format("findBy%s(%s)", StringUtils.join(capitalized, (String)"And"), StringUtils.join(parameters, (String)", "));
            }
            methods.add("    " + returnType + " " + methodTemplate);
        }
        for (FieldMeta fieldMeta : domainModelMeta.getFieldMetas()) {
            String methodTemplate;
            String returnType;
            QueryableMeta queryableMeta = fieldMeta.getQueryableMeta();
            String key = fieldMeta.getName();
            if (fieldMeta.getSource() != null) {
                key = fieldMeta.getSource().getName() + StringUtils.capitalize((String)fieldMeta.getName());
            }
            if (queryableMeta.isMany() || queryableMeta.isPageable()) {
                if (queryableMeta.isPageable()) {
                    returnType = String.format("Page<%s>", domainModelMeta.getFullyQualifiedName());
                    methodTemplate = String.format("findAllBy%s(%s %s, Pageable pageable)", StringUtils.capitalize((String)key), fieldMeta.getFullyQualifiedName(), key);
                } else {
                    returnType = String.format("List<%s>", domainModelMeta.getFullyQualifiedName());
                    methodTemplate = String.format("findAllBy%s(%s %s)", StringUtils.capitalize((String)key), fieldMeta.getFullyQualifiedName(), key);
                }
            } else {
                returnType = queryableMeta.isOptional() ? String.format("Optional<%s>", domainModelMeta.getFullyQualifiedName()) : domainModelMeta.getFullyQualifiedName();
                methodTemplate = String.format("findBy%s(%s %s)", StringUtils.capitalize((String)key), fieldMeta.getFullyQualifiedName(), key);
            }
            methods.add("    " + returnType + " " + methodTemplate);
        }
        return methods;
    }
}

