/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.generators;

import io.github.atkawa7.har.HarRequest;
import io.github.atkawa7.httpsnippet.generators.CodeGenerator;
import io.github.atkawa7.httpsnippet.generators.c.LibCurl;
import io.github.atkawa7.httpsnippet.generators.clojure.CljHttp;
import io.github.atkawa7.httpsnippet.generators.csharp.RestSharp;
import io.github.atkawa7.httpsnippet.generators.go.GoNative;
import io.github.atkawa7.httpsnippet.generators.java.Jsoup;
import io.github.atkawa7.httpsnippet.generators.java.OkHttp;
import io.github.atkawa7.httpsnippet.generators.java.Unirest;
import io.github.atkawa7.httpsnippet.generators.javascript.Fetch;
import io.github.atkawa7.httpsnippet.generators.javascript.JQuery;
import io.github.atkawa7.httpsnippet.generators.javascript.XMLHttpRequest;
import io.github.atkawa7.httpsnippet.generators.node.NodeNative;
import io.github.atkawa7.httpsnippet.generators.node.NodeRequest;
import io.github.atkawa7.httpsnippet.generators.node.NodeUnirest;
import io.github.atkawa7.httpsnippet.generators.objc.ObjNSURLSession;
import io.github.atkawa7.httpsnippet.generators.powershell.PowerShell;
import io.github.atkawa7.httpsnippet.generators.python.Python3Native;
import io.github.atkawa7.httpsnippet.generators.python.PythonRequests;
import io.github.atkawa7.httpsnippet.generators.ruby.RubyNative;
import io.github.atkawa7.httpsnippet.generators.shell.Curl;
import io.github.atkawa7.httpsnippet.generators.swift.Swift;
import io.github.atkawa7.httpsnippet.models.Client;
import io.github.atkawa7.httpsnippet.models.HttpSnippet;
import io.github.atkawa7.httpsnippet.models.Language;
import io.github.atkawa7.httpsnippet.models.internal.CodeRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import lombok.NonNull;

public class HttpSnippetCodeGenerator {
    private final List<CodeGenerator> codeGenerators;
    private final List<Language> languages;

    public HttpSnippetCodeGenerator() {
        this(HttpSnippetCodeGenerator.defaultGenerators());
    }

    public HttpSnippetCodeGenerator(CodeGenerator ... codeGenerators) {
        this(Arrays.asList(codeGenerators));
        if (codeGenerators == null) {
            throw new NullPointerException("codeGenerators is marked non-null but is null");
        }
    }

    public HttpSnippetCodeGenerator(@NonNull List<CodeGenerator> codeGenerators) {
        if (codeGenerators == null) {
            throw new NullPointerException("codeGenerators is marked non-null but is null");
        }
        Collections.sort(codeGenerators, Comparator.comparing(o -> o.getDisplayName()));
        this.codeGenerators = Collections.unmodifiableList(codeGenerators);
        this.languages = Collections.unmodifiableList(Arrays.asList(Language.values()));
    }

    private static List<CodeGenerator> defaultGenerators() {
        ArrayList<CodeGenerator> codeGenerators = new ArrayList<CodeGenerator>();
        codeGenerators.add(new OkHttp());
        codeGenerators.add(new Unirest());
        codeGenerators.add(new LibCurl());
        codeGenerators.add(new RestSharp());
        codeGenerators.add(new GoNative());
        codeGenerators.add(new JQuery());
        codeGenerators.add(new XMLHttpRequest());
        codeGenerators.add(new NodeNative());
        codeGenerators.add(new NodeRequest());
        codeGenerators.add(new NodeUnirest());
        codeGenerators.add(new Python3Native());
        codeGenerators.add(new PythonRequests());
        codeGenerators.add(new RubyNative());
        codeGenerators.add(new Curl());
        codeGenerators.add(new CljHttp());
        codeGenerators.add(new PowerShell());
        codeGenerators.add(new Jsoup());
        codeGenerators.add(new Fetch());
        codeGenerators.add(new Swift());
        codeGenerators.add(new ObjNSURLSession());
        return codeGenerators;
    }

    public HttpSnippet snippet(@NonNull HarRequest harRequest, @NonNull String language, @NonNull String client) throws Exception {
        if (harRequest == null) {
            throw new NullPointerException("harRequest is marked non-null but is null");
        }
        if (language == null) {
            throw new NullPointerException("language is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        CodeGenerator codeGenerator = this.findGenerator(language, client);
        return this.convert(harRequest, codeGenerator);
    }

    public HttpSnippet snippet(@NonNull HarRequest harRequest, @NonNull String language) throws Exception {
        if (harRequest == null) {
            throw new NullPointerException("harRequest is marked non-null but is null");
        }
        if (language == null) {
            throw new NullPointerException("language is marked non-null but is null");
        }
        Language lang = this.findLanguage(language);
        return this.snippet(harRequest, lang);
    }

    public HttpSnippet snippet(@NonNull HarRequest harRequest, @NonNull Language language, @NonNull Client client) throws Exception {
        if (harRequest == null) {
            throw new NullPointerException("harRequest is marked non-null but is null");
        }
        if (language == null) {
            throw new NullPointerException("language is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        CodeGenerator codeGenerator = this.findGenerator(language, client);
        return this.convert(harRequest, codeGenerator);
    }

    public HttpSnippet snippet(@NonNull HarRequest harRequest, @NonNull Language language) throws Exception {
        if (harRequest == null) {
            throw new NullPointerException("harRequest is marked non-null but is null");
        }
        if (language == null) {
            throw new NullPointerException("language is marked non-null but is null");
        }
        Client client = language.getDefaultClient();
        CodeGenerator codeGenerator = this.findGenerator(language, client);
        return this.convert(harRequest, codeGenerator);
    }

    public List<HttpSnippet> snippets(@NonNull HarRequest harRequest) throws Exception {
        if (harRequest == null) {
            throw new NullPointerException("harRequest is marked non-null but is null");
        }
        CodeRequest codeRequest = CodeRequest.newCodeRequest(harRequest);
        ArrayList<HttpSnippet> httpSnippets = new ArrayList<HttpSnippet>(this.codeGenerators.size());
        for (CodeGenerator codeGenerator : this.codeGenerators) {
            httpSnippets.add(this.convert(codeRequest, codeGenerator));
        }
        return httpSnippets;
    }

    private HttpSnippet convert(@NonNull HarRequest harRequest, @NonNull CodeGenerator codeGenerator) throws Exception {
        if (harRequest == null) {
            throw new NullPointerException("harRequest is marked non-null but is null");
        }
        if (codeGenerator == null) {
            throw new NullPointerException("codeGenerator is marked non-null but is null");
        }
        return this.convert(CodeRequest.newCodeRequest(harRequest), codeGenerator);
    }

    private HttpSnippet convert(@NonNull CodeRequest codeRequest, @NonNull CodeGenerator codeGenerator) throws Exception {
        if (codeRequest == null) {
            throw new NullPointerException("codeRequest is marked non-null but is null");
        }
        if (codeGenerator == null) {
            throw new NullPointerException("codeGenerator is marked non-null but is null");
        }
        return HttpSnippet.builder().client(codeGenerator.getClient()).displayName(codeGenerator.getDisplayName()).language(codeGenerator.getLanguage()).code(codeGenerator.generateCode(codeRequest)).build();
    }

    private CodeGenerator findGenerator(@NonNull Language language, @NonNull Client client) throws Exception {
        if (language == null) {
            throw new NullPointerException("language is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        return this.findGenerator(language.getTitle(), client.getTitle());
    }

    private CodeGenerator findGenerator(@NonNull String language, @NonNull String client) throws Exception {
        if (language == null) {
            throw new NullPointerException("language is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        return this.codeGenerators.stream().filter(t -> t.getClient().getTitle().equalsIgnoreCase(client) && t.getLanguage().getTitle().equalsIgnoreCase(language)).findFirst().orElseThrow(() -> new Exception(String.format("CodeGenerator (%s, %s) not supported", client, language)));
    }

    private Language findLanguage(@NonNull String name) throws Exception {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.languages.stream().filter(l -> l.getTitle().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new Exception(String.format("Language (%s) not supported", name)));
    }
}

