/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.generators.java;

import io.github.atkawa7.httpsnippet.builder.CodeBuilder;
import io.github.atkawa7.httpsnippet.generators.CodeGenerator;
import io.github.atkawa7.httpsnippet.models.Client;
import io.github.atkawa7.httpsnippet.models.Language;
import io.github.atkawa7.httpsnippet.models.internal.CodeRequest;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Unirest
extends CodeGenerator {
    private static final List<String> SUPPORTED_METHODS = Arrays.asList("GET", "POST", "PUT", "DELETE", "PATCH", "HEAD", "OPTIONS");

    public Unirest() {
        super(Client.UNIREST, Language.JAVA);
    }

    public boolean isNotSupported(String method) {
        return !SUPPORTED_METHODS.contains(method.toUpperCase());
    }

    @Override
    protected String generateCode(CodeRequest codeRequest) throws Exception {
        CodeBuilder code = new CodeBuilder("  ");
        String method = codeRequest.getMethod();
        if (this.isNotSupported(method)) {
            code.push("HttpResponse<String> response = Unirest.customMethod(\"%s\",\"%s\")", method.toUpperCase(), codeRequest.getFullUrl());
        } else {
            code.push("HttpResponse<String> response = Unirest.%s(\"%s\")", method.toLowerCase(), codeRequest.getFullUrl());
        }
        if (codeRequest.hasHeadersAndCookies()) {
            codeRequest.allHeadersAsMap().forEach((k, v) -> code.push(1, ".header(\"%s\", \"%s\")", (String)k, (String)v));
        }
        if (codeRequest.hasBody()) {
            switch (codeRequest.getMimeType()) {
                case "application/json": {
                    if (!codeRequest.hasText()) break;
                    code.push(1, ".body(%s)", codeRequest.toJsonString());
                    break;
                }
                case "application/x-www-form-urlencoded": {
                    if (!codeRequest.hasParams()) break;
                    codeRequest.getParams().forEach(p -> code.push(1, ".field(\"%s\",\"%s\")", p.getName(), p.getValue()));
                    break;
                }
                case "multipart/form-data": {
                    if (!codeRequest.hasParams()) break;
                    codeRequest.getParams().forEach(p -> {
                        if (StringUtils.isNotBlank((CharSequence)p.getFileName())) {
                            code.push(1, ".field(\"%s\", new File(\"%s\"))", p.getName(), p.getFileName());
                        } else {
                            code.push(1, ".field(\"%s\",\"%s\")", p.getName(), p.getValue());
                        }
                    });
                    break;
                }
                default: {
                    if (!codeRequest.hasText()) break;
                    code.push(1, ".body(\"%s\")", codeRequest.getText());
                }
            }
        }
        code.push(1, ".asString();").blank();
        return code.join();
    }
}

