/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.generators.javascript;

import io.github.atkawa7.httpsnippet.builder.CodeBuilder;
import io.github.atkawa7.httpsnippet.generators.CodeGenerator;
import io.github.atkawa7.httpsnippet.models.Client;
import io.github.atkawa7.httpsnippet.models.Language;
import io.github.atkawa7.httpsnippet.models.internal.CodeRequest;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;

public class Fetch
extends CodeGenerator {
    public Fetch() {
        super(Client.FETCH, Language.JAVASCRIPT);
    }

    @Override
    protected String generateCode(CodeRequest codeRequest) throws Exception {
        CodeBuilder code = new CodeBuilder(" ");
        String url = codeRequest.getFullUrl();
        LinkedHashMap<String, Object> fetchOptions = new LinkedHashMap<String, Object>();
        fetchOptions.put("mode", "cors");
        fetchOptions.put("method", codeRequest.getMethod());
        fetchOptions.put("headers", codeRequest.allHeadersAsMap());
        switch (codeRequest.getMimeType()) {
            case "application/x-www-form-urlencoded": {
                if (!codeRequest.hasParams()) break;
                code.push("const details =%s;", codeRequest.paramsToJSONString());
                code.push("const form = Object.entries(details)");
                code.push(4, ".map(([key, value]) => encodeURIComponent(key) + '=' + encodeURIComponent(value))");
                code.push(4, ".join('&')");
                fetchOptions.put("body", "[form]");
                break;
            }
            case "multipart/form-data": {
                if (!codeRequest.hasParams()) break;
                code.push("let form = new FormData();");
                codeRequest.getParams().forEach(param -> {
                    String value = StringUtils.isNotBlank((CharSequence)param.getFileName()) ? param.getFileName() : param.getValue();
                    code.push("form.append(\"%s\", \"%s\");", param.getName(), value);
                });
                fetchOptions.put("body", "[form]");
                code.blank();
                break;
            }
            default: {
                if (!codeRequest.hasText()) break;
                fetchOptions.put("body", codeRequest.getText());
            }
        }
        code.push("const fetchOptions = " + this.toPrettyJson(fetchOptions).replace("\"[form]\"", "form")).blank().push("fetch(\"" + url + "\", fetchOptions)").push(1, ".then(response => response.json())").push(1, ".then(data => console.log(data))").push(1, ".catch(error => console.log(error));");
        return code.join();
    }
}

