/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.generators.javascript;

import io.github.atkawa7.har.HarParam;
import io.github.atkawa7.httpsnippet.builder.CodeBuilder;
import io.github.atkawa7.httpsnippet.generators.CodeGenerator;
import io.github.atkawa7.httpsnippet.models.Client;
import io.github.atkawa7.httpsnippet.models.Language;
import io.github.atkawa7.httpsnippet.models.internal.CodeRequest;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class XMLHttpRequest
extends CodeGenerator {
    private boolean cors = true;

    public XMLHttpRequest() {
        super(Client.XHR, Language.JAVASCRIPT);
    }

    @Override
    protected String generateCode(CodeRequest codeRequest) throws Exception {
        CodeBuilder code;
        block17: {
            block16: {
                code = new CodeBuilder("  ");
                if (!codeRequest.hasBody()) break block16;
                switch (codeRequest.getMimeType()) {
                    case "application/json": {
                        if (codeRequest.hasText()) {
                            code.push("var data = JSON.stringify(%s);", codeRequest.toPrettyJsonString()).push("");
                            break;
                        }
                        break block17;
                    }
                    case "application/x-www-form-urlencoded": {
                        if (codeRequest.hasParams()) {
                            code.push("var data = %s;", this.toJson(codeRequest.paramsToString())).blank();
                            break;
                        }
                        break block17;
                    }
                    case "multipart/form-data": {
                        if (codeRequest.hasParams()) {
                            code.push("var data = new FormData();");
                            for (HarParam harParam : codeRequest.getParams()) {
                                String value = (String)StringUtils.firstNonEmpty((CharSequence[])new String[]{harParam.getFileName(), harParam.getValue(), "  "});
                                code.push("data.append(%s, %s);", this.toJson(harParam.getName()), this.toJson(value));
                            }
                            code.blank();
                            break;
                        }
                        break block17;
                    }
                    default: {
                        code.push("var data = %s;", this.toJson(codeRequest.getText())).blank();
                        break;
                    }
                }
                break block17;
            }
            code.push("var data = null;").blank();
        }
        code.push("var xhr = new XMLHttpRequest();");
        if (this.cors) {
            code.push("xhr.withCredentials = true;");
        }
        code.blank().push("xhr.addEventListener(\"readystatechange\", function () {").push(1, "if (this.readyState === this.DONE) {").push(2, "console.log(this.responseText);").push(1, "}").push("});").blank().push("xhr.open(%s, %s);", this.toJson(codeRequest.getMethod()), this.toJson(codeRequest.getFullUrl()));
        Map<String, String> allHeaders = codeRequest.allHeadersAsMap();
        if (ObjectUtils.isNotEmpty(allHeaders)) {
            allHeaders.forEach((k, v) -> {
                try {
                    code.push("xhr.setRequestHeader(%s, %s);", this.toJson(k), this.toJson(v));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        code.blank().push("xhr.send(data);").blank();
        return code.join();
    }
}

