/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.generators.node;

import io.github.atkawa7.httpsnippet.builder.CodeBuilder;
import io.github.atkawa7.httpsnippet.generators.CodeGenerator;
import io.github.atkawa7.httpsnippet.models.Client;
import io.github.atkawa7.httpsnippet.models.Language;
import io.github.atkawa7.httpsnippet.models.internal.CodeRequest;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;

public class NodeNative
extends CodeGenerator {
    public NodeNative() {
        super(Client.NODE, Language.NODE);
    }

    @Override
    protected String generateCode(CodeRequest codeRequest) throws Exception {
        CodeBuilder code = new CodeBuilder("  ");
        LinkedHashMap<String, Object> reqOpts = new LinkedHashMap<String, Object>();
        reqOpts.put("method", codeRequest.getMethod());
        reqOpts.put("hostname", codeRequest.getHost());
        reqOpts.put("port", codeRequest.getPort());
        reqOpts.put("path", codeRequest.getFullPath());
        reqOpts.put("headers", codeRequest.allHeadersAsMap());
        if ("application/x-www-form-urlencoded".equalsIgnoreCase(codeRequest.getMimeType())) {
            code.push("var qs = require(\"querystring\");");
        }
        if (codeRequest.hasAttachments()) {
            code.push("var fs = require(\"fs\")");
        }
        code.push("var http = require(\"%s\");", codeRequest.getProtocol().toLowerCase());
        if ("multipart/form-data".equalsIgnoreCase(codeRequest.getMimeType())) {
            code.push("var FormData = require(\"form-data\");");
        } else {
            code.blank().push("var options = %s;", this.toPrettyJson(reqOpts)).blank().push("var req = http.request(options, function (res) {").push(1, "var chunks = [];").blank().push(1, "res.on(\"data\", function (chunk) {").push(2, "chunks.push(chunk);").push(1, "});").blank().push(1, "res.on(\"end\", function () {").push(2, "var body = Buffer.concat(chunks);").push(2, "console.log(body.toString());").push(1, "});").push("});").blank();
        }
        if (codeRequest.hasBody()) {
            switch (codeRequest.getMimeType()) {
                case "application/x-www-form-urlencoded": {
                    if (!codeRequest.hasParams()) break;
                    code.push("req.write(qs.stringify(%s));", codeRequest.paramsToJSONString());
                    break;
                }
                case "application/json": {
                    if (!codeRequest.hasText()) break;
                    code.push("req.write(JSON.stringify(%s));", codeRequest.getText());
                    break;
                }
                case "multipart/form-data": {
                    if (!codeRequest.hasParams()) break;
                    code.push("var form = new FormData()");
                    codeRequest.getParams().forEach(p -> {
                        if (StringUtils.isNotBlank((CharSequence)p.getFileName())) {
                            code.push("form.append(\"%s\", fs.createReadStream(\"%s\"));", p.getName(), p.getFileName());
                        } else {
                            code.push("form.append(\"%s\", \"%s\");", p.getName(), p.getValue());
                        }
                    });
                    reqOpts.put("headers", "[headers]");
                    code.push("let headers = form.getHeaders();");
                    code.blank().push("var options = %s;", this.toPrettyJson(reqOpts).replace("\"[headers]\"", "headers")).blank().push("var req = http.request(options, function (res) {").push(1, "var chunks = [];").blank().push(1, "res.on(\"data\", function (chunk) {").push(2, "chunks.push(chunk);").push(1, "});").blank().push(1, "res.on(\"end\", function () {").push(2, "var body = Buffer.concat(chunks);").push(2, "console.log(body.toString());").push(1, "});").push("});").blank().push("form.pipe(req);").blank();
                    break;
                }
                default: {
                    if (!codeRequest.hasText()) break;
                    code.push("req.write(\"%s\");", codeRequest.getText());
                }
            }
        }
        if (!"multipart/form-data".equalsIgnoreCase(codeRequest.getMimeType())) {
            code.push("req.end();").blank();
        }
        return code.join();
    }
}

