/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.generators.node;

import io.github.atkawa7.har.HarParam;
import io.github.atkawa7.httpsnippet.builder.CodeBuilder;
import io.github.atkawa7.httpsnippet.generators.CodeGenerator;
import io.github.atkawa7.httpsnippet.models.Client;
import io.github.atkawa7.httpsnippet.models.Language;
import io.github.atkawa7.httpsnippet.models.internal.CodeRequest;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;

public class NodeRequest
extends CodeGenerator {
    public NodeRequest() {
        super(Client.NODE_REQUEST, Language.NODE);
    }

    @Override
    protected String generateCode(CodeRequest codeRequest) throws Exception {
        CodeBuilder code = new CodeBuilder("  ");
        if (codeRequest.hasAttachments()) {
            code.push("var fs = require(\"fs\");");
        }
        code.push("var request = require(\"request\");").blank();
        LinkedHashMap<String, Object> reqOpts = new LinkedHashMap<String, Object>();
        reqOpts.put("method", codeRequest.getMethod());
        reqOpts.put("url", codeRequest.getUrl());
        if (codeRequest.hasCookies()) {
            reqOpts.put("jar", "JAR");
            code.push("var jar = request.jar();");
            codeRequest.getCookies().forEach(h -> code.push("jar.setCookie(request.cookie(\"%s=%s\"), \"%s\");", h.getName(), h.getValue(), codeRequest.getUrl()));
            code.blank();
        }
        if (codeRequest.hasQueryStrings()) {
            reqOpts.put("qs", codeRequest.unwrapQueryStrings());
        }
        if (codeRequest.hasHeaders()) {
            reqOpts.put("headers", codeRequest.headersAsMap());
        }
        if (codeRequest.hasBody()) {
            switch (codeRequest.getMimeType()) {
                case "application/x-www-form-urlencoded": {
                    if (!codeRequest.hasParams()) break;
                    reqOpts.put("form", codeRequest.paramsAsMap());
                    break;
                }
                case "application/json": {
                    if (!codeRequest.hasText()) break;
                    reqOpts.put("body", codeRequest.fromJsonString());
                    reqOpts.put("json", Boolean.TRUE);
                    break;
                }
                case "multipart/form-data": {
                    if (!codeRequest.hasParams()) break;
                    HashMap<String, Object> formData = new HashMap<String, Object>();
                    for (HarParam param : codeRequest.getParams()) {
                        if (StringUtils.isNotEmpty((CharSequence)param.getFileName())) {
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("filename", param.getFileName());
                            options.put("contentType", param.getContentType());
                            HashMap<String, Object> fileAttachment = new HashMap<String, Object>();
                            fileAttachment.put("value", "fs.createReadStream(\"" + param.getFileName() + "\")");
                            fileAttachment.put("options", options);
                            formData.put(param.getName(), fileAttachment);
                            continue;
                        }
                        formData.put(param.getName(), param.getValue());
                    }
                    reqOpts.put("formData", formData);
                    break;
                }
                default: {
                    if (!codeRequest.hasText()) break;
                    reqOpts.put("body", codeRequest.getText());
                }
            }
        }
        code.push("var options = %s;", this.toPrettyJson(reqOpts)).blank();
        code.push("request(options, %s", "function (error, response, body) {").push(1, "if (error) throw new Error(error);").blank().push(1, "console.log(body);").push("});").blank();
        return code.join().replace("\"JAR\"", "jar").replace("\"fs.createReadStream(\\\"", "fs.createReadStream(\"").replace("\\\")\"", "\")");
    }
}

