/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.generators.objc;

import io.github.atkawa7.har.HarParam;
import io.github.atkawa7.httpsnippet.builder.CodeBuilder;
import io.github.atkawa7.httpsnippet.generators.CodeGenerator;
import io.github.atkawa7.httpsnippet.models.Client;
import io.github.atkawa7.httpsnippet.models.Language;
import io.github.atkawa7.httpsnippet.models.internal.CodeRequest;
import io.github.atkawa7.httpsnippet.utils.HarUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;

public class ObjNSURLSession
extends CodeGenerator {
    private int timeout = 10;

    public ObjNSURLSession() {
        super(Client.OBJECTIVE_C, Language.OBJECTIVE_C);
    }

    public String blankString(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(" ");
        }
        return builder.toString();
    }

    public String nsDeclaration(String nsClass, String name, Object parameters, Integer indent) throws Exception {
        String opening = nsClass + " *" + name + " = ";
        String literal = this.literalRepresentation(parameters, indent != null ? Integer.valueOf(opening.length()) : null);
        return opening + literal + ";";
    }

    public <T> String literalRepresentation(T value, Integer indentation) throws Exception {
        String join;
        String string = join = indentation == null ? ", " : ",\n   " + this.blankString(indentation);
        if (Objects.isNull(value)) {
            return "nil";
        }
        if (value instanceof Number) {
            return "@" + value.toString();
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<String> listBuilder = new ArrayList<String>();
            for (Object obj : list) {
                listBuilder.add(this.literalRepresentation(obj, null));
            }
            return "@[ " + String.join((CharSequence)join, listBuilder) + " ]";
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            ArrayList<String> listBuilder = new ArrayList<String>();
            for (Map.Entry entry : map.entrySet()) {
                String format = String.format("@\"%s\": %s", entry.getKey(), this.literalRepresentation(entry.getValue(), null));
                listBuilder.add(format);
            }
            return "@{ " + String.join((CharSequence)join, listBuilder) + " }";
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool != false ? "@YES" : "@NO";
        }
        return String.format("@%s", this.toJson(HarUtils.defaultIfNull(value, "")));
    }

    @Override
    protected String generateCode(CodeRequest codeRequest) throws Exception {
        CodeBuilder code = new CodeBuilder("    ");
        boolean hasHeaders = false;
        boolean hasBody = false;
        code.push("#import <Foundation/Foundation.h>");
        Map<String, String> allHeaders = codeRequest.allHeadersAsMap();
        if (ObjectUtils.isNotEmpty(allHeaders)) {
            hasHeaders = true;
            code.blank().push(this.nsDeclaration("NSDictionary", "headers", allHeaders, 1));
        }
        if (codeRequest.hasBody()) {
            hasBody = true;
            switch (codeRequest.getMimeType()) {
                case "application/x-www-form-urlencoded": {
                    if (!codeRequest.hasParams()) break;
                    List<HarParam> params = codeRequest.getParams();
                    code.blank().push("NSMutableData *postData = [[NSMutableData alloc] initWithData:[@\"%s=%s\" dataUsingEncoding:NSUTF8StringEncoding]];", params.get(0).getName(), params.get(0).getValue());
                    for (int i = 1; i < params.size(); ++i) {
                        code.push("[postData appendData:[@\"&%s=%s\" dataUsingEncoding:NSUTF8StringEncoding]];", params.get(i).getName(), params.get(i).getValue());
                    }
                    break;
                }
                case "application/json": {
                    if (!codeRequest.hasText()) break;
                    code.push(this.nsDeclaration("NSDictionary", "parameters", codeRequest.fromJsonString(), 2)).blank().push("NSData *postData = [NSJSONSerialization dataWithJSONObject:parameters options:0 error:nil];");
                    break;
                }
                default: {
                    code.blank().push("NSData *postData = [[NSData alloc] initWithData:[@\"" + codeRequest.getText() + "\" dataUsingEncoding:NSUTF8StringEncoding]];");
                }
            }
        }
        code.blank().push("NSMutableURLRequest *request = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:@\"" + codeRequest.getFullUrl() + "\"]").push("                                                       cachePolicy:NSURLRequestUseProtocolCachePolicy").push("                                                   timeoutInterval:" + new BigDecimal(this.timeout).setScale(1).toString() + "];").push("[request setHTTPMethod:@\"" + codeRequest.getMethod() + "\"];");
        if (hasHeaders) {
            code.push("[request setAllHTTPHeaderFields:headers];");
        }
        if (hasBody) {
            code.push("[request setHTTPBody:postData];");
        }
        code.blank().push("NSURLSession *session = [NSURLSession sharedSession];").push("NSURLSessionDataTask *dataTask = [session dataTaskWithRequest:request").push("                                            completionHandler:^(NSData *data, NSURLResponse *response, NSError *error) {").push(1, "                                            if (error) {").push(2, "                                            NSLog(@\"%@\", error);").push(1, "                                            } else {").push(2, "                                            NSHTTPURLResponse *httpResponse = (NSHTTPURLResponse *) response;").push(2, "                                            NSLog(@\"%@\", httpResponse);").push(1, "                                            }").push("                                            }];").push("[dataTask resume];").blank();
        return code.join();
    }
}

