/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.http;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public final class MediaType {
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_JSON = "application/json";
    public static final String TEXT_JSON = "text/json";
    public static final String TEXT_X_JSON = "text/x-json";
    public static final String APPLICATION_X_JSON = "application/x-json";
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final String MULTIPART_RELATED = "multipart/related";
    public static final String MULTIPART_ALTERNATIVE = "multipart/alternative";
    public static final List<String> MULTIPART_MEDIA_TYPES = Collections.unmodifiableList(Arrays.asList("multipart/form-data", "multipart/mixed", "multipart/related", "multipart/alternative"));
    public static final List<String> JSON_MEDIA_TYPES = Collections.unmodifiableList(Arrays.asList("application/json", "application/x-json", "text/json", "text/x-json"));
    public static final String TEXT_PLAIN = "text/plain";

    public static final boolean isMultipartMediaType(String header) {
        return MULTIPART_MEDIA_TYPES.contains(header);
    }

    public static final boolean isJsonMediaType(String header) {
        return JSON_MEDIA_TYPES.contains(header);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private MediaType() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

