/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.models.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.github.atkawa7.har.HarCookie;
import io.github.atkawa7.har.HarHeader;
import io.github.atkawa7.har.HarParam;
import io.github.atkawa7.har.HarPostData;
import io.github.atkawa7.har.HarQueryString;
import io.github.atkawa7.har.HarRequest;
import io.github.atkawa7.httpsnippet.http.HttpMethod;
import io.github.atkawa7.httpsnippet.http.HttpVersion;
import io.github.atkawa7.httpsnippet.models.internal.URLWrapper;
import io.github.atkawa7.httpsnippet.utils.HarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class CodeRequest {
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    private final String method;
    private final String httpVersion;
    private final List<HarCookie> cookies;
    private final List<HarHeader> headers;
    private final List<HarQueryString> queryStrings;
    private final List<HarParam> params;
    private final String mimeType;
    private final String text;
    private final String _cookieString;
    private final boolean _hasText;
    private final boolean _hasParams;
    private final boolean _hasHeaders;
    private final boolean _hasCookies;
    private final boolean _hasQueryStrings;
    private final boolean _hasAttachments;
    private Map<String, String> _headers;
    private Map<String, String> _allHeaders;
    private Map<String, List<String>> _queryStrings;
    private Map<String, String> _params;
    private Map<String, String> _cookies;
    private URLWrapper urlWrapper;

    private CodeRequest(HarRequest harRequest) throws Exception {
        Objects.requireNonNull(harRequest, "Har Request cannot be null");
        this.urlWrapper = new URLWrapper(harRequest);
        this.method = HttpMethod.resolve(harRequest.getMethod()).name();
        this.headers = HarUtils.processHeaders(harRequest);
        this.cookies = HarUtils.processCookies(harRequest);
        this.queryStrings = HarUtils.processQueryStrings(this.urlWrapper.getQueryStrings());
        this.httpVersion = HttpVersion.resolve(harRequest.getHttpVersion()).getProtocolName();
        HarPostData harPostData = harRequest.getPostData();
        String mimeType = Objects.nonNull(harPostData) ? harPostData.getMimeType() : null;
        String text = Objects.nonNull(harPostData) ? harPostData.getText() : null;
        this.params = HarUtils.processParams(harPostData);
        this.mimeType = HarUtils.defaultMimeType(mimeType);
        this.text = (String)StringUtils.defaultIfEmpty((CharSequence)text, (CharSequence)"");
        this._cookieString = this.cookies.stream().map(e -> e.getName() + "=" + e.getValue()).collect(Collectors.joining("; "));
        this._hasText = StringUtils.isNotEmpty((CharSequence)text);
        this._hasParams = ObjectUtils.isNotEmpty(this.params);
        this._hasHeaders = ObjectUtils.isNotEmpty(this.headers);
        this._hasCookies = ObjectUtils.isNotEmpty(this.cookies);
        this._hasQueryStrings = this.urlWrapper.hasQueryStrings();
        this._hasAttachments = this.params.stream().filter(h -> StringUtils.isNotBlank((CharSequence)h.getFileName())).findFirst().isPresent();
        this._headers = this.headers.stream().collect(Collectors.toMap(HarHeader::getName, HarHeader::getValue));
        this._cookies = new HashMap<String, String>();
        if (this._hasCookies) {
            this._cookies.put("Cookie", this._cookieString);
        }
        this._params = this.params.stream().filter(h -> StringUtils.isNotBlank((CharSequence)h.getValue())).collect(Collectors.toMap(HarParam::getName, HarParam::getValue));
        this._queryStrings = this.queryStringsToMap();
        this._allHeaders = new HashMap<String, String>();
        this._allHeaders.putAll(this._headers);
        this._allHeaders.putAll(this._cookies);
        this.validateMimeType();
    }

    private void validateMimeType() throws Exception {
        if ("application/json".equalsIgnoreCase(this.mimeType)) {
            HarUtils.validateJSON(this.text);
        } else if ("application/x-www-form-urlencoded".equalsIgnoreCase(this.mimeType) ? !this._hasParams : "multipart/form-data".equalsIgnoreCase(this.mimeType) && !this._hasParams) {
            throw new Exception("Params cannot be empty");
        }
    }

    public Map<String, List<String>> queryStringsToMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (HarQueryString queryString : this.queryStrings) {
            String key = queryString.getName();
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            ((List)map.get(key)).add(queryString.getValue());
        }
        return map;
    }

    public Optional<HarHeader> find(String headerName) {
        return this.headers.stream().filter(harHeader -> Objects.nonNull(harHeader) && Objects.nonNull(harHeader.getName()) && harHeader.getName().equalsIgnoreCase(headerName)).findFirst();
    }

    public String getMethod() {
        return this.method;
    }

    public String toJsonString() throws Exception {
        return HarUtils.toJsonString(this.text);
    }

    public String toPrettyJsonString() throws Exception {
        return HarUtils.toPrettyJsonString(this.fromJsonString());
    }

    public Map<String, Object> fromJsonString() throws Exception {
        return HarUtils.fromJsonString(this.text);
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public List<HarCookie> getCookies() {
        return this.cookies;
    }

    public List<HarHeader> getHeaders() {
        return this.headers;
    }

    public List<HarQueryString> getQueryStrings() {
        return this.queryStrings;
    }

    public List<HarParam> getParams() {
        return this.params;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getText() {
        return this.text;
    }

    public boolean hasText() {
        return this._hasText;
    }

    public boolean hasParams() {
        return this._hasParams;
    }

    public boolean hasHeaders() {
        return this._hasHeaders;
    }

    public boolean hasCookies() {
        return this._hasCookies;
    }

    public boolean hasHeadersAndCookies() {
        return this._hasHeaders || this._hasCookies;
    }

    public boolean hasQueryStrings() {
        return this._hasQueryStrings;
    }

    public boolean hasAttachments() {
        return this._hasAttachments;
    }

    public boolean hasBody() {
        return this._hasText || this._hasParams;
    }

    public Map<String, String> headersAsMap() {
        return this._headers;
    }

    public Map<String, String> allHeadersAsMap() {
        return this.newMap(this._allHeaders);
    }

    public Map<String, List<String>> queryStringsAsMap() {
        HashMap<String, List<String>> newMap = new HashMap<String, List<String>>();
        newMap.putAll(this._queryStrings);
        return newMap;
    }

    public Map<String, String> paramsAsMap() {
        return this._params;
    }

    public Map<String, String> cookiesAsMap() {
        return this._cookies;
    }

    public String getCookieString() {
        return this._cookieString;
    }

    public String paramsToJSONString() throws JsonProcessingException {
        return HarUtils.toJsonString(this._params);
    }

    public String paramsToPrettyJSONString() throws JsonProcessingException {
        return HarUtils.toPrettyJsonString(this._params);
    }

    public String paramsToString() {
        return this.params.stream().map(e -> e.getName() + "=" + e.getValue()).collect(Collectors.joining("&"));
    }

    public Map<String, Object> unwrapQueryStrings() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, List<String>> entry : this._queryStrings.entrySet()) {
            if (entry.getValue().size() == 1) {
                result.put(entry.getKey(), entry.getValue().get(0));
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public String queryStringsToJsonString() throws JsonProcessingException {
        return HarUtils.toPrettyJsonString(this.unwrapQueryStrings());
    }

    public String headersToJsonString(boolean pretty) throws JsonProcessingException {
        return pretty ? HarUtils.toPrettyJsonString(this._headers) : HarUtils.toJsonString(this.headers);
    }

    public String headersToJsonString() throws JsonProcessingException {
        return this.headersToJsonString(true);
    }

    public String allHeadersToJsonString(boolean pretty) throws JsonProcessingException {
        return pretty ? HarUtils.toPrettyJsonString(this._allHeaders) : HarUtils.toJsonString(this._allHeaders);
    }

    public String allHeadersToJsonString() throws JsonProcessingException {
        return this.allHeadersToJsonString(false);
    }

    public Map<String, String> newMap(Map<String, String> map) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.putAll(map);
        return newMap;
    }

    public String getHost() {
        return this.urlWrapper.url().getHost();
    }

    public int getPort() {
        return this.urlWrapper.getPort();
    }

    public String getProtocol() {
        return this.urlWrapper.url().getProtocol();
    }

    public String getPath() {
        return this.urlWrapper.getPath();
    }

    public String getFullPath() {
        return this.urlWrapper.getFullPath();
    }

    public String getUrl() {
        return this.urlWrapper.getUrl();
    }

    public String getFullUrl() {
        return this.urlWrapper.getFullUrl();
    }

    public boolean isSecure() {
        return this.urlWrapper.isSecure();
    }

    public static CodeRequest newCodeRequest(HarRequest harRequest) throws Exception {
        return new CodeRequest(harRequest);
    }

    public boolean isDefaultPort() {
        return this.urlWrapper.isDefaultPort();
    }
}

