/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.builder;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class CodeBuilder {
    public static final String EOL = "\n";
    public static final String TAB = "\t";
    public static final String EMPTY = "";
    public static final String SPACE = "  ";
    private List<String> code;
    private String indentation;
    private String lineJoin;

    public CodeBuilder() {
        this(TAB);
    }

    public CodeBuilder(String indentation) {
        this(indentation, EOL);
    }

    public CodeBuilder(String indentation, String lineJoin) {
        this.indentation = indentation;
        this.lineJoin = lineJoin;
        this.code = new ArrayList<String>();
    }

    public StringBuilder fill(int indentationLevel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(EMPTY);
        while (indentationLevel > 0) {
            stringBuilder.append(this.indentation);
            --indentationLevel;
        }
        return stringBuilder;
    }

    public String buildLine(String line) {
        StringBuilder stringBuilder = this.fill(0);
        stringBuilder.append(line);
        return line;
    }

    public String buildLine(String line, String ... args) {
        StringBuilder stringBuilder = this.fill(0);
        stringBuilder.append(line);
        return String.format(stringBuilder.toString(), args);
    }

    public String buildLine(int indentationLevel, String line) {
        StringBuilder stringBuilder = this.fill(indentationLevel);
        stringBuilder.append(line);
        return stringBuilder.toString();
    }

    public String buildLine(int indentationLevel, String line, String ... args) {
        StringBuilder stringBuilder = this.fill(indentationLevel);
        stringBuilder.append(line);
        return String.format(stringBuilder.toString(), args);
    }

    public CodeBuilder push(String line) {
        this.code.add(this.buildLine(line));
        return this;
    }

    public CodeBuilder push(String line, String ... args) {
        this.code.add(this.buildLine(line, args));
        return this;
    }

    public CodeBuilder push(int indentationLevel, String line) {
        this.code.add(this.buildLine(indentationLevel, line));
        return this;
    }

    public CodeBuilder push(int indentationLevel, String line, String ... args) {
        this.code.add(this.buildLine(indentationLevel, line, args));
        return this;
    }

    public CodeBuilder blank() {
        this.code.add(EMPTY);
        return this;
    }

    public String join(String lineJoin) {
        return String.join((CharSequence)lineJoin, this.code);
    }

    public String join() {
        return this.join(this.lineJoin);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<String> getCode() {
        return this.code;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getIndentation() {
        return this.indentation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLineJoin() {
        return this.lineJoin;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCode(List<String> code) {
        this.code = code;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setIndentation(String indentation) {
        this.indentation = indentation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setLineJoin(String lineJoin) {
        this.lineJoin = lineJoin;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeBuilder)) {
            return false;
        }
        CodeBuilder other = (CodeBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$code = this.getCode();
        List<String> other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$indentation = this.getIndentation();
        String other$indentation = other.getIndentation();
        if (this$indentation == null ? other$indentation != null : !this$indentation.equals(other$indentation)) {
            return false;
        }
        String this$lineJoin = this.getLineJoin();
        String other$lineJoin = other.getLineJoin();
        return !(this$lineJoin == null ? other$lineJoin != null : !this$lineJoin.equals(other$lineJoin));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CodeBuilder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $indentation = this.getIndentation();
        result = result * 59 + ($indentation == null ? 43 : $indentation.hashCode());
        String $lineJoin = this.getLineJoin();
        result = result * 59 + ($lineJoin == null ? 43 : $lineJoin.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CodeBuilder(code=" + this.getCode() + ", indentation=" + this.getIndentation() + ", lineJoin=" + this.getLineJoin() + ")";
    }
}

