/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.generators;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.atkawa7.har.HarRequest;
import io.github.atkawa7.httpsnippet.models.Client;
import io.github.atkawa7.httpsnippet.models.Language;
import io.github.atkawa7.httpsnippet.models.internal.CodeRequest;
import io.github.atkawa7.httpsnippet.utils.HarUtils;
import java.util.Objects;
import lombok.Generated;

public abstract class CodeGenerator {
    protected final Client client;
    protected final Language language;
    protected final String displayName;

    protected CodeGenerator(Client client, Language language) {
        Objects.requireNonNull(client, "Client cannot be null");
        Objects.requireNonNull(language, "Language cannot be null");
        this.client = client;
        this.language = language;
        this.displayName = String.format("%s:%s", language.getTitle(), client.getTitle());
    }

    public String code(HarRequest harRequest) throws Exception {
        return this.generateCode(CodeRequest.newCodeRequest(harRequest));
    }

    protected abstract String generateCode(CodeRequest var1) throws Exception;

    protected String toJson(Object value) throws Exception {
        return HarUtils.toJsonString(value);
    }

    protected String toPrettyJson(Object value) throws Exception {
        return HarUtils.toPrettyJsonString(value);
    }

    public String toString() {
        return this.displayName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Client getClient() {
        return this.client;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Language getLanguage() {
        return this.language;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }
}

