/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.generators.c;

import io.github.atkawa7.httpsnippet.builder.CodeBuilder;
import io.github.atkawa7.httpsnippet.generators.CodeGenerator;
import io.github.atkawa7.httpsnippet.models.Client;
import io.github.atkawa7.httpsnippet.models.Language;
import io.github.atkawa7.httpsnippet.models.internal.CodeRequest;
import org.apache.commons.lang3.StringUtils;

public class LibCurl
extends CodeGenerator {
    public LibCurl() {
        super(Client.LIBCURL, Language.C);
    }

    @Override
    protected String generateCode(CodeRequest codeRequest) throws Exception {
        CodeBuilder code = new CodeBuilder();
        code.push("CURL *hnd = curl_easy_init();").blank();
        if (!codeRequest.getMimeType().equalsIgnoreCase("multipart/form-data")) {
            code.push("curl_easy_setopt(hnd, CURLOPT_CUSTOMREQUEST, \"%s\");", codeRequest.getMethod().toUpperCase());
        }
        code.push("curl_easy_setopt(hnd, CURLOPT_URL, \"%s\");", codeRequest.getFullUrl());
        if (codeRequest.hasHeaders()) {
            code.blank().push("struct curl_slist *headers = NULL;");
            codeRequest.getHeaders().forEach(harHeader -> code.push("headers = curl_slist_append(headers, \"%s: %s\");", harHeader.getName(), harHeader.getValue()));
            code.push("curl_easy_setopt(hnd, CURLOPT_HTTPHEADER, headers);");
        }
        if (codeRequest.hasCookies()) {
            code.blank().push("curl_easy_setopt(hnd, CURLOPT_COOKIE, \"%s\");", codeRequest.getCookieString());
        }
        if (codeRequest.hasBody()) {
            switch (codeRequest.getMimeType()) {
                case "application/json": {
                    if (!codeRequest.hasText()) break;
                    code.blank().push("curl_easy_setopt(hnd, CURLOPT_POSTFIELDS, %s);", codeRequest.toJsonString());
                    break;
                }
                case "application/x-www-form-urlencoded": {
                    if (!codeRequest.hasParams()) break;
                    code.blank().push("curl_easy_setopt(hnd, CURLOPT_POSTFIELDS, %s);", this.toJson(codeRequest.paramsToString()));
                    break;
                }
                case "multipart/form-data": {
                    if (!codeRequest.hasParams()) break;
                    code.blank().push("struct curl_httppost* post = NULL;").push("struct curl_httppost* last = NULL;").blank();
                    codeRequest.getParams().forEach(p -> {
                        if (StringUtils.isNotBlank((CharSequence)p.getFileName())) {
                            code.push("curl_formadd(&post, &last, CURLFORM_COPYNAME, \"%s\", CURLFORM_FILE, \"%s\", CURLFORM_END)", p.getName(), p.getFileName());
                        } else if (StringUtils.isNotBlank((CharSequence)p.getContentType())) {
                            code.push("curl_formadd(&post, &last, CURLFORM_COPYNAME, \"%s\", CURLFORM_COPYCONTENTS, \"%s\", CURLFORM_CONTENTTYPE, \"%s\", CURLFORM_END);", p.getName(), p.getValue(), p.getValue());
                        } else {
                            code.push("curl_formadd(&post, &last, CURLFORM_COPYNAME, \"%s\", CURLFORM_COPYCONTENTS, \"%s\", CURLFORM_END);", p.getName(), p.getValue());
                        }
                    });
                    code.blank().push("curl_easy_setopt(hnd, CURLOPT_HTTPPOST, post)");
                    break;
                }
                default: {
                    if (!codeRequest.hasText()) break;
                    code.blank().push("curl_easy_setopt(hnd, CURLOPT_POSTFIELDS, \"%s\");", codeRequest.getText());
                }
            }
        }
        code.blank().push("CURLcode ret = curl_easy_perform(hnd);").blank();
        return code.join();
    }
}

