/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.generators.clojure;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.atkawa7.har.HarHeader;
import io.github.atkawa7.har.HarParam;
import io.github.atkawa7.httpsnippet.builder.CodeBuilder;
import io.github.atkawa7.httpsnippet.generators.CodeGenerator;
import io.github.atkawa7.httpsnippet.models.Client;
import io.github.atkawa7.httpsnippet.models.Language;
import io.github.atkawa7.httpsnippet.models.internal.CodeRequest;
import io.github.atkawa7.httpsnippet.utils.HarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class CljHttp
extends CodeGenerator {
    private static final List<String> SUPPORTED_METHODS = Arrays.asList("get", "post", "put", "delete", "patch", "head", "options");

    public CljHttp() {
        super(Client.CJ_HTTP, Language.CLOJURE);
    }

    private boolean isNotSupported(String method) {
        return !SUPPORTED_METHODS.contains(method.toLowerCase());
    }

    private String padBlock(int max, String input) {
        StringBuilder padding = new StringBuilder();
        for (int len = max; len > 0; --len) {
            padding.append(" ");
        }
        return input.replace("\n", "\n" + padding);
    }

    private <T> String literalRepresentation(T value) {
        if (Objects.isNull(value)) {
            return "nil";
        }
        if (value instanceof String) {
            return "\"" + ((String)value).replace("\"", "\\\"") + "\"";
        }
        if (value instanceof CljFile || value instanceof CljKeyword) {
            return value.toString();
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<String> listBuilder = new ArrayList<String>();
            for (Object obj : list) {
                listBuilder.add(this.literalRepresentation(obj));
            }
            return "[" + this.padBlock(1, String.join((CharSequence)" ", listBuilder)) + "]";
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            ArrayList<String> listBuilder = new ArrayList<String>();
            for (Map.Entry entry : map.entrySet()) {
                int length = entry.getKey().toString().length();
                String val = this.padBlock(length + 2, this.literalRepresentation(entry.getValue()));
                String format = String.format(":%s %s", entry.getKey(), val);
                listBuilder.add(format);
            }
            return "{" + this.padBlock(1, String.join((CharSequence)"\n ", listBuilder)) + "}";
        }
        return HarUtils.defaultIfNull(value, "");
    }

    @Override
    protected String generateCode(CodeRequest codeRequest) throws Exception {
        if (this.isNotSupported(codeRequest.getMethod())) {
            throw new RuntimeException(String.format("Request method %s", codeRequest.getMethod()));
        }
        CodeBuilder code = new CodeBuilder();
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        Optional<HarHeader> optionalHarHeader = codeRequest.find("Accept");
        if (codeRequest.hasHeadersAndCookies()) {
            Map<String, String> map = codeRequest.allHeadersAsMap();
            map.remove("Content-Type".toLowerCase());
            optionalHarHeader.ifPresent(harHeader -> {
                if ("application/json".equalsIgnoreCase(harHeader.getValue())) {
                    map.remove("Accept".toLowerCase());
                }
            });
            HashMap lowercaseMap = new HashMap();
            map.forEach((k, v) -> lowercaseMap.put(k.toLowerCase(), v));
            if (lowercaseMap.size() > 0) {
                body.put("headers", lowercaseMap);
            }
        }
        if (codeRequest.hasQueryStrings()) {
            body.put("query-params", codeRequest.unwrapQueryStrings());
        }
        if (codeRequest.hasBody()) {
            switch (codeRequest.getMimeType()) {
                case "application/json": {
                    if (!codeRequest.hasText()) break;
                    body.put("content-type", new CljKeyword("json"));
                    body.put("form-params", codeRequest.fromJsonString());
                    break;
                }
                case "application/x-www-form-urlencoded": {
                    if (!codeRequest.hasParams()) break;
                    body.put("form-params", codeRequest.paramsAsMap());
                    break;
                }
                case "multipart/form-data": {
                    if (!codeRequest.hasParams()) break;
                    ArrayList multipart = new ArrayList();
                    for (HarParam param : codeRequest.getParams()) {
                        HashMap<String, String> content = new HashMap<String, String>();
                        String value = StringUtils.isNotBlank((CharSequence)param.getFileName()) && StringUtils.isBlank((CharSequence)param.getValue()) ? new CljFile(param.getFileName()) : param.getValue();
                        content.put("name", param.getName());
                        content.put("content", value);
                        multipart.add(content);
                    }
                    body.put("multipart", multipart);
                    break;
                }
                default: {
                    body.put("body", codeRequest.getText());
                }
            }
        }
        optionalHarHeader.ifPresent(harHeader -> {
            if ("application/json".equalsIgnoreCase(harHeader.getValue())) {
                body.put("accept", new CljKeyword("json"));
            }
        });
        code.push("(require '[clj-http.client :as client])\n");
        if (ObjectUtils.isEmpty(body)) {
            code.push("(client/%s \"%s\")", codeRequest.getMethod().toLowerCase(), codeRequest.getUrl());
        } else {
            code.push("(client/%s \"%s\" %s)", codeRequest.getMethod().toLowerCase(), codeRequest.getUrl(), this.padBlock(11 + codeRequest.getMethod().length() + codeRequest.getUrl().length(), this.literalRepresentation(body)));
        }
        code.blank();
        return code.join();
    }

    static class CljKeyword {
        private final String name;

        public String toString() {
            return ':' + this.name;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CljKeyword(String name) {
            this.name = name;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getName() {
            return this.name;
        }
    }

    static class CljFile {
        private final String path;

        public String toString() {
            return "(clojure.java.io/file \"" + this.path + "\")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CljFile(String path) {
            this.path = path;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getPath() {
            return this.path;
        }
    }
}

