/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.generators.go;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.atkawa7.httpsnippet.builder.CodeBuilder;
import io.github.atkawa7.httpsnippet.generators.CodeGenerator;
import io.github.atkawa7.httpsnippet.models.Client;
import io.github.atkawa7.httpsnippet.models.Language;
import io.github.atkawa7.httpsnippet.models.internal.CodeRequest;
import lombok.Generated;

public class GoNative
extends CodeGenerator {
    private boolean showBoilerplate = true;
    private boolean checkErrors = false;
    private boolean printBody = true;
    private int timeout = -1;

    public GoNative() {
        super(Client.GO, Language.GO);
    }

    public String errorPlaceholder() {
        return this.checkErrors ? "err" : "_";
    }

    public int indent() {
        return this.showBoilerplate ? 1 : 0;
    }

    public void errorCheck(CodeBuilder builder) {
        int indent = this.indent();
        if (this.checkErrors) {
            builder.push(indent, "if err != nil {").push(indent + 1, "panic(err)").push(indent, "}");
        }
    }

    @Override
    protected String generateCode(CodeRequest codeRequest) throws Exception {
        String client;
        CodeBuilder codeBuilder = new CodeBuilder("\t");
        int indent = this.indent();
        String errorPlaceholder = this.errorPlaceholder();
        if (this.showBoilerplate) {
            codeBuilder.push("package main").blank().push("import (").push(indent, "\"fmt\"");
            if (this.timeout > 0) {
                codeBuilder.push(indent, "\"time\"");
            }
            if (codeRequest.hasBody()) {
                codeBuilder.push(indent, "\"strings\"");
            }
            codeBuilder.push(indent, "\"net/http\"");
            if (this.printBody) {
                codeBuilder.push(indent, "\"io/ioutil\"");
            }
            codeBuilder.push(")").blank().push("func main() {").blank();
        }
        if (this.timeout > 0) {
            client = "client";
            codeBuilder.push(indent, "client := http.Client{").push(indent + 1, "Timeout: time.Duration(%s * time.Second),", Integer.toString(this.timeout)).push(indent, "}").blank();
        } else {
            client = "http.DefaultClient";
        }
        codeBuilder.push(indent, "url := \"%s\"", codeRequest.getFullUrl()).blank();
        if (codeRequest.hasText()) {
            codeBuilder.push(indent, "payload := strings.NewReader(%s)", codeRequest.toJsonString()).blank().push(indent, "req, %s := http.NewRequest(\"%s\", url, payload)", errorPlaceholder, codeRequest.getMethod()).blank();
        } else if (codeRequest.hasParams()) {
            codeBuilder.push(indent, "payload := strings.NewReader(\"%s\")", codeRequest.paramsToString()).blank().push(indent, "req, %s := http.NewRequest(\"%s\", url, payload)", errorPlaceholder, codeRequest.getMethod()).blank();
        } else {
            codeBuilder.push(indent, "req, %s := http.NewRequest(\"%s\", url, nil)", errorPlaceholder, codeRequest.getMethod()).blank();
        }
        this.errorCheck(codeBuilder);
        if (codeRequest.hasHeadersAndCookies()) {
            codeRequest.allHeadersAsMap().forEach((k, v) -> codeBuilder.push(indent, "req.Header.Add(\"%s\", \"%s\")", (String)k, (String)v));
            codeBuilder.blank();
        }
        codeBuilder.push(indent, "res, %s := %s.Do(req)", errorPlaceholder, client);
        this.errorCheck(codeBuilder);
        if (this.printBody) {
            codeBuilder.blank().push(indent, "defer res.Body.Close()").push(indent, "body, %s := ioutil.ReadAll(res.Body)", errorPlaceholder);
            this.errorCheck(codeBuilder);
        }
        codeBuilder.blank().push(indent, "fmt.Println(res)");
        if (this.printBody) {
            codeBuilder.push(indent, "fmt.Println(string(body))");
        }
        if (this.showBoilerplate) {
            codeBuilder.blank().push("}");
        }
        codeBuilder.blank();
        return codeBuilder.join();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setShowBoilerplate(boolean showBoilerplate) {
        this.showBoilerplate = showBoilerplate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCheckErrors(boolean checkErrors) {
        this.checkErrors = checkErrors;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPrintBody(boolean printBody) {
        this.printBody = printBody;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

