/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.generators.javascript;

import io.github.atkawa7.har.HarParam;
import io.github.atkawa7.httpsnippet.builder.CodeBuilder;
import io.github.atkawa7.httpsnippet.generators.CodeGenerator;
import io.github.atkawa7.httpsnippet.models.Client;
import io.github.atkawa7.httpsnippet.models.Language;
import io.github.atkawa7.httpsnippet.models.internal.CodeRequest;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;

public class JQuery
extends CodeGenerator {
    private final Boolean async = Boolean.TRUE;
    private final Boolean crossDomain = Boolean.TRUE;

    public JQuery() {
        super(Client.JQUERY, Language.JAVASCRIPT);
    }

    @Override
    protected String generateCode(CodeRequest codeRequest) throws Exception {
        CodeBuilder code = new CodeBuilder("  ");
        LinkedHashMap<String, Object> settings = new LinkedHashMap<String, Object>();
        settings.put("async", this.async);
        settings.put("crossDomain", this.crossDomain);
        settings.put("url", codeRequest.getFullUrl());
        settings.put("method", codeRequest.getMethod());
        settings.put("headers", codeRequest.allHeadersAsMap());
        if (codeRequest.hasBody()) {
            switch (codeRequest.getMimeType()) {
                case "application/x-www-form-urlencoded": {
                    if (!codeRequest.hasParams()) break;
                    settings.put("data", codeRequest.paramsAsMap());
                    break;
                }
                case "application/json": {
                    if (!codeRequest.hasText()) break;
                    settings.put("processData", Boolean.FALSE);
                    settings.put("data", codeRequest.getText());
                    break;
                }
                case "multipart/form-data": {
                    if (!codeRequest.hasParams()) break;
                    code.push("var form = new FormData();");
                    for (HarParam harParam : codeRequest.getParams()) {
                        String value = (String)StringUtils.firstNonEmpty((CharSequence[])new String[]{harParam.getFileName(), harParam.getValue(), "  "});
                        code.push("form.append(%s, %s);", this.toJson(harParam.getName()), this.toJson(value));
                    }
                    settings.put("processData", Boolean.FALSE);
                    settings.put("contentType", Boolean.FALSE);
                    settings.put("mimeType", "multipart/form-data");
                    settings.put("data", "[form]");
                    code.blank();
                    break;
                }
                default: {
                    if (!codeRequest.hasText()) break;
                    settings.put("data", codeRequest.getText());
                }
            }
        }
        code.push("var settings = " + this.toPrettyJson(settings).replace("\"[form]\"", "form")).blank().push("$.ajax(settings).done(function (response) {").push(1, "console.log(response);").push("});").blank();
        return code.join();
    }
}

