/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.generators.shell;

import io.github.atkawa7.har.HarParam;
import io.github.atkawa7.httpsnippet.builder.CodeBuilder;
import io.github.atkawa7.httpsnippet.generators.CodeGenerator;
import io.github.atkawa7.httpsnippet.http.HttpVersion;
import io.github.atkawa7.httpsnippet.models.Client;
import io.github.atkawa7.httpsnippet.models.Language;
import io.github.atkawa7.httpsnippet.models.internal.CodeRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class Curl
extends CodeGenerator {
    public Curl() {
        super(Client.CURL, Language.SHELL);
    }

    public String quote(String value) {
        return String.format("'%s'", value.replace("'", "\"'\""));
    }

    @Override
    protected String generateCode(CodeRequest codeRequest) throws Exception {
        String indent = " ";
        boolean _short = false;
        boolean _binary = false;
        CodeBuilder code = new CodeBuilder(indent, indent + "\\\n  ");
        code.push("curl %s %s", _short ? "-X" : "--request", codeRequest.getMethod()).push(String.format("%s%s", _short ? "" : "--url ", this.quote(codeRequest.getFullUrl())));
        if (HttpVersion.HTTP_1_0.equalsIgnoreCase(codeRequest.getHttpVersion())) {
            code.push(_short ? "-0" : "--http1.0");
        }
        if (codeRequest.hasHeaders()) {
            codeRequest.getHeaders().forEach(harHeader -> {
                String header = String.format("%s: %s", harHeader.getName(), harHeader.getValue());
                code.push("%s %s", _short ? "-H" : "--header", this.quote(header));
            });
        }
        if (codeRequest.hasCookies()) {
            code.push("%s %s", _short ? "-b" : "--cookie", this.quote(codeRequest.getCookieString()));
        }
        if (codeRequest.hasBody()) {
            switch (codeRequest.getMimeType()) {
                case "multipart/form-data": {
                    if (!codeRequest.hasParams()) break;
                    for (HarParam param : codeRequest.getParams()) {
                        String post = StringUtils.isNotEmpty((CharSequence)param.getFileName()) ? String.format("%s=@%s", param.getName(), param.getFileName()) : String.format("%s=%s", param.getName(), param.getValue());
                        code.push("%s %s", _short ? "-F" : "--form", this.quote(this.toJson(post)));
                    }
                    break;
                }
                case "application/x-www-form-urlencoded": {
                    if (codeRequest.hasParams()) {
                        for (HarParam param : codeRequest.getParams()) {
                            code.push("%s %s", _binary ? "--data-binary" : (_short ? "-d" : "--data"), this.quote(String.format("%s=%s", param.getName(), param.getValue())));
                        }
                        break;
                    }
                    code.push("%s %s", _binary ? "--data-binary" : (_short ? "-d" : "--data"), StringEscapeUtils.escapeXSI((String)this.quote(codeRequest.getText())));
                    break;
                }
                default: {
                    code.push("%s %s", _binary ? "--data-binary" : (_short ? "-d" : "--data"), this.quote(codeRequest.getText()));
                }
            }
        }
        return code.join();
    }
}

