/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.models.internal;

import io.github.atkawa7.har.HarQueryString;
import io.github.atkawa7.har.HarRequest;
import io.github.atkawa7.httpsnippet.http.HttpScheme;
import io.github.atkawa7.httpsnippet.utils.HarUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

final class URLWrapper {
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    public static final String FORWARD_SLASH = "/";
    private final String fullUrl;
    private final String url;
    private final int _port;
    private final boolean _hasQueryStrings;
    private final boolean _isSecure;
    private final List<HarQueryString> queryStrings;
    private final URL _url;
    private final URL _fullUrl;
    private final String _path;
    private final String _fullPath;

    public URLWrapper(HarRequest harRequest) throws Exception {
        AbstractMap.SimpleEntry<URL, List<HarQueryString>> entry = URLWrapper.newTuple(harRequest);
        this._fullUrl = entry.getKey();
        this._url = new URL(this._fullUrl.getProtocol(), this._fullUrl.getHost(), this._fullUrl.getPort(), this._fullUrl.getPath());
        this.queryStrings = entry.getValue();
        this._hasQueryStrings = ObjectUtils.isNotEmpty(this.queryStrings);
        this.url = this._url.toString();
        this.fullUrl = this._fullUrl.toString();
        this._isSecure = HttpScheme.HTTPS.equalsIgnoreCase(this._fullUrl.getProtocol());
        this._port = this.newPort();
        this._fullPath = StringUtils.isNotBlank((CharSequence)this._fullUrl.getFile()) ? this._fullUrl.getFile() : FORWARD_SLASH;
        this._path = StringUtils.isNotBlank((CharSequence)this._url.getFile()) ? this._url.getFile() : FORWARD_SLASH;
    }

    public String getFullUrl() {
        return this._hasQueryStrings ? this.fullUrl : this.url;
    }

    public String getUrl() {
        return this.url;
    }

    public int getPort() {
        return this._port;
    }

    public boolean hasQueryStrings() {
        return this._hasQueryStrings;
    }

    public boolean isSecure() {
        return this._isSecure;
    }

    public List<HarQueryString> getQueryStrings() {
        return this.queryStrings;
    }

    public URL url() {
        return this._url;
    }

    public URL fullUrl() {
        return this._fullUrl;
    }

    public String getPath() {
        return this._path;
    }

    public String getFullPath() {
        return this._hasQueryStrings ? this._fullPath : this._path;
    }

    private int newPort() {
        if (this._fullUrl.getPort() <= 0) {
            return this._isSecure ? 443 : 80;
        }
        return this._fullUrl.getPort();
    }

    private static Set<Tuple> parse(@NonNull URL url) throws Exception {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        HashSet<Tuple> queryStrings = new HashSet<Tuple>();
        String query = url.getQuery();
        if (StringUtils.isNotEmpty((CharSequence)query)) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                int index = pair.indexOf("=");
                String key = index > 0 ? URLDecoder.decode(pair.substring(0, index), "UTF-8") : pair;
                String value = index > 0 && pair.length() > index + 1 ? URLDecoder.decode(pair.substring(index + 1), "UTF-8") : "";
                queryStrings.add(new Tuple(key, value));
            }
        }
        return queryStrings;
    }

    private static List<Tuple> toTuples(List<HarQueryString> harQueryStrings) {
        return harQueryStrings.stream().map(h -> new Tuple(h.getName(), h.getValue())).collect(Collectors.toList());
    }

    private static String toQuery(Set<Tuple> tupleSet) {
        return tupleSet.stream().map(t -> String.format("%s=%s", t.getKey(), Objects.isNull(t.getValue()) ? "" : t.getValue())).collect(Collectors.joining("&"));
    }

    private static AbstractMap.SimpleEntry<URL, List<HarQueryString>> newTuple(HarRequest harRequest) throws Exception {
        List<HarQueryString> harQueryStrings = HarUtils.defaultIfNull(harRequest.getQueryString());
        String url = harRequest.getUrl();
        try {
            TreeSet<Tuple> tupleSet = new TreeSet<Tuple>();
            URL oldUrl = new URL(url);
            Set<Tuple> parsedTupleSet = URLWrapper.parse(oldUrl);
            tupleSet.addAll(parsedTupleSet);
            tupleSet.addAll(URLWrapper.toTuples(harQueryStrings));
            String newQuery = URLWrapper.toQuery(tupleSet);
            List result = tupleSet.stream().map(t -> new HarQueryString((String)t.getKey(), (String)t.getValue(), null)).collect(Collectors.toList());
            String file = String.format("%s?%s", oldUrl.getPath(), newQuery);
            URL newUrl = new URL(oldUrl.getProtocol(), oldUrl.getHost(), oldUrl.getPort(), file);
            return new AbstractMap.SimpleEntry<URL, List<HarQueryString>>(newUrl, result);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            throw new Exception("Malformed url");
        }
    }

    public boolean isDefaultPort() {
        return this._port == 80 || this._port == 443;
    }

    static class Tuple
    extends AbstractMap.SimpleEntry<String, String>
    implements Comparable<Tuple> {
        private Tuple(String key, String value) {
            super(key, value);
        }

        @Override
        public int compareTo(Tuple o) {
            int r = ((String)this.getKey()).compareTo((String)o.getKey());
            return r == 0 ? ((String)this.getValue()).compareTo((String)o.getValue()) : r;
        }
    }
}

