/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.httpsnippet.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.atkawa7.har.HarCookie;
import io.github.atkawa7.har.HarHeader;
import io.github.atkawa7.har.HarParam;
import io.github.atkawa7.har.HarPostData;
import io.github.atkawa7.har.HarQueryString;
import io.github.atkawa7.har.HarRequest;
import io.github.atkawa7.httpsnippet.http.MediaType;
import io.github.atkawa7.httpsnippet.models.internal.Validation;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public final class HarUtils {
    private static final ObjectMapper prettyObjectMapper = new ObjectMapper();
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String toPrettyJsonString(Object value) throws JsonProcessingException {
        return prettyObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(value);
    }

    public static String toJsonString(Object value) throws JsonProcessingException {
        return objectMapper.writeValueAsString(value);
    }

    public static Map<String, Object> fromJsonString(String json) throws IOException {
        return (Map)objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){

            public Type getType() {
                return super.getType();
            }
        });
    }

    public static <T> boolean isNotNull(T object) {
        return Objects.nonNull(object);
    }

    public static <T> boolean isNull(T object) {
        return Objects.isNull(object);
    }

    public static <T> String defaultIfNull(T obj, String str) {
        return HarUtils.isNull(obj) ? str : obj.toString();
    }

    public static <T> List<T> defaultIfNull(List<T> obj) {
        return HarUtils.isNull(obj) ? new ArrayList() : obj;
    }

    public static void validateJSON(String jsonInString) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)jsonInString)) {
            try {
                objectMapper.readTree(jsonInString);
            }
            catch (Exception ex) {
                throw new Exception("JSON validation failed");
            }
        } else {
            throw new Exception("JSON validation failed");
        }
    }

    public static List<HarQueryString> processQueryStrings(List<HarQueryString> harQueryStrings) throws Exception {
        return Validation.validate(harQueryStrings, queryString -> {
            if (StringUtils.isBlank((CharSequence)queryString.getName())) {
                throw new Exception("QueryString cannot be null");
            }
        });
    }

    public static List<HarCookie> processCookies(HarRequest harRequest) throws Exception {
        return Validation.validate(harRequest.getCookies(), cookie -> {
            if (StringUtils.isBlank((CharSequence)cookie.getName())) {
                throw new Exception("Cookie name must not be null");
            }
            if (StringUtils.isBlank((CharSequence)cookie.getValue())) {
                throw new Exception("Cookie value must not be null");
            }
        });
    }

    public static List<HarParam> processParams(HarPostData postData) throws Exception {
        if (Objects.nonNull(postData)) {
            return Validation.validate(postData.getParams(), param -> {
                if (StringUtils.isBlank((CharSequence)param.getName())) {
                    throw new Exception("Param name must not be blank");
                }
                if (StringUtils.isNotBlank((CharSequence)param.getFileName()) && StringUtils.isBlank((CharSequence)param.getContentType())) {
                    throw new Exception("Content type must no be blank when param has file name");
                }
            });
        }
        return new ArrayList<HarParam>();
    }

    public static List<HarHeader> processHeaders(HarRequest harRequest) throws Exception {
        return Validation.validate(harRequest.getHeaders(), header -> {
            if (StringUtils.isBlank((CharSequence)header.getName())) {
                throw new Exception("Header name must not be null");
            }
            if (StringUtils.isBlank((CharSequence)header.getValue())) {
                throw new Exception("Header value must not be null");
            }
        });
    }

    public static String defaultMimeType(String mimeType) {
        if (StringUtils.isBlank((CharSequence)mimeType)) {
            return "application/octet-stream";
        }
        if (MediaType.isMultipartMediaType(mimeType)) {
            return "multipart/form-data";
        }
        if (MediaType.isJsonMediaType(mimeType)) {
            return "application/json";
        }
        if ("application/x-www-form-urlencoded".equalsIgnoreCase(mimeType)) {
            return "application/x-www-form-urlencoded";
        }
        return mimeType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private HarUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        prettyObjectMapper.setDefaultPrettyPrinter((PrettyPrinter)new HttpSnippetPrettyPrinter());
        prettyObjectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true);
        objectMapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    static class HttpSnippetPrettyPrinter
    extends DefaultPrettyPrinter {
        public HttpSnippetPrettyPrinter(DefaultPrettyPrinter base) {
            super(base);
        }

        public HttpSnippetPrettyPrinter() {
            this._arrayIndenter = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE;
        }

        public DefaultPrettyPrinter createInstance() {
            return new HttpSnippetPrettyPrinter(this);
        }

        public void writeObjectFieldValueSeparator(JsonGenerator g) throws IOException {
            g.writeRaw(": ");
        }
    }
}

