package io.github.atkawa7.smithy.codegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.NameAllocator;
import software.amazon.smithy.crt.codegen.AbstractStructure;
import software.amazon.smithy.crt.codegen.Field;

import java.util.Map;
import java.util.Objects;

import static javax.lang.model.element.Modifier.PUBLIC;

public class DefaultMethodUtils {
    private static final ClassName OBJECTS = ClassName.get(Objects.class);

    private DefaultMethodUtils() {
    }

    public static MethodSpec.Builder objectHashCode(AbstractStructure<?> src) {

        NameAllocator nameAllocator = new NameAllocator();
        String resultName = nameAllocator.newName("result");
        MethodSpec.Builder result = MethodSpec.methodBuilder("hashCode")
                .addAnnotation(Override.class)
                .addModifiers(PUBLIC)
                .returns(int.class);

        Map<String, Field> allFields = src.getMembers();
        if (allFields.isEmpty()) {
            result.addStatement("return super.hashCode()");
            return result;
        }


        result.addStatement("int $N = super.hashCode()", resultName);

        for (Map.Entry<String, Field> entry : allFields.entrySet()) {
            Field field = entry.getValue();
            String fieldName = nameAllocator.newName(field.getName());
            result.addStatement("$1N = $1N * 31 + $2L.hashCode($3L)", resultName, OBJECTS, fieldName);

        }
        result.addStatement("return $N", resultName);
        return result;
    }

    public static MethodSpec.Builder objectEquals(AbstractStructure<?> src) {

        ClassName javaType = src.getClassName();
        NameAllocator allocator = new NameAllocator();
        String otherName = allocator.newName("rhs");
        String oName = allocator.newName("o");

        MethodSpec.Builder result = MethodSpec.methodBuilder("equals")
                .addAnnotation(Override.class)
                .addModifiers(PUBLIC)
                .returns(boolean.class)
                .addParameter(Object.class, otherName);

        Map<String, Field> allFields = src.getMembers();
        if (allFields.isEmpty()) {
            result.addStatement("return $N instanceof $T", otherName, javaType);
            return result;
        }

        result.addStatement("if ($N == this) return true", otherName);
        result.addStatement("if (!($N instanceof $T)) return false", otherName, javaType);


        result.addStatement("$T $N = ($T) $N", javaType, oName, javaType, otherName);
        result.addCode("$[return ");
        int len = allFields.size();
        int count = 0;
        for (Map.Entry<String, Field> entry : allFields.entrySet()) {
            count++;
            Field field = entry.getValue();
            String fieldName = allocator.newName(field.getName());
            result.addCode("$1L.equals($2L, $3N.$2L)", OBJECTS, fieldName, oName);
            if (count != len) {
                result.addCode("\n&& ");
            }

        }
        result.addCode(";\n$]");

        return result;
    }
}
