/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.smithy.codegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.NameAllocator;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import software.amazon.smithy.crt.codegen.AbstractStructure;
import software.amazon.smithy.crt.codegen.Field;

public class DefaultMethodUtils {
    private static final ClassName OBJECTS = ClassName.get(Objects.class);

    private DefaultMethodUtils() {
    }

    public static MethodSpec.Builder objectHashCode(AbstractStructure<?> src) {
        NameAllocator nameAllocator = new NameAllocator();
        String resultName = nameAllocator.newName("result");
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE);
        Map<String, Field> allFields = src.getMembers();
        if (allFields.isEmpty()) {
            result.addStatement("return super.hashCode()", new Object[0]);
            return result;
        }
        result.addStatement("int $N = super.hashCode()", new Object[]{resultName});
        for (Map.Entry<String, Field> entry : allFields.entrySet()) {
            Field field = entry.getValue();
            String fieldName = nameAllocator.newName(field.getName());
            result.addStatement("$1N = $1N * 31 + $2L.hashCode($3L)", new Object[]{resultName, OBJECTS, fieldName});
        }
        result.addStatement("return $N", new Object[]{resultName});
        return result;
    }

    public static MethodSpec.Builder objectEquals(AbstractStructure<?> src) {
        ClassName javaType = src.getClassName();
        NameAllocator allocator = new NameAllocator();
        String otherName = allocator.newName("rhs");
        String oName = allocator.newName("o");
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter(Object.class, otherName, new Modifier[0]);
        Map<String, Field> allFields = src.getMembers();
        if (allFields.isEmpty()) {
            result.addStatement("return $N instanceof $T", new Object[]{otherName, javaType});
            return result;
        }
        result.addStatement("if ($N == this) return true", new Object[]{otherName});
        result.addStatement("if (!($N instanceof $T)) return false", new Object[]{otherName, javaType});
        result.addStatement("$T $N = ($T) $N", new Object[]{javaType, oName, javaType, otherName});
        result.addCode("$[return ", new Object[0]);
        int len = allFields.size();
        int count = 0;
        for (Map.Entry<String, Field> entry : allFields.entrySet()) {
            Field field = entry.getValue();
            String fieldName = allocator.newName(field.getName());
            result.addCode("$1L.equals($2L, $3N.$2L)", new Object[]{OBJECTS, fieldName, oName});
            if (++count == len) continue;
            result.addCode("\n&& ", new Object[0]);
        }
        result.addCode(";\n$]", new Object[0]);
        return result;
    }
}

