/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.smithy.codegen;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.build.SmithyBuildPlugin;
import software.amazon.smithy.crt.codegen.SourceGenerator;
import software.amazon.smithy.crt.java.AnnotationsGenerator;
import software.amazon.smithy.crt.java.ServiceGenerator;

public class JavaCodegenPlugin
implements SmithyBuildPlugin {
    private static final Logger LOG = Logger.getLogger(JavaCodegenPlugin.class.getSimpleName());

    public String getName() {
        return "java-codegen";
    }

    public void execute(PluginContext pluginContext) {
        Logger root = Logger.getLogger("");
        root.setLevel(Level.ALL);
        for (Handler handler : root.getHandlers()) {
            handler.setLevel(Level.ALL);
        }
        LOG.warning("Running JavaCodegenPlugin...");
        try {
            List<SourceGenerator> generators = Arrays.asList(new AnnotationsGenerator(pluginContext), new ServiceGenerator(pluginContext));
            for (SourceGenerator generator : generators) {
                generator.accept(pluginContext.getFileManifest().getBaseDir(), javaFile -> {
                    pluginContext.getFileManifest().addFile(javaFile);
                    LOG.info("Generated ${javaFile.toAbsolutePath()}");
                });
            }
        }
        catch (Exception ex) {
            LOG.info(ex.getMessage());
        }
    }
}

