/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.crt.codegen;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.crt.codegen.AbstractElement;
import software.amazon.smithy.crt.codegen.Annotation;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0019\u001a\u00028\u00002\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0002\u0010\u001bJ)\u0010\u001c\u001a\u00028\u00002\u001a\u0010\u0007\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\t0\u001d\"\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001f\u001a\u00028\u00002\u0006\u0010 \u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010!J\u0019\u0010\"\u001a\u00028\u00002\n\u0010#\u001a\u00060\u0013j\u0002`\u0014H\u0016\u00a2\u0006\u0002\u0010$J)\u0010%\u001a\u00028\u00002\u001a\u0010&\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0013j\u0002`\u00140\u001d\"\u00060\u0013j\u0002`\u0014H\u0016\u00a2\u0006\u0002\u0010'J\u001e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020+0-H\u0016R\u001e\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0013j\u0002`\u00140\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000e\u00a8\u0006."}, d2={"Lsoftware/amazon/smithy/crt/codegen/Element;", "T", "Lsoftware/amazon/smithy/crt/codegen/AbstractElement;", "packageName", "", "name", "(Ljava/lang/String;Ljava/lang/String;)V", "annotations", "", "Lsoftware/amazon/smithy/crt/codegen/Annotation;", "getAnnotations", "()Ljava/util/List;", "documentation", "getDocumentation", "()Ljava/lang/String;", "setDocumentation", "(Ljava/lang/String;)V", "modifiers", "", "Ljavax/lang/model/element/Modifier;", "Lsoftware/amazon/smithy/crt/codegen/Modifier;", "getModifiers", "()Ljava/util/Set;", "getName", "getPackageName", "addAnnotation", "a", "(Lsoftware/amazon/smithy/crt/codegen/Annotation;)Ljava/lang/Object;", "addAnnotations", "", "([Lsoftware/amazon/smithy/crt/codegen/Annotation;)Ljava/lang/Object;", "addDocumentation", "doc", "(Ljava/lang/String;)Ljava/lang/Object;", "addModifier", "mod", "(Ljavax/lang/model/element/Modifier;)Ljava/lang/Object;", "addModifiers", "mods", "([Ljavax/lang/model/element/Modifier;)Ljava/lang/Object;", "generate", "", "dir", "Ljava/nio/file/Path;", "consumer", "Ljava/util/function/Consumer;", "smithy-java-codegen"})
public abstract class Element<T>
implements AbstractElement<T> {
    @NotNull
    private final String packageName;
    @NotNull
    private final String name;
    @NotNull
    private final Set<Modifier> modifiers;
    @NotNull
    private final List<Annotation<?>> annotations;
    @Nullable
    private String documentation;

    public Element(@NotNull String packageName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.packageName = packageName;
        this.name = name;
        boolean bl = false;
        this.modifiers = new LinkedHashSet();
        bl = false;
        this.annotations = new ArrayList();
    }

    @Override
    @NotNull
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public T addModifier(@NotNull Modifier mod) {
        Intrinsics.checkNotNullParameter((Object)((Object)mod), (String)"mod");
        this.getModifiers().add(mod);
        return (T)this;
    }

    @Override
    public T addModifiers(Modifier ... mods) {
        Intrinsics.checkNotNullParameter((Object)mods, (String)"mods");
        CollectionsKt.addAll((Collection)this.getModifiers(), (Object[])mods);
        return (T)this;
    }

    @Override
    @NotNull
    public List<Annotation<?>> getAnnotations() {
        return this.annotations;
    }

    @Override
    public T addAnnotation(@NotNull Annotation<?> a) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        this.getAnnotations().add(a);
        return (T)this;
    }

    @Override
    public T addAnnotations(Annotation<?> ... annotations) {
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        CollectionsKt.addAll((Collection)this.getAnnotations(), (Object[])annotations);
        return (T)this;
    }

    @Override
    @Nullable
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public void setDocumentation(@Nullable String string) {
        this.documentation = string;
    }

    @Override
    public T addDocumentation(@NotNull String doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.setDocumentation(doc);
        return (T)this;
    }

    public void generate(@NotNull Path dir, @NotNull Consumer<Path> consumer) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
    }
}

