/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.crt.java;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.crt.java.Enum;
import software.amazon.smithy.crt.java.ShapeGenerator;
import software.amazon.smithy.crt.java.Structure;
import software.amazon.smithy.crt.java.Types;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.traits.EnumDefinition;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.utils.CaseUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lsoftware/amazon/smithy/crt/java/EnumGenerator;", "Lsoftware/amazon/smithy/crt/java/ShapeGenerator;", "pluginContext", "Lsoftware/amazon/smithy/build/PluginContext;", "enumShape", "Lsoftware/amazon/smithy/model/shapes/StringShape;", "(Lsoftware/amazon/smithy/build/PluginContext;Lsoftware/amazon/smithy/model/shapes/StringShape;)V", "enumName", "Lcom/squareup/javapoet/ClassName;", "enumTrait", "Lsoftware/amazon/smithy/model/traits/EnumTrait;", "javaEnum", "Lsoftware/amazon/smithy/crt/java/Structure;", "generate", "Lcom/squareup/javapoet/TypeSpec$Builder;", "Companion", "smithy-java-codegen"})
public final class EnumGenerator
extends ShapeGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringShape enumShape;
    @NotNull
    private final EnumTrait enumTrait;
    @NotNull
    private final ClassName enumName;
    @NotNull
    private final Structure javaEnum;
    @NotNull
    private static final String UNKNOWN_VALUE = "UNKNOWN_TO_SDK_VERSION";

    public EnumGenerator(@NotNull PluginContext pluginContext, @NotNull StringShape enumShape) {
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        Intrinsics.checkNotNullParameter((Object)enumShape, (String)"enumShape");
        super(pluginContext, Types.Utils.toClassName((Shape)enumShape));
        this.enumShape = enumShape;
        Object t = this.enumShape.getTrait(EnumTrait.class).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"enumShape.getTrait(EnumTrait::class.javaObjectType).get()");
        this.enumTrait = (EnumTrait)t;
        this.enumName = Types.Utils.toClassName((Shape)this.enumShape);
        this.javaEnum = (Structure)new Enum(this.getClassName(), EnumGenerator.Companion.enumValuesFromTrait(this.enumTrait)).addAnnotation(this.generatedAnnotation(EnumGenerator.class));
    }

    @Override
    @NotNull
    public TypeSpec.Builder generate() {
        this.getLog().info("Generating enum " + this.enumShape.getId() + " -> " + this.enumName);
        return this.javaEnum.build().java();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lsoftware/amazon/smithy/crt/java/EnumGenerator$Companion;", "", "()V", "UNKNOWN_VALUE", "", "enumValuesFromTrait", "", "enumTrait", "Lsoftware/amazon/smithy/model/traits/EnumTrait;", "toEnumName", "s", "smithy-java-codegen"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<String, String> enumValuesFromTrait(EnumTrait enumTrait) {
            boolean bl = false;
            Map values = new LinkedHashMap();
            enumTrait.getValues().stream().forEach(arg_0 -> Companion.enumValuesFromTrait$lambda-0(values, arg_0));
            return values;
        }

        private final String toEnumName(String s) {
            String ident = StringsKt.replace$default((String)s, (String)":*", (String)"", (boolean)false, (int)4, null);
            ident = StringsKt.replace$default((String)ident, (char)':', (char)'_', (boolean)false, (int)4, null);
            String string = CaseUtils.toSnakeCase((String)ident);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSnakeCase(ident)");
            boolean bl = false;
            String string2 = string.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
            return string2;
        }

        private static final void enumValuesFromTrait$lambda-0(Map $values, EnumDefinition enumValue) {
            Intrinsics.checkNotNullParameter((Object)$values, (String)"$values");
            String string = enumValue.getName().orElse(enumValue.getValue());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"enumValue.name.orElse(enumValue.value)");
            String name = Companion.toEnumName(string);
            String value = !Intrinsics.areEqual((Object)enumValue.getValue(), (Object)"") ? enumValue.getValue() : null;
            Map map = $values;
            boolean bl = false;
            map.put(name, value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

