/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.crt.java;

import com.squareup.javapoet.ClassName;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.crt.codegen.SourceGenerator;
import software.amazon.smithy.crt.java.EmptyStructureGenerator;
import software.amazon.smithy.crt.java.EnumGenerator;
import software.amazon.smithy.crt.java.ExceptionGenerator;
import software.amazon.smithy.crt.java.ServiceExceptionGenerator;
import software.amazon.smithy.crt.java.ShapeGenerator;
import software.amazon.smithy.crt.java.StructureGenerator;
import software.amazon.smithy.crt.java.Types;
import software.amazon.smithy.crt.java.UnionGenerator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lsoftware/amazon/smithy/crt/java/ServiceGenerator;", "Lsoftware/amazon/smithy/crt/codegen/SourceGenerator;", "pluginContext", "Lsoftware/amazon/smithy/build/PluginContext;", "(Lsoftware/amazon/smithy/build/PluginContext;)V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "model", "Lsoftware/amazon/smithy/model/Model;", "typeMap", "Lsoftware/amazon/smithy/crt/java/Types;", "accept", "", "dir", "Ljava/nio/file/Path;", "manifest", "Ljava/util/function/Consumer;", "emptyRequestStructure", "operation", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "emptyResponseStructure", "emptyStructure", "className", "Lcom/squareup/javapoet/ClassName;", "toShape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "id", "Lsoftware/amazon/smithy/model/shapes/ShapeId;", "smithy-java-codegen"})
public final class ServiceGenerator
implements SourceGenerator {
    @NotNull
    private final PluginContext pluginContext;
    private final Logger log;
    @NotNull
    private final Model model;
    @NotNull
    private final Types typeMap;

    public ServiceGenerator(@NotNull PluginContext pluginContext) {
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        this.pluginContext = pluginContext;
        this.log = Logger.getLogger(Reflection.getOrCreateKotlinClass(ServiceGenerator.class).getSimpleName());
        Model model = this.pluginContext.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)model, (String)"pluginContext.model");
        this.model = model;
        this.typeMap = new Types(this.pluginContext);
    }

    private final Shape toShape(ShapeId id) {
        Object t = this.model.getShape(id).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"model.getShape(id).get()");
        return (Shape)t;
    }

    private final SourceGenerator emptyStructure(ClassName className) {
        return new EmptyStructureGenerator(this.pluginContext, className);
    }

    private final SourceGenerator emptyRequestStructure(OperationShape operation) {
        ClassName className = ClassName.get((String)Intrinsics.stringPlus((String)operation.getId().getNamespace(), (Object)".model"), (String)Intrinsics.stringPlus((String)operation.getId().getName(), (Object)"Request"), (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(operation.id.namespace + \".model\", operation.id.name + \"Request\")");
        return this.emptyStructure(className);
    }

    private final SourceGenerator emptyResponseStructure(OperationShape operation) {
        ClassName className = ClassName.get((String)Intrinsics.stringPlus((String)operation.getId().getNamespace(), (Object)".model"), (String)Intrinsics.stringPlus((String)operation.getId().getName(), (Object)"Response"), (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(operation.id.namespace + \".model\", operation.id.name + \"Response\")");
        return this.emptyStructure(className);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void accept(@NotNull Path dir, @NotNull Consumer<Path> manifest) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Iterable $this$forEach$iv;
        int lastCount;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(manifest, (String)"manifest");
        boolean bl = false;
        Set foundShapes = new LinkedHashSet();
        Object[] objectArray = new SourceGenerator[]{new ServiceExceptionGenerator(this.pluginContext, null, 2, null)};
        List generators = CollectionsKt.mutableListOf((Object[])objectArray);
        Stream operations = this.model.shapes(OperationShape.class);
        operations.forEach(arg_0 -> ServiceGenerator.accept$lambda-1(foundShapes, this, generators, arg_0));
        List shapesToEvaluate = CollectionsKt.toList((Iterable)foundShapes);
        do {
            Collection collection = foundShapes;
            boolean bl2 = false;
            lastCount = collection.size();
            bl2 = false;
            Set shapesFoundThisPass = new LinkedHashSet();
            $this$forEach$iv = shapesToEvaluate;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Shape shape = (Shape)element$iv;
                boolean bl3 = false;
                if (shape instanceof StructureShape || shape instanceof UnionShape) {
                    object = shape.members().stream().map(arg_0 -> ServiceGenerator.accept$lambda-3$lambda-2(this, arg_0)).collect(Collectors.toSet());
                    Intrinsics.checkNotNullExpressionValue(object, (String)"shape.members().stream()\n                            .map { model.getShape(it.target).get() }\n                            .collect(Collectors.toSet())");
                    shapesFoundThisPass.addAll((Collection)object);
                    continue;
                }
                if (shape instanceof ListShape) {
                    object = this.model.getShape(((ListShape)shape).getMember().getTarget()).get();
                    Intrinsics.checkNotNullExpressionValue(object, (String)"model.getShape(shape.member.target).get()");
                    shapesFoundThisPass.add(object);
                    continue;
                }
                if (shape instanceof MapShape) {
                    object = this.model.getShape(((MapShape)shape).getValue().getTarget()).get();
                    Intrinsics.checkNotNullExpressionValue(object, (String)"model.getShape(shape.value.target).get()");
                    shapesFoundThisPass.add(object);
                    continue;
                }
                if (!Types.Utils.isEnum(shape)) continue;
                shapesFoundThisPass.add(shape);
            }
            shapesToEvaluate = CollectionsKt.toList((Iterable)shapesFoundThisPass);
            foundShapes.addAll(shapesFoundThisPass);
            $this$forEach$iv = foundShapes;
            $i$f$forEach = false;
        } while (lastCount < $this$forEach$iv.size());
        Iterable $this$mapNotNull$iv = foundShapes;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$forEach = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            ShapeGenerator shapeGenerator;
            Object t;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl4 = false;
            Shape shape = (Shape)element$iv$iv;
            boolean bl5 = false;
            this.log.info(Intrinsics.stringPlus((String)"Processing ", (Object)shape.getId()));
            if (Types.Utils.isException(shape)) {
                t = shape.asStructureShape().get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"shape.asStructureShape().get()");
                shapeGenerator = new ExceptionGenerator(this.pluginContext, (StructureShape)t);
            } else if (shape instanceof StructureShape) {
                shapeGenerator = new StructureGenerator(this.pluginContext, (StructureShape)shape, null, 4, null);
            } else if (Types.Utils.isEnum(shape)) {
                t = shape.asStringShape().get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"shape.asStringShape().get()");
                shapeGenerator = new EnumGenerator(this.pluginContext, (StringShape)t);
            } else {
                shapeGenerator = shape instanceof UnionShape ? (ShapeGenerator)new UnionGenerator(this.pluginContext, (UnionShape)shape) : null;
            }
            if (shapeGenerator == null) continue;
            ShapeGenerator shapeGenerator2 = shapeGenerator;
            boolean bl6 = false;
            boolean bl7 = false;
            ShapeGenerator it$iv$iv = shapeGenerator2;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List shapeGenerators = (List)destination$iv$iv;
        generators.addAll(shapeGenerators);
        Iterable $this$forEach$iv2 = generators;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv2) {
            SourceGenerator generator = (SourceGenerator)element$iv;
            boolean bl9 = false;
            generator.accept(dir, manifest);
        }
    }

    private static final Shape accept$lambda-1$lambda-0(ServiceGenerator this$0, ShapeId it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return this$0.toShape(it);
    }

    private static final void accept$lambda-1(Set $foundShapes, ServiceGenerator this$0, List $generators, OperationShape operation) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$foundShapes, (String)"$foundShapes");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$generators, (String)"$generators");
        if (operation.getInput().isPresent()) {
            object = operation.getInput().get();
            Intrinsics.checkNotNullExpressionValue(object, (String)"operation.input.get()");
            $foundShapes.add(this$0.toShape((ShapeId)object));
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)operation, (String)"operation");
            $generators.add(this$0.emptyRequestStructure(operation));
        }
        if (operation.getOutput().isPresent()) {
            object = operation.getOutput().get();
            Intrinsics.checkNotNullExpressionValue(object, (String)"operation.output.get()");
            $foundShapes.add(this$0.toShape((ShapeId)object));
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)operation, (String)"operation");
            $generators.add(this$0.emptyResponseStructure(operation));
        }
        object = operation.getErrors().stream().map(arg_0 -> ServiceGenerator.accept$lambda-1$lambda-0(this$0, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(object, (String)"operation.errors.stream()\n                    .map { it -> toShape(it) }\n                    .collect(Collectors.toList())");
        $foundShapes.addAll((Collection)object);
    }

    private static final Shape accept$lambda-3$lambda-2(ServiceGenerator this$0, MemberShape it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (Shape)this$0.model.getShape(it.getTarget()).get();
    }
}

