/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.crt.java;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.crt.codegen.Field;
import software.amazon.smithy.crt.codegen.SourceGenerator;
import software.amazon.smithy.crt.java.Annotation;
import software.amazon.smithy.crt.java.Generated;
import software.amazon.smithy.crt.java.Types;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.DocumentationTrait;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 (2\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0016J\u001a\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u001b0\u001aj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0004J\b\u0010\u001f\u001a\u00020 H&J\u0014\u0010!\u001a\u00020\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0004J\u000e\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006)"}, d2={"Lsoftware/amazon/smithy/crt/java/ShapeGenerator;", "Lsoftware/amazon/smithy/crt/codegen/SourceGenerator;", "pluginContext", "Lsoftware/amazon/smithy/build/PluginContext;", "className", "Lcom/squareup/javapoet/ClassName;", "(Lsoftware/amazon/smithy/build/PluginContext;Lcom/squareup/javapoet/ClassName;)V", "getClassName", "()Lcom/squareup/javapoet/ClassName;", "log", "Ljava/util/logging/Logger;", "getLog", "()Ljava/util/logging/Logger;", "model", "Lsoftware/amazon/smithy/model/Model;", "getModel", "()Lsoftware/amazon/smithy/model/Model;", "getPluginContext", "()Lsoftware/amazon/smithy/build/PluginContext;", "accept", "", "dir", "Ljava/nio/file/Path;", "manifest", "Ljava/util/function/Consumer;", "fieldsFromShape", "", "Lsoftware/amazon/smithy/crt/codegen/Field;", "Lsoftware/amazon/smithy/crt/java/Fields;", "shape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "generate", "Lcom/squareup/javapoet/TypeSpec$Builder;", "generatedAnnotation", "Lsoftware/amazon/smithy/crt/java/Annotation;", "generator", "Ljava/lang/Class;", "toShape", "id", "Lsoftware/amazon/smithy/model/shapes/ShapeId;", "Companion", "smithy-java-codegen"})
public abstract class ShapeGenerator
implements SourceGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginContext pluginContext;
    @NotNull
    private final ClassName className;
    @NotNull
    private final Logger log;
    @NotNull
    private final Model model;

    public ShapeGenerator(@NotNull PluginContext pluginContext, @NotNull ClassName className) {
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.pluginContext = pluginContext;
        this.className = className;
        Logger logger = Logger.getLogger(Reflection.getOrCreateKotlinClass(ShapeGenerator.class).getSimpleName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(ShapeGenerator::class.simpleName)");
        this.log = logger;
        logger = this.pluginContext.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"pluginContext.model");
        this.model = logger;
    }

    @NotNull
    protected final PluginContext getPluginContext() {
        return this.pluginContext;
    }

    @NotNull
    protected final ClassName getClassName() {
        return this.className;
    }

    @NotNull
    protected final Logger getLog() {
        return this.log;
    }

    @NotNull
    protected final Model getModel() {
        return this.model;
    }

    @NotNull
    protected final Collection<Field> fieldsFromShape(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        List list = shape.members().stream().map(arg_0 -> ShapeGenerator.fieldsFromShape$lambda-0(this, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"shape.members().stream().map { member ->\n            val field = Field(member.memberName, toTypeName(toShape(member.target)))\n            if (member.hasTrait(DocumentationTrait::class.javaObjectType)) {\n                field.addDocumentation(member.getTrait(DocumentationTrait::class.javaObjectType).get().value)\n            }\n            return@map field\n        }.collect(Collectors.toList())");
        return list;
    }

    @NotNull
    public final Shape toShape(@NotNull ShapeId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object t = this.model.getShape(id).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"model.getShape(id).get()");
        return (Shape)t;
    }

    @NotNull
    protected final Annotation generatedAnnotation(@NotNull Class<?> generator) {
        Intrinsics.checkNotNullParameter(generator, (String)"generator");
        return new Annotation(Generated.Companion.getCLASS_NAME()).java((Function1<? super AnnotationSpec.Builder, Unit>)((Function1)new Function1<AnnotationSpec.Builder, Unit>(generator){
            final /* synthetic */ Class<?> $generator;
            {
                this.$generator = $generator;
                super(1);
            }

            public final void invoke(@NotNull AnnotationSpec.Builder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                Object[] objectArray = new Object[]{ClassName.bestGuess((String)this.$generator.getName())};
                builder.addMember("value", "$S", objectArray);
            }
        }));
    }

    @Override
    public void accept(@NotNull Path dir, @NotNull Consumer<Path> manifest) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(manifest, (String)"manifest");
        try {
            JavaFile javaSource = Companion.emit(this.className, this.generate());
            manifest.accept(javaSource.writeToPath(dir));
        }
        catch (Throwable ex) {
            this.log.severe(ex.getMessage());
        }
    }

    @NotNull
    public abstract TypeSpec.Builder generate();

    private static final Field fieldsFromShape$lambda-0(ShapeGenerator this$0, MemberShape member) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = member.getMemberName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"member.memberName");
        String string2 = string;
        string = member.getTarget();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"member.target");
        Field field = new Field(string2, Types.Utils.toTypeName(this$0.toShape((ShapeId)string)));
        if (member.hasTrait(DocumentationTrait.class)) {
            string = ((DocumentationTrait)member.getTrait(DocumentationTrait.class).get()).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"member.getTrait(DocumentationTrait::class.javaObjectType).get().value");
            field.addDocumentation(string);
        }
        return field;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lsoftware/amazon/smithy/crt/java/ShapeGenerator$Companion;", "", "()V", "emit", "Lcom/squareup/javapoet/JavaFile;", "className", "Lcom/squareup/javapoet/ClassName;", "builder", "Lcom/squareup/javapoet/TypeSpec$Builder;", "smithy-java-codegen"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaFile emit(@NotNull ClassName className, @NotNull TypeSpec.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            JavaFile javaFile = JavaFile.builder((String)className.packageName(), (TypeSpec)builder.build()).indent("    ").build();
            Intrinsics.checkNotNullExpressionValue((Object)javaFile, (String)"builder(className.packageName(), builder.build())\n                .indent(\"    \")\n                .build()");
            return javaFile;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

