/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.crt.java;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.crt.java.Builder;
import software.amazon.smithy.crt.java.BuilderClient;
import software.amazon.smithy.crt.java.ShapeGenerator;
import software.amazon.smithy.crt.java.Structure;
import software.amazon.smithy.crt.java.StructureGenerator;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lsoftware/amazon/smithy/crt/java/StructureGeneratorBase;", "Lsoftware/amazon/smithy/crt/java/ShapeGenerator;", "pluginContext", "Lsoftware/amazon/smithy/build/PluginContext;", "className", "Lcom/squareup/javapoet/ClassName;", "(Lsoftware/amazon/smithy/build/PluginContext;Lcom/squareup/javapoet/ClassName;)V", "builder", "Lsoftware/amazon/smithy/crt/java/Builder;", "Lsoftware/amazon/smithy/crt/java/Structure;", "getBuilder", "()Lsoftware/amazon/smithy/crt/java/Builder;", "javaStructure", "getJavaStructure", "()Lsoftware/amazon/smithy/crt/java/Structure;", "generate", "Lcom/squareup/javapoet/TypeSpec$Builder;", "smithy-java-codegen"})
public abstract class StructureGeneratorBase
extends ShapeGenerator {
    @NotNull
    private final Structure javaStructure;
    @NotNull
    private final Builder<Structure> builder;

    public StructureGeneratorBase(@NotNull PluginContext pluginContext, @NotNull ClassName className) {
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        super(pluginContext, className);
        this.javaStructure = (Structure)new Structure(className).addAnnotation(this.generatedAnnotation(StructureGenerator.class));
        this.builder = new Builder<BuilderClient>(this.javaStructure);
    }

    @NotNull
    protected final Structure getJavaStructure() {
        return this.javaStructure;
    }

    @NotNull
    protected final Builder<Structure> getBuilder() {
        return this.builder;
    }

    @Override
    @NotNull
    public TypeSpec.Builder generate() {
        this.javaStructure.addDefaultConstructor();
        this.builder.build();
        return this.javaStructure.build().java();
    }
}

