/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.crt.java;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.utils.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0003\u0017\u0018\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0006\u0010\u0011\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lsoftware/amazon/smithy/crt/java/Types;", "", "pluginContext", "Lsoftware/amazon/smithy/build/PluginContext;", "(Lsoftware/amazon/smithy/build/PluginContext;)V", "classNameVisitor", "Lsoftware/amazon/smithy/crt/java/Types$ClassNameVisitor;", "mappings", "", "", "getPluginContext", "()Lsoftware/amazon/smithy/build/PluginContext;", "typeNameVisitor", "Lsoftware/amazon/smithy/crt/java/Types$TypeNameVisitor;", "remapClass", "Lcom/squareup/javapoet/ClassName;", "className", "serviceException", "toClassName", "shape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "toTypeName", "Lcom/squareup/javapoet/TypeName;", "ClassNameVisitor", "TypeNameVisitor", "Utils", "smithy-java-codegen"})
public final class Types {
    @NotNull
    public static final Utils Utils = new Utils(null);
    @NotNull
    private final PluginContext pluginContext;
    @NotNull
    private final TypeNameVisitor typeNameVisitor;
    @NotNull
    private final ClassNameVisitor classNameVisitor;
    @NotNull
    private final Map<String, String> mappings;
    @Nullable
    private static Types staticInstance;

    public Types(@NotNull PluginContext pluginContext) {
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        this.pluginContext = pluginContext;
        this.typeNameVisitor = new TypeNameVisitor(this);
        this.classNameVisitor = new ClassNameVisitor(this.typeNameVisitor);
        staticInstance = this;
        boolean bl = false;
        this.mappings = new LinkedHashMap();
        Optional configMappings = this.pluginContext.getSettings().getObjectMember("mappings");
        if (configMappings.isPresent()) {
            ((ObjectNode)configMappings.get()).getStringMap().entrySet().stream().forEach(arg_0 -> Types._init_$lambda-0(this, arg_0));
        }
    }

    @NotNull
    public final PluginContext getPluginContext() {
        return this.pluginContext;
    }

    private final ClassName remapClass(ClassName className) {
        if (this.mappings.containsKey(className.simpleName()) || this.mappings.containsKey(className.canonicalName())) {
            ClassName className2;
            ClassName className3 = this.mappings;
            String string = className.simpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.simpleName()");
            boolean bl = false;
            String string2 = className3.get(string);
            if (string2 == null) {
                boolean bl2 = false;
                String string3 = this.mappings.get(className.canonicalName());
                Intrinsics.checkNotNull((Object)string3);
                string2 = string3;
            }
            String mappedName = string2;
            if (StringsKt.contains$default((CharSequence)mappedName, (char)'.', (boolean)false, (int)2, null)) {
                className3 = ClassName.bestGuess((String)mappedName);
                Intrinsics.checkNotNullExpressionValue((Object)className3, (String)"{\n                ClassName.bestGuess(mappedName)\n            }");
                className2 = className3;
            } else {
                className3 = ClassName.get((String)className.packageName(), (String)mappedName, (String[])new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)className3, (String)"{\n                ClassName.get(className.packageName(), mappedName)\n            }");
                className2 = className3;
            }
            return className2;
        }
        return className;
    }

    @NotNull
    public final ClassName toClassName(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Object object = shape.accept((ShapeVisitor)this.classNameVisitor);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"shape.accept(classNameVisitor)");
        return this.remapClass((ClassName)object);
    }

    @NotNull
    public final TypeName toTypeName(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"shape.accept(typeNameVisitor)");
        return (TypeName)object;
    }

    @NotNull
    public final ClassName serviceException() {
        String namespace = ((ServiceShape)this.pluginContext.getModel().shapes(ServiceShape.class).findFirst().get()).getId().getNamespace();
        String string = ((ServiceShape)this.pluginContext.getModel().shapes(ServiceShape.class).findFirst().get()).getId().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginContext.model.shapes(ServiceShape::class.javaObjectType).findFirst().get().id.name");
        String name = Intrinsics.stringPlus((String)StringsKt.replace$default((String)string, (String)"Amazon", (String)"", (boolean)false, (int)4, null), (Object)"Exception");
        string = ClassName.get((String)namespace, (String)name, (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(namespace, name)");
        return string;
    }

    private static final void _init_$lambda-0(Types this$0, Map.Entry mapping) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map<String, String> map = this$0.mappings;
        Object k = mapping.getKey();
        Intrinsics.checkNotNullExpressionValue(k, (String)"mapping.key");
        String string = ((StringNode)((Node)mapping.getValue()).asStringNode().get()).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mapping.value.asStringNode().get().value");
        boolean bl = false;
        map.put((String)k, string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lsoftware/amazon/smithy/crt/java/Types$Utils;", "", "()V", "staticInstance", "Lsoftware/amazon/smithy/crt/java/Types;", "getStaticInstance", "()Lsoftware/amazon/smithy/crt/java/Types;", "setStaticInstance", "(Lsoftware/amazon/smithy/crt/java/Types;)V", "instance", "isEnum", "", "shape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "isException", "serviceException", "Lcom/squareup/javapoet/ClassName;", "toClassName", "toTypeName", "Lcom/squareup/javapoet/TypeName;", "smithy-java-codegen"})
    public static final class Utils {
        private Utils() {
        }

        public final boolean isEnum(@NotNull Shape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            return shape.isStringShape() && shape.hasTrait(EnumTrait.class);
        }

        public final boolean isException(@NotNull Shape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            return shape.isStructureShape() && shape.hasTrait(ErrorTrait.class);
        }

        @Nullable
        public final Types getStaticInstance() {
            return staticInstance;
        }

        public final void setStaticInstance(@Nullable Types types) {
            staticInstance = types;
        }

        @NotNull
        public final Types instance() {
            Types types = this.getStaticInstance();
            Intrinsics.checkNotNull((Object)types);
            return types;
        }

        @NotNull
        public final ClassName toClassName(@NotNull Shape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            return this.instance().toClassName(shape);
        }

        @NotNull
        public final TypeName toTypeName(@NotNull Shape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            return this.instance().toTypeName(shape);
        }

        @NotNull
        public final ClassName serviceException() {
            return this.instance().serviceException();
        }

        public /* synthetic */ Utils(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u000205H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lsoftware/amazon/smithy/crt/java/Types$TypeNameVisitor;", "Lsoftware/amazon/smithy/model/shapes/ShapeVisitor;", "Lcom/squareup/javapoet/TypeName;", "types", "Lsoftware/amazon/smithy/crt/java/Types;", "(Lsoftware/amazon/smithy/crt/java/Types;)V", "bigDecimalShape", "shape", "Lsoftware/amazon/smithy/model/shapes/BigDecimalShape;", "bigIntegerShape", "Lsoftware/amazon/smithy/model/shapes/BigIntegerShape;", "blobShape", "Lsoftware/amazon/smithy/model/shapes/BlobShape;", "booleanShape", "Lsoftware/amazon/smithy/model/shapes/BooleanShape;", "byteShape", "Lsoftware/amazon/smithy/model/shapes/ByteShape;", "documentShape", "Lsoftware/amazon/smithy/model/shapes/DocumentShape;", "doubleShape", "Lsoftware/amazon/smithy/model/shapes/DoubleShape;", "floatShape", "Lsoftware/amazon/smithy/model/shapes/FloatShape;", "integerShape", "Lsoftware/amazon/smithy/model/shapes/IntegerShape;", "javaNamespace", "", "Lsoftware/amazon/smithy/model/shapes/Shape;", "listShape", "Lsoftware/amazon/smithy/model/shapes/ListShape;", "longShape", "Lsoftware/amazon/smithy/model/shapes/LongShape;", "mapShape", "Lsoftware/amazon/smithy/model/shapes/MapShape;", "memberShape", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "operationShape", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "resourceShape", "Lsoftware/amazon/smithy/model/shapes/ResourceShape;", "serviceShape", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "setShape", "Lsoftware/amazon/smithy/model/shapes/SetShape;", "shortShape", "Lsoftware/amazon/smithy/model/shapes/ShortShape;", "stringShape", "Lsoftware/amazon/smithy/model/shapes/StringShape;", "structureShape", "Lsoftware/amazon/smithy/model/shapes/StructureShape;", "timestampShape", "Lsoftware/amazon/smithy/model/shapes/TimestampShape;", "unionShape", "Lsoftware/amazon/smithy/model/shapes/UnionShape;", "smithy-java-codegen"})
    public static final class TypeNameVisitor
    implements ShapeVisitor<TypeName> {
        @NotNull
        private final Types types;

        public TypeNameVisitor(@NotNull Types types) {
            Intrinsics.checkNotNullParameter((Object)types, (String)"types");
            this.types = types;
        }

        private final String javaNamespace(Shape shape) {
            return Intrinsics.stringPlus((String)shape.getId().getNamespace(), (Object)".model");
        }

        @NotNull
        public TypeName blobShape(@NotNull BlobShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)TypeName.BYTE);
            Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(TypeName.BYTE)");
            return (TypeName)arrayTypeName;
        }

        @NotNull
        public TypeName booleanShape(@NotNull BooleanShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            ClassName className = ClassName.get(Boolean.class);
            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(Boolean::class.javaObjectType)");
            return (TypeName)className;
        }

        @NotNull
        public TypeName listShape(@NotNull ListShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            TypeName[] typeNameArray = new TypeName[]{(TypeName)shape.getMember().accept((ShapeVisitor)this)};
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])typeNameArray);
            Intrinsics.checkNotNullExpressionValue((Object)parameterizedTypeName, (String)"get(\n                ClassName.get(java.util.List::class.javaObjectType),\n                shape.member.accept(this)\n            )");
            return (TypeName)parameterizedTypeName;
        }

        @NotNull
        public TypeName setShape(@NotNull SetShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            TypeName[] typeNameArray = new TypeName[]{(TypeName)shape.getMember().accept((ShapeVisitor)this)};
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Set.class), (TypeName[])typeNameArray);
            Intrinsics.checkNotNullExpressionValue((Object)parameterizedTypeName, (String)"get(\n                ClassName.get(java.util.Set::class.javaObjectType),\n                shape.member.accept(this)\n            )");
            return (TypeName)parameterizedTypeName;
        }

        @NotNull
        public TypeName mapShape(@NotNull MapShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            TypeName[] typeNameArray = new TypeName[]{(TypeName)shape.getKey().accept((ShapeVisitor)this), (TypeName)shape.getValue().accept((ShapeVisitor)this)};
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])typeNameArray);
            Intrinsics.checkNotNullExpressionValue((Object)parameterizedTypeName, (String)"get(\n                ClassName.get(java.util.Map::class.javaObjectType),\n                shape.key.accept(this),\n                shape.value.accept(this)\n            )");
            return (TypeName)parameterizedTypeName;
        }

        @NotNull
        public TypeName byteShape(@NotNull ByteShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            ClassName className = ClassName.get(Byte.class);
            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(Byte::class.javaObjectType)");
            return (TypeName)className;
        }

        @NotNull
        public TypeName shortShape(@NotNull ShortShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            ClassName className = ClassName.get(Short.class);
            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(Short::class.javaObjectType)");
            return (TypeName)className;
        }

        @NotNull
        public TypeName integerShape(@NotNull IntegerShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            ClassName className = ClassName.get(Integer.class);
            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(Integer::class.javaObjectType)");
            return (TypeName)className;
        }

        @NotNull
        public TypeName longShape(@NotNull LongShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            ClassName className = ClassName.get(Long.class);
            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(Long::class.javaObjectType)");
            return (TypeName)className;
        }

        @NotNull
        public TypeName floatShape(@NotNull FloatShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            ClassName className = ClassName.get(Float.class);
            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(Float::class.javaObjectType)");
            return (TypeName)className;
        }

        @NotNull
        public TypeName documentShape(@NotNull DocumentShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            TypeName[] typeNameArray = new TypeName[]{(TypeName)ClassName.get(String.class), (TypeName)ClassName.get(Object.class)};
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])typeNameArray);
            Intrinsics.checkNotNullExpressionValue((Object)parameterizedTypeName, (String)"get(\n                ClassName.get(java.util.Map::class.javaObjectType),\n                ClassName.get(String::class.javaObjectType),\n                ClassName.get(Object::class.javaObjectType)\n            )");
            return (TypeName)parameterizedTypeName;
        }

        @NotNull
        public TypeName doubleShape(@NotNull DoubleShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            ClassName className = ClassName.get(Double.class);
            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(Double::class.javaObjectType)");
            return (TypeName)className;
        }

        @NotNull
        public TypeName bigIntegerShape(@NotNull BigIntegerShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            ClassName className = ClassName.get(BigInteger.class);
            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(java.math.BigInteger::class.javaObjectType)");
            return (TypeName)className;
        }

        @NotNull
        public TypeName bigDecimalShape(@NotNull BigDecimalShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            ClassName className = ClassName.get(BigDecimal.class);
            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(java.math.BigDecimal::class.javaObjectType)");
            return (TypeName)className;
        }

        @NotNull
        public TypeName operationShape(@NotNull OperationShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            String string = "Not yet implemented";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }

        @NotNull
        public TypeName resourceShape(@NotNull ResourceShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            String string = "Not yet implemented";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }

        @NotNull
        public TypeName serviceShape(@NotNull ServiceShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            String string = "Not yet implemented";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }

        @NotNull
        public TypeName stringShape(@NotNull StringShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            if (shape.hasTrait(EnumTrait.class)) {
                ClassName className = ClassName.get((String)this.javaNamespace((Shape)shape), (String)StringUtils.capitalize((String)shape.getId().getName()), (String[])new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(javaNamespace(shape), StringUtils.capitalize(shape.id.name))");
                return (TypeName)className;
            }
            ClassName className = ClassName.get(String.class);
            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(java.lang.String::class.javaObjectType)");
            return (TypeName)className;
        }

        @NotNull
        public TypeName structureShape(@NotNull StructureShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            String suffix = shape.hasTrait(ErrorTrait.class) ? "Exception" : "";
            ClassName className = ClassName.get((String)this.javaNamespace((Shape)shape), (String)Intrinsics.stringPlus((String)StringUtils.capitalize((String)shape.getId().getName()), (Object)suffix), (String[])new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(javaNamespace(shape), StringUtils.capitalize(shape.id.name) + suffix)");
            return (TypeName)className;
        }

        @NotNull
        public TypeName unionShape(@NotNull UnionShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            ClassName className = ClassName.get((String)this.javaNamespace((Shape)shape), (String)StringUtils.capitalize((String)shape.getId().getName()), (String[])new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(javaNamespace(shape), StringUtils.capitalize(shape.id.name))");
            return (TypeName)className;
        }

        @NotNull
        public TypeName memberShape(@NotNull MemberShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = ((Shape)this.types.getPluginContext().getModel().getShape(shape.getTarget()).get()).accept((ShapeVisitor)this);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"types.pluginContext.model.getShape(shape.target).get().accept(this)");
            return (TypeName)object;
        }

        @NotNull
        public TypeName timestampShape(@NotNull TimestampShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            ClassName className = ClassName.get(Instant.class);
            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(java.time.Instant::class.javaObjectType)");
            return (TypeName)className;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u000202H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lsoftware/amazon/smithy/crt/java/Types$ClassNameVisitor;", "Lsoftware/amazon/smithy/model/shapes/ShapeVisitor;", "Lcom/squareup/javapoet/ClassName;", "typeNameVisitor", "Lsoftware/amazon/smithy/crt/java/Types$TypeNameVisitor;", "(Lsoftware/amazon/smithy/crt/java/Types$TypeNameVisitor;)V", "bigDecimalShape", "shape", "Lsoftware/amazon/smithy/model/shapes/BigDecimalShape;", "bigIntegerShape", "Lsoftware/amazon/smithy/model/shapes/BigIntegerShape;", "blobShape", "Lsoftware/amazon/smithy/model/shapes/BlobShape;", "booleanShape", "Lsoftware/amazon/smithy/model/shapes/BooleanShape;", "byteShape", "Lsoftware/amazon/smithy/model/shapes/ByteShape;", "documentShape", "Lsoftware/amazon/smithy/model/shapes/DocumentShape;", "doubleShape", "Lsoftware/amazon/smithy/model/shapes/DoubleShape;", "floatShape", "Lsoftware/amazon/smithy/model/shapes/FloatShape;", "integerShape", "Lsoftware/amazon/smithy/model/shapes/IntegerShape;", "listShape", "Lsoftware/amazon/smithy/model/shapes/ListShape;", "longShape", "Lsoftware/amazon/smithy/model/shapes/LongShape;", "mapShape", "Lsoftware/amazon/smithy/model/shapes/MapShape;", "memberShape", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "operationShape", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "resourceShape", "Lsoftware/amazon/smithy/model/shapes/ResourceShape;", "serviceShape", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "setShape", "Lsoftware/amazon/smithy/model/shapes/SetShape;", "shortShape", "Lsoftware/amazon/smithy/model/shapes/ShortShape;", "stringShape", "Lsoftware/amazon/smithy/model/shapes/StringShape;", "structureShape", "Lsoftware/amazon/smithy/model/shapes/StructureShape;", "timestampShape", "Lsoftware/amazon/smithy/model/shapes/TimestampShape;", "unionShape", "Lsoftware/amazon/smithy/model/shapes/UnionShape;", "smithy-java-codegen"})
    public static final class ClassNameVisitor
    implements ShapeVisitor<ClassName> {
        @NotNull
        private final TypeNameVisitor typeNameVisitor;

        public ClassNameVisitor(@NotNull TypeNameVisitor typeNameVisitor) {
            Intrinsics.checkNotNullParameter((Object)typeNameVisitor, (String)"typeNameVisitor");
            this.typeNameVisitor = typeNameVisitor;
        }

        @NotNull
        public ClassName blobShape(@NotNull BlobShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName booleanShape(@NotNull BooleanShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName listShape(@NotNull ListShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName setShape(@NotNull SetShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName mapShape(@NotNull MapShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName byteShape(@NotNull ByteShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName shortShape(@NotNull ShortShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName integerShape(@NotNull IntegerShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName longShape(@NotNull LongShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName floatShape(@NotNull FloatShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName documentShape(@NotNull DocumentShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName doubleShape(@NotNull DoubleShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName bigIntegerShape(@NotNull BigIntegerShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName bigDecimalShape(@NotNull BigDecimalShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName operationShape(@NotNull OperationShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName resourceShape(@NotNull ResourceShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName serviceShape(@NotNull ServiceShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName stringShape(@NotNull StringShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName structureShape(@NotNull StructureShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName unionShape(@NotNull UnionShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName memberShape(@NotNull MemberShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }

        @NotNull
        public ClassName timestampShape(@NotNull TimestampShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Object object = shape.accept((ShapeVisitor)this.typeNameVisitor);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
            }
            return (ClassName)object;
        }
    }
}

