/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.crt.java;

import com.squareup.javapoet.TypeSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.crt.java.Builder;
import software.amazon.smithy.crt.java.BuilderClient;
import software.amazon.smithy.crt.java.ShapeGenerator;
import software.amazon.smithy.crt.java.Structure;
import software.amazon.smithy.crt.java.Types;
import software.amazon.smithy.crt.java.Union;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.UnionShape;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lsoftware/amazon/smithy/crt/java/UnionGenerator;", "Lsoftware/amazon/smithy/crt/java/ShapeGenerator;", "pluginContext", "Lsoftware/amazon/smithy/build/PluginContext;", "unionShape", "Lsoftware/amazon/smithy/model/shapes/UnionShape;", "(Lsoftware/amazon/smithy/build/PluginContext;Lsoftware/amazon/smithy/model/shapes/UnionShape;)V", "builder", "Lsoftware/amazon/smithy/crt/java/Builder;", "Lsoftware/amazon/smithy/crt/java/Structure;", "javaUnion", "generate", "Lcom/squareup/javapoet/TypeSpec$Builder;", "smithy-java-codegen"})
public final class UnionGenerator
extends ShapeGenerator {
    @NotNull
    private final UnionShape unionShape;
    @NotNull
    private final Structure javaUnion;
    @NotNull
    private final Builder<Structure> builder;

    public UnionGenerator(@NotNull PluginContext pluginContext, @NotNull UnionShape unionShape) {
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        Intrinsics.checkNotNullParameter((Object)unionShape, (String)"unionShape");
        super(pluginContext, Types.Utils.toClassName((Shape)unionShape));
        this.unionShape = unionShape;
        this.javaUnion = (Structure)new Union(this.getClassName()).addAnnotation(this.generatedAnnotation(UnionGenerator.class));
        this.builder = new Builder<BuilderClient>(this.javaUnion);
    }

    @Override
    @NotNull
    public TypeSpec.Builder generate() {
        this.getLog().info("Generating union " + this.unionShape.getId() + " -> " + this.getClassName());
        this.builder.build();
        return this.javaUnion.build().java();
    }
}

