/*
 * Decompiled with CFR 0.152.
 */
package io.github.breninsul.javatimerscheduler.scheduler;

import io.github.breninsul.javatimerscheduler.timer.RunnableTimerTask;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0001H\u0014R\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0018\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Lio/github/breninsul/javatimerscheduler/scheduler/OneThreadPerTaskFixedDelayScheduler;", "Ljava/util/Timer;", "name", "", "fixedRateDelay", "Ljava/time/Duration;", "firstDelay", "loggerClass", "Lkotlin/reflect/KClass;", "loggingLevel", "Ljava/util/logging/Level;", "runnable", "Ljava/lang/Runnable;", "(Ljava/lang/String;Ljava/time/Duration;Ljava/time/Duration;Lkotlin/reflect/KClass;Ljava/util/logging/Level;Ljava/lang/Runnable;)V", "counter", "Ljava/util/concurrent/atomic/AtomicLong;", "getCounter", "()Ljava/util/concurrent/atomic/AtomicLong;", "getFirstDelay", "()Ljava/time/Duration;", "getFixedRateDelay", "getLoggerClass", "()Lkotlin/reflect/KClass;", "getLoggingLevel", "()Ljava/util/logging/Level;", "getName", "()Ljava/lang/String;", "getRunnable", "()Ljava/lang/Runnable;", "init", "", "initTimer", "java-timer-scheduler"})
public class OneThreadPerTaskFixedDelayScheduler
extends Timer {
    @NotNull
    private final String name;
    @NotNull
    private final Duration fixedRateDelay;
    @NotNull
    private final Duration firstDelay;
    @NotNull
    private final KClass<?> loggerClass;
    @NotNull
    private final Level loggingLevel;
    @NotNull
    private final Runnable runnable;

    public OneThreadPerTaskFixedDelayScheduler(@NotNull String name, @NotNull Duration fixedRateDelay, @NotNull Duration firstDelay, @NotNull KClass<?> loggerClass, @NotNull Level loggingLevel, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fixedRateDelay, (String)"fixedRateDelay");
        Intrinsics.checkNotNullParameter((Object)firstDelay, (String)"firstDelay");
        Intrinsics.checkNotNullParameter(loggerClass, (String)"loggerClass");
        Intrinsics.checkNotNullParameter((Object)loggingLevel, (String)"loggingLevel");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        super(name);
        this.name = name;
        this.fixedRateDelay = fixedRateDelay;
        this.firstDelay = firstDelay;
        this.loggerClass = loggerClass;
        this.loggingLevel = loggingLevel;
        this.runnable = runnable;
        this.init();
    }

    public /* synthetic */ OneThreadPerTaskFixedDelayScheduler(String string, Duration duration, Duration duration2, KClass kClass, Level level, Runnable runnable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            Level level2 = Level.FINEST;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"FINEST");
            level = level2;
        }
        this(string, duration, duration2, kClass, level, runnable);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Duration getFixedRateDelay() {
        return this.fixedRateDelay;
    }

    @NotNull
    public final Duration getFirstDelay() {
        return this.firstDelay;
    }

    @NotNull
    protected final KClass<?> getLoggerClass() {
        return this.loggerClass;
    }

    @NotNull
    protected final Level getLoggingLevel() {
        return this.loggingLevel;
    }

    @NotNull
    protected final Runnable getRunnable() {
        return this.runnable;
    }

    @NotNull
    protected AtomicLong getCounter() {
        return new AtomicLong(1L);
    }

    private final void init() {
        this.initTimer();
    }

    @NotNull
    protected Timer initTimer() {
        RunnableTimerTask task = new RunnableTimerTask(this.name, this.getCounter(), this.loggerClass, this.loggingLevel, this.runnable);
        this.scheduleAtFixedRate((TimerTask)task, this.firstDelay.toMillis(), this.fixedRateDelay.toMillis());
        return this;
    }
}

