/*
 * Decompiled with CFR 0.152.
 */
package io.github.breninsul.javatimerscheduler.timer;

import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\f\b\u0002\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lio/github/breninsul/javatimerscheduler/timer/RunnableTimerTask;", "Ljava/util/TimerTask;", "name", "", "counter", "Ljava/util/concurrent/atomic/AtomicLong;", "loggerClass", "Lkotlin/reflect/KClass;", "loggingLevel", "Ljava/util/logging/Level;", "runnable", "Ljava/lang/Runnable;", "(Ljava/lang/String;Ljava/util/concurrent/atomic/AtomicLong;Lkotlin/reflect/KClass;Ljava/util/logging/Level;Ljava/lang/Runnable;)V", "getCounter", "()Ljava/util/concurrent/atomic/AtomicLong;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Ljava/util/logging/Logger;", "getLoggerClass", "()Lkotlin/reflect/KClass;", "getLoggingLevel", "()Ljava/util/logging/Level;", "getName", "()Ljava/lang/String;", "getRunnable", "()Ljava/lang/Runnable;", "run", "", "java-timer-scheduler"})
public class RunnableTimerTask
extends TimerTask {
    @NotNull
    private final String name;
    @NotNull
    private final AtomicLong counter;
    @NotNull
    private final KClass<?> loggerClass;
    @NotNull
    private final Level loggingLevel;
    @NotNull
    private final Runnable runnable;
    private final Logger logger;

    public RunnableTimerTask(@NotNull String name, @NotNull AtomicLong counter, @NotNull KClass<?> loggerClass, @NotNull Level loggingLevel, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        Intrinsics.checkNotNullParameter(loggerClass, (String)"loggerClass");
        Intrinsics.checkNotNullParameter((Object)loggingLevel, (String)"loggingLevel");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.name = name;
        this.counter = counter;
        this.loggerClass = loggerClass;
        this.loggingLevel = loggingLevel;
        this.runnable = runnable;
        this.logger = Logger.getLogger(JvmClassMappingKt.getJavaClass(this.loggerClass).getName());
    }

    public /* synthetic */ RunnableTimerTask(String string, AtomicLong atomicLong, KClass kClass, Level level, Runnable runnable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            atomicLong = new AtomicLong(0L);
        }
        if ((n & 4) != 0) {
            kClass = Reflection.getOrCreateKotlinClass(RunnableTimerTask.class);
        }
        if ((n & 8) != 0) {
            Level level2 = Level.FINEST;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"FINEST");
            level = level2;
        }
        this(string, atomicLong, kClass, level, runnable);
    }

    @NotNull
    protected final String getName() {
        return this.name;
    }

    @NotNull
    protected final AtomicLong getCounter() {
        return this.counter;
    }

    @NotNull
    protected final KClass<?> getLoggerClass() {
        return this.loggerClass;
    }

    @NotNull
    protected final Level getLoggingLevel() {
        return this.loggingLevel;
    }

    @NotNull
    protected final Runnable getRunnable() {
        return this.runnable;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public void run() {
        Object object;
        long time = System.currentTimeMillis();
        try {
            this.runnable.run();
            object = "";
        }
        catch (Throwable t) {
            object = "Exception executing Task " + this.name + ". " + t.getClass() + ":" + t.getMessage();
        }
        String errorText = object;
        this.getLogger().log(this.loggingLevel, this.name + " job \u2116" + this.counter.getAndIncrement() + " took " + (System.currentTimeMillis() - time) + "ms. " + errorText);
    }
}

