/*
 * Decompiled with CFR 0.152.
 */
package io.github.breninsul.javatimerscheduler.timer;

import io.github.breninsul.javatimerscheduler.SemaphoreExtensionKt;
import io.github.breninsul.javatimerscheduler.timer.RunnableTimerTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\f\b\u0002\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0013H\u0004J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0004J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0013H&R\u0014\u0010\r\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lio/github/breninsul/javatimerscheduler/timer/VirtualTimerTask;", "Lio/github/breninsul/javatimerscheduler/timer/RunnableTimerTask;", "name", "", "counter", "Ljava/util/concurrent/atomic/AtomicLong;", "loggerClass", "Lkotlin/reflect/KClass;", "loggingLevel", "Ljava/util/logging/Level;", "runnable", "Ljava/lang/Runnable;", "(Ljava/lang/String;Ljava/util/concurrent/atomic/AtomicLong;Lkotlin/reflect/KClass;Ljava/util/logging/Level;Ljava/lang/Runnable;)V", "semaphore", "Ljava/util/concurrent/Semaphore;", "getSemaphore", "()Ljava/util/concurrent/Semaphore;", "threadsList", "", "Ljava/lang/Thread;", "getThreadsList", "()Ljava/util/List;", "addThread", "", "thread", "cancel", "", "removeAny", "removeThread", "run", "runInternal", "currentThread", "java-timer-scheduler"})
public abstract class VirtualTimerTask
extends RunnableTimerTask {
    @NotNull
    private final List<Thread> threadsList;
    @NotNull
    private final Semaphore semaphore;

    public VirtualTimerTask(@NotNull String name, @NotNull AtomicLong counter, @NotNull KClass<?> loggerClass, @NotNull Level loggingLevel, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        Intrinsics.checkNotNullParameter(loggerClass, (String)"loggerClass");
        Intrinsics.checkNotNullParameter((Object)loggingLevel, (String)"loggingLevel");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        super(name, counter, loggerClass, loggingLevel, runnable);
        this.threadsList = new ArrayList();
        this.semaphore = new Semaphore(1);
    }

    public /* synthetic */ VirtualTimerTask(String string, AtomicLong atomicLong, KClass kClass, Level level, Runnable runnable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            atomicLong = new AtomicLong(0L);
        }
        if ((n & 4) != 0) {
            kClass = Reflection.getOrCreateKotlinClass(VirtualTimerTask.class);
        }
        if ((n & 8) != 0) {
            Level level2 = Level.FINEST;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"FINEST");
            level = level2;
        }
        this(string, atomicLong, kClass, level, runnable);
    }

    @NotNull
    protected List<Thread> getThreadsList() {
        return this.threadsList;
    }

    @NotNull
    protected Semaphore getSemaphore() {
        return this.semaphore;
    }

    @Override
    public boolean cancel() {
        try {
            Thread thread = this.removeAny();
            while (thread != null) {
                thread.interrupt();
                thread = this.removeAny();
            }
        }
        catch (Throwable t) {
            this.getLogger().log(Level.FINEST, "Error during virtual thread cancellation", t);
        }
        return super.cancel();
    }

    @Override
    public void run() {
        Thread.ofVirtual().name(this.getName()).start(() -> VirtualTimerTask.run$lambda$0(this));
    }

    public abstract void runInternal(@NotNull Thread var1);

    protected final void addThread(@NotNull Thread thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        SemaphoreExtensionKt.sync(this.getSemaphore(), () -> VirtualTimerTask.addThread$lambda$1(this, thread));
    }

    protected final void removeThread(@NotNull Thread thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        SemaphoreExtensionKt.sync(this.getSemaphore(), () -> VirtualTimerTask.removeThread$lambda$2(this, thread));
    }

    @Nullable
    protected final Thread removeAny() {
        return SemaphoreExtensionKt.sync(this.getSemaphore(), () -> VirtualTimerTask.removeAny$lambda$3(this));
    }

    private static final void run$lambda$0(VirtualTimerTask this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Thread currentThread = Thread.currentThread();
        Intrinsics.checkNotNull((Object)currentThread);
        this$0.runInternal(currentThread);
    }

    private static final Boolean addThread$lambda$1(VirtualTimerTask this$0, Thread $thread) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$thread, (String)"$thread");
        return this$0.getThreadsList().add($thread);
    }

    private static final Boolean removeThread$lambda$2(VirtualTimerTask this$0, Thread $thread) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$thread, (String)"$thread");
        return this$0.getThreadsList().remove($thread);
    }

    private static final Thread removeAny$lambda$3(VirtualTimerTask this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (Thread)CollectionsKt.removeFirstOrNull(this$0.getThreadsList());
    }
}

