/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.devintest.api.resources.imdb;

import com.devintest.api.core.ClientOptions;
import com.devintest.api.core.RequestOptions;
import com.devintest.api.resources.imdb.types.CreateMovieRequest;
import com.devintest.api.resources.imdb.types.Movie;

public class ImdbClient {
    protected final ClientOptions clientOptions;

    private final RawImdbClient rawClient;

    public ImdbClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawImdbClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawImdbClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Add a movie to the database
     */
    public String createMovie(CreateMovieRequest request) {
        return this.rawClient.createMovie(request).body();
    }

    /**
     * Add a movie to the database
     */
    public String createMovie(CreateMovieRequest request, RequestOptions requestOptions) {
        return this.rawClient.createMovie(request, requestOptions).body();
    }

    /**
     * Retrieve a movie from the database based on the ID
     */
    public Movie getMovie(String id) {
        return this.rawClient.getMovie(id).body();
    }

    /**
     * Retrieve a movie from the database based on the ID
     */
    public Movie getMovie(String id, RequestOptions requestOptions) {
        return this.rawClient.getMovie(id, requestOptions).body();
    }
}
