/*
 * Decompiled with CFR 0.152.
 */
package com.devintest.api;

import com.devintest.api.AsyncDevintestApiClient;
import com.devintest.api.core.ClientOptions;
import com.devintest.api.core.Environment;
import java.util.Optional;
import okhttp3.OkHttpClient;

public class AsyncDevintestApiClientBuilder {
    private Optional<Integer> timeout = Optional.empty();
    private Optional<Integer> maxRetries = Optional.empty();
    private Environment environment;
    private OkHttpClient httpClient;

    public AsyncDevintestApiClientBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    public AsyncDevintestApiClientBuilder timeout(int timeout) {
        this.timeout = Optional.of(timeout);
        return this;
    }

    public AsyncDevintestApiClientBuilder maxRetries(int maxRetries) {
        this.maxRetries = Optional.of(maxRetries);
        return this;
    }

    public AsyncDevintestApiClientBuilder httpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    protected ClientOptions buildClientOptions() {
        ClientOptions.Builder builder = ClientOptions.builder();
        this.setEnvironment(builder);
        this.setHttpClient(builder);
        this.setTimeouts(builder);
        this.setRetries(builder);
        this.setAdditional(builder);
        return builder.build();
    }

    protected void setEnvironment(ClientOptions.Builder builder) {
        builder.environment(this.environment);
    }

    protected void setTimeouts(ClientOptions.Builder builder) {
        if (this.timeout.isPresent()) {
            builder.timeout(this.timeout.get());
        }
    }

    protected void setRetries(ClientOptions.Builder builder) {
        if (this.maxRetries.isPresent()) {
            builder.maxRetries(this.maxRetries.get());
        }
    }

    protected void setHttpClient(ClientOptions.Builder builder) {
        if (this.httpClient != null) {
            builder.httpClient(this.httpClient);
        }
    }

    protected void setAdditional(ClientOptions.Builder builder) {
    }

    protected void validateConfiguration() {
    }

    public AsyncDevintestApiClient build() {
        this.validateConfiguration();
        return new AsyncDevintestApiClient(this.buildClientOptions());
    }
}

