/*
 * Decompiled with CFR 0.152.
 */
package com.devintest.api.core;

import com.devintest.api.core.ObjectMappers;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Scanner;

public final class Stream<T>
implements Iterable<T>,
Closeable {
    private static final String NEWLINE = "\n";
    private static final String DATA_PREFIX = "data:";
    private final Class<T> valueType;
    private final Scanner scanner;
    private final StreamType streamType;
    private final String messageTerminator;
    private final String streamTerminator;
    private final Reader sseReader;
    private boolean isClosed = false;

    public Stream(Class<T> valueType, Reader reader, String delimiter) {
        this.valueType = valueType;
        this.scanner = new Scanner(reader).useDelimiter(delimiter);
        this.streamType = StreamType.JSON;
        this.messageTerminator = delimiter;
        this.streamTerminator = null;
        this.sseReader = null;
    }

    private Stream(Class<T> valueType, StreamType type, Reader reader, String terminator) {
        this.valueType = valueType;
        this.streamType = type;
        if (type == StreamType.JSON) {
            this.scanner = new Scanner(reader).useDelimiter(terminator);
            this.messageTerminator = terminator;
            this.streamTerminator = null;
            this.sseReader = null;
        } else {
            this.scanner = null;
            this.messageTerminator = NEWLINE;
            this.streamTerminator = terminator;
            this.sseReader = reader;
        }
    }

    public static <T> Stream<T> fromJson(Class<T> valueType, Reader reader, String delimiter) {
        return new Stream<T>(valueType, reader, delimiter);
    }

    public static <T> Stream<T> fromJson(Class<T> valueType, Reader reader) {
        return new Stream<T>(valueType, reader, NEWLINE);
    }

    public static <T> Stream<T> fromSse(Class<T> valueType, Reader sseReader) {
        return new Stream<T>(valueType, StreamType.SSE, sseReader, null);
    }

    public static <T> Stream<T> fromSse(Class<T> valueType, Reader sseReader, String streamTerminator) {
        return new Stream<T>(valueType, StreamType.SSE, sseReader, streamTerminator);
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            if (this.scanner != null) {
                this.scanner.close();
            }
            if (this.sseReader != null) {
                this.sseReader.close();
            }
        }
    }

    private boolean isStreamClosed() {
        return this.isClosed;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.streamType == StreamType.SSE) {
            return new SSEIterator();
        }
        return new JsonIterator();
    }

    static /* synthetic */ String access$600(Stream x0) {
        return x0.messageTerminator;
    }

    static /* synthetic */ String access$700(Stream x0) {
        return x0.streamTerminator;
    }

    private final class SSEIterator
    implements Iterator<T> {
        private Scanner sseScanner;
        private T nextItem;
        private boolean hasNextItem = false;
        private boolean endOfStream = false;
        private StringBuilder buffer = new StringBuilder();
        private boolean prefixSeen = false;

        private SSEIterator() {
            if (Stream.this.sseReader != null && !Stream.this.isStreamClosed()) {
                this.sseScanner = new Scanner(Stream.this.sseReader);
            } else {
                this.endOfStream = true;
            }
        }

        @Override
        public boolean hasNext() {
            if (Stream.this.isStreamClosed() || this.endOfStream) {
                return false;
            }
            if (this.hasNextItem) {
                return true;
            }
            return this.readNextMessage();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements in stream");
            }
            Object result = this.nextItem;
            this.nextItem = null;
            this.hasNextItem = false;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * Exception decompiling
         */
        private boolean readNextMessage() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private final class JsonIterator
    implements Iterator<T> {
        private JsonIterator() {
        }

        @Override
        public boolean hasNext() {
            if (Stream.this.isStreamClosed()) {
                return false;
            }
            return Stream.this.scanner.hasNext();
        }

        @Override
        public T next() {
            if (Stream.this.isStreamClosed()) {
                throw new NoSuchElementException("Stream is closed");
            }
            if (!Stream.this.scanner.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Object parsedResponse = ObjectMappers.JSON_MAPPER.readValue(Stream.this.scanner.next().trim(), Stream.this.valueType);
                return parsedResponse;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum StreamType {
        JSON,
        SSE;

    }
}

