/*
 * Decompiled with CFR 0.152.
 */
package com.devlibx.graph.core;

import com.devlibx.graph.core.GraphNode;
import com.devlibx.graph.core.ITraversal;
import com.devlibx.graph.domain.Graph;
import com.devlibx.graph.domain.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GraphInstance {
    public Map<String, GraphNode> nodes = new HashMap<String, GraphNode>();
    public GraphNode startNode;
    public GraphNode endNode;

    public void initGraph(Graph graph) {
        graph.getSource().forEach(node -> {
            GraphNode graphNode = new GraphNode((Node)node);
            this.nodes.put(graphNode.getId(), graphNode);
        });
        graph.getTransformation().forEach(node -> {
            GraphNode graphNode = new GraphNode((Node)node);
            this.nodes.put(graphNode.getId(), graphNode);
        });
        graph.getSink().forEach(node -> {
            GraphNode graphNode = new GraphNode((Node)node);
            this.nodes.put(graphNode.getId(), graphNode);
        });
        this.startNode = new GraphNode(graph.getStart());
        this.nodes.put(this.startNode.getId(), this.startNode);
        this.endNode = new GraphNode(graph.getEnd());
        this.nodes.put(this.endNode.getId(), this.endNode);
        this.setupGraph();
    }

    private void setupGraph() {
        this.nodes.forEach((nodeId, graphNode) -> {
            if (!graphNode.dependsOn()) {
                return;
            }
            graphNode.getNode().getDependsOn().stream().map(parentId -> this.nodes.get(parentId)).forEach(parentNode -> {
                parentNode.addChild((GraphNode)graphNode);
                graphNode.addParent((GraphNode)parentNode);
            });
        });
    }

    @Deprecated
    public List<String> traversDoNotUse(ITraversal traversal) {
        ArrayList<String> result = new ArrayList<String>();
        traversal.travers(this.endNode, result);
        return result;
    }

    public List<String> travers(ITraversal traversal) {
        ArrayList<String> result = new ArrayList<String>();
        traversal.travers(this.startNode, result);
        return result;
    }

    @Deprecated
    public List<String> traversDoNotUseV1(GraphNode node, ITraversal traversal) {
        ArrayList<String> result = new ArrayList<String>();
        traversal.travers(node, result);
        return result;
    }

    public Map<String, GraphNode> getNodes() {
        return this.nodes;
    }

    public GraphNode getStartNode() {
        return this.startNode;
    }

    public GraphNode getEndNode() {
        return this.endNode;
    }

    public void setNodes(Map<String, GraphNode> nodes) {
        this.nodes = nodes;
    }

    public void setStartNode(GraphNode startNode) {
        this.startNode = startNode;
    }

    public void setEndNode(GraphNode endNode) {
        this.endNode = endNode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphInstance)) {
            return false;
        }
        GraphInstance other = (GraphInstance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, GraphNode> this$nodes = this.getNodes();
        Map<String, GraphNode> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        GraphNode this$startNode = this.getStartNode();
        GraphNode other$startNode = other.getStartNode();
        if (this$startNode == null ? other$startNode != null : !((Object)this$startNode).equals(other$startNode)) {
            return false;
        }
        GraphNode this$endNode = this.getEndNode();
        GraphNode other$endNode = other.getEndNode();
        return !(this$endNode == null ? other$endNode != null : !((Object)this$endNode).equals(other$endNode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GraphInstance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, GraphNode> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        GraphNode $startNode = this.getStartNode();
        result = result * 59 + ($startNode == null ? 43 : ((Object)$startNode).hashCode());
        GraphNode $endNode = this.getEndNode();
        result = result * 59 + ($endNode == null ? 43 : ((Object)$endNode).hashCode());
        return result;
    }

    public String toString() {
        return "GraphInstance(nodes=" + this.getNodes() + ", startNode=" + this.getStartNode() + ", endNode=" + this.getEndNode() + ")";
    }
}

