/*
 * Decompiled with CFR 0.152.
 */
package com.devlibx.graph.core;

import com.devlibx.graph.domain.Node;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class GraphNode {
    public static final boolean ADD_PARENTS = false;
    private String id;
    private Node node;
    private Set<GraphNode> vertices;
    private Set<GraphNode> parents;

    GraphNode(Node node) {
        this(node.getId(), node);
    }

    GraphNode(String id, Node node) {
        this.id = id;
        this.node = node;
        this.vertices = new HashSet<GraphNode>();
        this.parents = new HashSet<GraphNode>();
    }

    public void addParent(GraphNode parent) {
    }

    public void addChild(GraphNode child) {
        this.vertices.add(child);
    }

    public boolean dependsOn() {
        return this.node != null && this.node.checkDependsOn();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        try {
            return "Id=" + this.id + "" + " child=" + this.vertices.stream().map(GraphNode::getId).collect(Collectors.toList());
        }
        catch (Exception e) {
            return "Id=" + this.id;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphNode graphNode = (GraphNode)o;
        return this.id.equals(graphNode.id);
    }

    public String getId() {
        return this.id;
    }

    public Node getNode() {
        return this.node;
    }

    public Set<GraphNode> getVertices() {
        return this.vertices;
    }

    public Set<GraphNode> getParents() {
        return this.parents;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void setVertices(Set<GraphNode> vertices) {
        this.vertices = vertices;
    }

    public void setParents(Set<GraphNode> parents) {
        this.parents = parents;
    }

    public GraphNode() {
    }
}

