/*
 * Decompiled with CFR 0.152.
 */
package ru.proninyaroslav.template;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.proninyaroslav.template.FuncMap;
import ru.proninyaroslav.template.Utils;

public class BuiltinsFuncs {
    static FuncMap create() {
        FuncMap fm = new FuncMap();
        HashMap<String, String> builtins = new HashMap<String, String>();
        builtins.put("range", "range");
        builtins.put("index", "index");
        builtins.put("print", "print");
        builtins.put("println", "println");
        fm.put("printf", "format", String.class);
        builtins.put("add", "add");
        builtins.put("sub", "sub");
        builtins.put("mul", "mul");
        builtins.put("div", "div");
        builtins.put("mod", "mod");
        builtins.put("eq", "equal");
        builtins.put("ne", "notEqual");
        builtins.put("lt", "lessThan");
        builtins.put("le", "lessThanOrEqual");
        builtins.put("gt", "greaterThan");
        builtins.put("ge", "greaterThanOrEqual");
        builtins.put("or", "or");
        builtins.put("and", "and");
        builtins.put("not", "not");
        fm.put(builtins, BuiltinsFuncs.class);
        return fm;
    }

    public static int[] range(int stop) {
        return BuiltinsFuncs.range(0, stop);
    }

    public static int[] range(int start, int stop) {
        return BuiltinsFuncs.range(start, stop, start < stop ? 1 : -1);
    }

    public static int[] range(int start, int stop, int step) {
        if (step == 0) {
            throw new IllegalArgumentException("step must not be zero");
        }
        if (stop == start || start > stop && step > 0 || start < stop && step < 0) {
            return null;
        }
        int length = (int)Math.ceil((double)Math.abs(stop - start) / (double)Math.abs(step));
        int[] arr = new int[length];
        int n = start;
        for (int i = 0; i < length; ++i) {
            arr[i] = n;
            n += step;
        }
        return arr;
    }

    public static Object index(Object arr, Object ... indexes) {
        if (arr == null) {
            throw new IllegalArgumentException("the array/list must not be null");
        }
        Object a = arr;
        for (Object i : indexes) {
            if (a.getClass().isArray()) {
                a = Array.get(a, (Integer)i);
                continue;
            }
            if (List.class.isInstance(a)) {
                a = ((List)a).get((Integer)i);
                continue;
            }
            if (Map.class.isInstance(a)) {
                a = ((Map)a).get(i);
                continue;
            }
            throw new IllegalArgumentException("can't index object with type " + a.getClass());
        }
        return a;
    }

    public static String print(Object ... args) {
        StringBuilder sb = new StringBuilder();
        int size = args.length;
        for (int i = 0; i < size; ++i) {
            sb.append(args[i]);
            if (i == size - 1 || String.class.isInstance(args[i])) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String println(Object ... args) {
        StringBuilder sb = new StringBuilder();
        for (Object arg : args) {
            sb.append(arg).append(" ");
        }
        sb.append("\n");
        return sb.toString();
    }

    public static boolean equal(Object arg1, Object ... arg2) {
        if (arg2.length == 0) {
            throw new IllegalArgumentException("can't equal only one argument");
        }
        for (Object arg : arg2) {
            if (!arg1.equals(arg)) continue;
            return true;
        }
        return false;
    }

    public static boolean notEqual(Object a, Object b) {
        return !a.equals(b);
    }

    public static boolean lessThan(Object a, Object b) {
        return BuiltinsFuncs.compare(a, b, "<");
    }

    public static boolean lessThanOrEqual(Object a, Object b) {
        return BuiltinsFuncs.compare(a, b, "<=");
    }

    public static boolean greaterThan(Object a, Object b) {
        return BuiltinsFuncs.compare(a, b, ">");
    }

    public static boolean greaterThanOrEqual(Object a, Object b) {
        return BuiltinsFuncs.compare(a, b, ">=");
    }

    public static boolean not(Object a) {
        return !Utils.isTrue(a);
    }

    public static Object and(Object arg0, Object ... args) {
        Object arg;
        if (!Utils.isTrue(arg0)) {
            return arg0;
        }
        Object[] objectArray = args;
        int n = objectArray.length;
        for (int i = 0; i < n && Utils.isTrue(arg0 = (arg = objectArray[i])); ++i) {
        }
        return arg0;
    }

    public static Object or(Object arg0, Object ... args) {
        Object arg;
        if (Utils.isTrue(arg0)) {
            return arg0;
        }
        Object[] objectArray = args;
        int n = objectArray.length;
        for (int i = 0; i < n && !Utils.isTrue(arg0 = (arg = objectArray[i])); ++i) {
        }
        return arg0;
    }

    public static Object add(Object a, Object b) {
        return BuiltinsFuncs.doArithmetic(a, b, '+');
    }

    public static Object sub(Object a, Object b) {
        return BuiltinsFuncs.doArithmetic(a, b, '-');
    }

    public static Object mul(Object a, Object b) {
        return BuiltinsFuncs.doArithmetic(a, b, '*');
    }

    public static Object div(Object a, Object b) {
        return BuiltinsFuncs.doArithmetic(a, b, '/');
    }

    public static Object mod(Object a, Object b) {
        return BuiltinsFuncs.doArithmetic(a, b, '%');
    }

    public static boolean compare(Object a, Object b, String op) {
        double bd;
        double ad;
        String errFmt = String.format("can't apply %s to the values %s (%s) and %s (%s)", op, a, a.getClass().getName(), b, b.getClass().getName());
        if (a instanceof Number) {
            ad = ((Number)a).doubleValue();
        } else if (a instanceof Character) {
            ad = ((Character)a).charValue();
        } else {
            throw new IllegalArgumentException(errFmt);
        }
        if (b instanceof Number) {
            bd = ((Number)b).doubleValue();
        } else if (b instanceof Character) {
            bd = ((Character)b).charValue();
        } else {
            throw new IllegalArgumentException(errFmt);
        }
        switch (op) {
            case "<": {
                return ad < bd;
            }
            case ">": {
                return ad > bd;
            }
            case "<=": {
                return ad <= bd;
            }
            case ">=": {
                return ad >= bd;
            }
        }
        throw new IllegalArgumentException(errFmt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object doArithmetic(Object a, Object b, char op) {
        String errFmt = String.format("can't apply %c to the values %s (%s) and %s (%s)", Character.valueOf(op), a, a.getClass().getName(), b, b.getClass().getName());
        int ai = 0;
        int bi = 0;
        long al = 0L;
        long bl = 0L;
        double ad = 0.0;
        double bd = 0.0;
        if (a instanceof Integer || a instanceof Character || a instanceof Short || a instanceof Byte) {
            int n = ai = a instanceof Character ? ((Character)a).charValue() : ((Number)a).intValue();
            if (b instanceof Integer || b instanceof Short || b instanceof Byte) {
                bi = ((Number)b).intValue();
            } else if (b instanceof Character) {
                bi = ((Character)b).charValue();
            } else if (b instanceof Long) {
                al = ai;
                ai = 0;
                bl = (Long)b;
            } else {
                if (!(b instanceof Double) && !(b instanceof Float)) throw new IllegalArgumentException(errFmt);
                ad = ((Number)ai).doubleValue();
                ai = 0;
                bd = ((Number)b).doubleValue();
            }
        } else if (a instanceof Long) {
            al = (Long)a;
            if (b instanceof Integer || b instanceof Long || b instanceof Short || b instanceof Byte) {
                bl = ((Number)b).longValue();
            } else if (b instanceof Character) {
                bl = ((Character)b).charValue();
            } else {
                if (!(b instanceof Double) && !(b instanceof Float)) throw new IllegalArgumentException(errFmt);
                ad = ((Number)al).doubleValue();
                al = 0L;
                bd = ((Number)b).doubleValue();
            }
        } else if (a instanceof Double || a instanceof Float) {
            ad = ((Number)a).doubleValue();
            if (b instanceof Integer || b instanceof Long || b instanceof Short || b instanceof Byte) {
                bd = ((Number)b).longValue();
            } else if (b instanceof Character) {
                bd = ((Character)b).charValue();
            } else {
                if (!(b instanceof Double) && !(b instanceof Float)) throw new IllegalArgumentException(errFmt);
                bd = ((Number)b).doubleValue();
            }
        } else {
            if (!(a instanceof String)) throw new IllegalArgumentException(errFmt);
            String as = (String)a;
            if (!(b instanceof String) || op != '+') throw new IllegalArgumentException(errFmt);
            return as + b;
        }
        switch (op) {
            case '+': {
                if (ai != 0 || bi != 0) {
                    return ai + bi;
                }
                if (al != 0L || bl != 0L) {
                    return al + bl;
                }
                if (ad == 0.0 && bd == 0.0) return 0;
                return ad + bd;
            }
            case '-': {
                if (ai != 0 || bi != 0) {
                    return ai - bi;
                }
                if (al != 0L || bl != 0L) {
                    return al - bl;
                }
                if (ad == 0.0 && bd == 0.0) return 0;
                return ad - bd;
            }
            case '*': {
                if (ai != 0 || bi != 0) {
                    return ai * bi;
                }
                if (al != 0L || bl != 0L) {
                    return al * bl;
                }
                if (ad == 0.0 && bd == 0.0) return 0;
                return ad * bd;
            }
            case '/': {
                if (bi != 0) {
                    return ai / bi;
                }
                if (bl != 0L) {
                    return al / bl;
                }
                if (bd == 0.0) throw new IllegalArgumentException("can't divide the value by 0");
                return ad / bd;
            }
            case '%': {
                if (bi != 0) {
                    return ai % bi;
                }
                if (bl != 0L) {
                    return al % bl;
                }
                if (bd == 0.0) throw new IllegalArgumentException("can't modulo the value by 0");
                return ad % bd;
            }
        }
        throw new IllegalArgumentException("no such an operation " + op);
    }
}

