/*
 * Decompiled with CFR 0.152.
 */
package ru.proninyaroslav.template;

import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import ru.proninyaroslav.template.Token;
import ru.proninyaroslav.template.Utils;
import ru.proninyaroslav.template.exceptions.InternalException;

class Lexer
implements Runnable {
    private static final HashMap<String, Token.Type> words = Lexer.initWords();
    private static final char EOF = '\u0000';
    private static final char MAX_ASCII = '\u007f';
    private static final String defaultLeftDelim = "{{";
    private static final String defaultRightDelim = "}}";
    private static final String leftComment = "/*";
    private static final String rightComment = "*/";
    private String name;
    private String input;
    private String leftDelim;
    private String rightDelim;
    private int pos;
    private int start;
    private int parenDepth;
    private int line;
    private LinkedBlockingQueue<Token> tokens;

    private static HashMap<String, Token.Type> initWords() {
        HashMap<String, Token.Type> map = new HashMap<String, Token.Type>();
        map.put(".", Token.Type.DOT);
        map.put("define", Token.Type.DEFINE);
        map.put("else", Token.Type.ELSE);
        map.put("end", Token.Type.END);
        map.put("if", Token.Type.IF);
        map.put("for", Token.Type.FOR);
        map.put("break", Token.Type.BREAK);
        map.put("continue", Token.Type.CONTINUE);
        map.put("with", Token.Type.WITH);
        map.put("null", Token.Type.NULL);
        map.put("template", Token.Type.TEMPLATE);
        return map;
    }

    public Lexer(String name, String input, String leftDelim, String rightDelim) {
        this.name = name;
        this.input = input;
        this.leftDelim = leftDelim == null ? defaultLeftDelim : leftDelim;
        this.rightDelim = rightDelim == null ? defaultRightDelim : rightDelim;
        this.tokens = new LinkedBlockingQueue();
        this.line = 1;
        new Thread(this).start();
    }

    @Override
    public void run() {
        State state = State.lexText;
        while (state != null) {
            state = this.callStateFn(state);
        }
    }

    public void drain() {
        this.tokens.clear();
    }

    public Token nextToken() throws InternalException {
        Token token;
        try {
            token = this.tokens.poll(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InternalException(e);
        }
        return token;
    }

    private State callStateFn(State state) {
        switch (state) {
            case lexText: {
                return this.lexText();
            }
            case lexLeftDelim: {
                return this.lexLeftDelim();
            }
            case lexComment: {
                return this.lexComment();
            }
            case lexInsideAction: {
                return this.lexInsideAction();
            }
            case lexRightDelim: {
                return this.lexRightDelim();
            }
            case lexSpace: {
                return this.lexSpace();
            }
            case lexQuote: {
                return this.lexQuote();
            }
            case lexRawQuote: {
                return this.lexRawQuote();
            }
            case lexVariable: {
                return this.lexVariable();
            }
            case lexChar: {
                return this.lexChar();
            }
            case lexField: {
                return this.lexField();
            }
            case lexNumber: {
                return this.lexNumber();
            }
            case lexIdentifier: {
                return this.lexIdentifier();
            }
        }
        return null;
    }

    private void backup() {
        --this.pos;
        if (this.pos < this.input.length() && this.input.charAt(this.pos) == '\n') {
            --this.line;
        }
    }

    private char peek() {
        char c = this.next();
        this.backup();
        return c;
    }

    private char next() {
        char c;
        if (this.pos >= this.input.length()) {
            ++this.pos;
            return '\u0000';
        }
        if ((c = this.input.charAt(this.pos++)) == '\n') {
            ++this.line;
        }
        return c;
    }

    private int countNewlines(String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\n') continue;
            ++count;
        }
        return count;
    }

    private void emit(Token.Type type) throws InternalError {
        String val = this.input.substring(this.start, this.pos);
        if (!this.tokens.offer(new Token(type, this.start, val, this.line))) {
            throw new InternalError("lex queue is full: " + this.tokens.size());
        }
        switch (type) {
            case TEXT: 
            case RAW_STRING: 
            case LEFT_DELIM: 
            case RIGHT_DELIM: {
                this.line += this.countNewlines(val);
            }
        }
        this.start = this.pos;
    }

    private State errorf(String format, Object ... args) {
        this.tokens.add(new Token(Token.Type.ERROR, this.start, String.format(format, args), this.line));
        return null;
    }

    private void ignore() {
        this.start = this.pos;
    }

    private boolean accept(String valid) {
        if (valid.indexOf(this.next()) >= 0) {
            return true;
        }
        this.backup();
        return false;
    }

    private void acceptAll(String valid) {
        while (valid.indexOf(this.next()) >= 0) {
        }
        this.backup();
    }

    private State lexText() {
        int i = this.input.substring(this.pos).indexOf(this.leftDelim);
        if (i >= 0) {
            this.pos += i;
            if (this.pos > this.start) {
                this.emit(Token.Type.TEXT);
            }
            this.ignore();
            return State.lexLeftDelim;
        }
        this.pos = this.input.length();
        if (this.pos > this.start) {
            this.emit(Token.Type.TEXT);
        }
        this.emit(Token.Type.EOF);
        return null;
    }

    private State lexLeftDelim() {
        this.pos += this.leftDelim.length();
        if (this.input.startsWith(leftComment, this.pos)) {
            this.ignore();
            return State.lexComment;
        }
        this.emit(Token.Type.LEFT_DELIM);
        this.ignore();
        this.parenDepth = 0;
        return State.lexInsideAction;
    }

    private State lexComment() {
        this.pos += leftComment.length();
        int i = this.input.substring(this.pos).indexOf(rightComment);
        if (i < 0) {
            return this.errorf("unclosed comment", new Object[0]);
        }
        this.pos += i + rightComment.length();
        if (!this.input.startsWith(this.rightDelim, this.pos)) {
            return this.errorf("comment ends before closing delimiter", new Object[0]);
        }
        this.pos += this.rightDelim.length();
        this.ignore();
        return State.lexText;
    }

    private State lexInsideAction() {
        if (this.input.startsWith(this.rightDelim, this.pos)) {
            if (this.parenDepth == 0) {
                return State.lexRightDelim;
            }
            return this.errorf("unclosed left paren", new Object[0]);
        }
        char c = this.next();
        if (c == '\u0000' || Utils.isEndOfLine(c)) {
            return this.errorf("unclosed action", new Object[0]);
        }
        if (Utils.isSpace(c)) {
            return State.lexSpace;
        }
        if (c == '=') {
            this.emit(Token.Type.ASSIGN);
        } else if (c == ':') {
            if (this.next() != '=') {
                this.errorf("expected :=", new Object[0]);
            }
            this.emit(Token.Type.DECLARE);
        } else if (c == '|') {
            this.emit(Token.Type.PIPE);
        } else {
            if (c == '\"') {
                return State.lexQuote;
            }
            if (c == '`') {
                return State.lexRawQuote;
            }
            if (c == '$') {
                return State.lexVariable;
            }
            if (c == '\'') {
                return State.lexChar;
            }
            if (c == '.') {
                char ch;
                if (this.pos < this.input.length() && ((ch = this.input.charAt(this.pos)) < '0' || ch > '9')) {
                    return State.lexField;
                }
                this.backup();
                return State.lexNumber;
            }
            if (c == '+' || c == '-' || '0' <= c && c <= '9') {
                this.backup();
                return State.lexNumber;
            }
            if (Utils.isAlphaNumeric(c)) {
                this.backup();
                return State.lexIdentifier;
            }
            if (c == '(') {
                this.emit(Token.Type.LEFT_PAREN);
                ++this.parenDepth;
            } else if (c == ')') {
                this.emit(Token.Type.RIGHT_PAREN);
                --this.parenDepth;
                if (this.parenDepth < 0) {
                    this.errorf("unexpected right paren %c", Character.valueOf(c));
                }
            } else {
                if (c <= '\u007f') {
                    this.emit(Token.Type.CHAR);
                    return State.lexInsideAction;
                }
                return this.errorf("unrecognized character in action: %c", Character.valueOf(c));
            }
        }
        return State.lexInsideAction;
    }

    private State lexRightDelim() {
        this.pos += this.rightDelim.length();
        this.emit(Token.Type.RIGHT_DELIM);
        return State.lexText;
    }

    private State lexSpace() {
        while (Utils.isSpace(this.peek())) {
            this.next();
        }
        this.emit(Token.Type.SPACE);
        return State.lexInsideAction;
    }

    /*
     * Enabled aggressive block sorting
     */
    private State lexQuote() {
        block5: while (true) {
            switch (this.next()) {
                case '\\': {
                    char c = this.next();
                    if (c != '\u0000' && c != '\n') break;
                }
                case '\u0000': 
                case '\n': {
                    return this.errorf("unterminated quoted string", new Object[0]);
                }
                case '\"': {
                    break block5;
                }
            }
        }
        this.emit(Token.Type.STRING);
        return State.lexInsideAction;
    }

    private State lexRawQuote() {
        int startLine = this.line;
        block4: while (true) {
            switch (this.next()) {
                case '\u0000': {
                    this.line = startLine;
                    return this.errorf("unterminated raw quoted string", new Object[0]);
                }
                case '`': {
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
            break;
        }
        this.emit(Token.Type.RAW_STRING);
        return State.lexInsideAction;
    }

    private State lexVariable() {
        if (this.atTerminator()) {
            this.emit(Token.Type.VARIABLE);
            return State.lexInsideAction;
        }
        return this.lexFieldOrVariable(Token.Type.VARIABLE);
    }

    private State lexField() {
        return this.lexFieldOrVariable(Token.Type.FIELD);
    }

    private boolean atTerminator() {
        char c = this.peek();
        if (Utils.isSpace(c) || Utils.isEndOfLine(c)) {
            return true;
        }
        switch (c) {
            case '\u0000': 
            case '(': 
            case ')': 
            case '.': 
            case '=': 
            case '|': {
                return true;
            }
        }
        return c == this.rightDelim.charAt(0);
    }

    private State lexFieldOrVariable(Token.Type type) {
        char c;
        if (this.atTerminator()) {
            if (type == Token.Type.VARIABLE) {
                this.emit(Token.Type.VARIABLE);
            } else {
                this.emit(Token.Type.DOT);
            }
            return State.lexInsideAction;
        }
        while (Utils.isAlphaNumeric(c = this.next())) {
        }
        this.backup();
        if (!this.atTerminator()) {
            return this.errorf("bad character %c", Character.valueOf(c));
        }
        this.emit(type);
        return State.lexInsideAction;
    }

    /*
     * Enabled aggressive block sorting
     */
    private State lexChar() {
        block5: while (true) {
            switch (this.next()) {
                case '\\': {
                    char c = this.next();
                    if (c != '\u0000' && c != '\n') break;
                }
                case '\u0000': 
                case '\n': {
                    return this.errorf("unterminated character constant", new Object[0]);
                }
                case '\'': {
                    break block5;
                }
            }
        }
        this.emit(Token.Type.CHAR_CONSTANT);
        return State.lexInsideAction;
    }

    private State lexNumber() {
        this.accept("+-");
        String digits = "0123456789";
        if (this.accept("0") && this.accept("xX")) {
            digits = "0123456789abcdefABCDEF";
        }
        this.acceptAll(digits);
        if (this.accept(".")) {
            this.acceptAll(digits);
        }
        if (this.accept("eE")) {
            this.accept("+-");
            this.acceptAll("0123456789");
        }
        if (Utils.isAlphaNumeric(this.peek())) {
            this.next();
            return this.errorf("bad number syntax: '%s'", this.input.substring(this.start, this.pos));
        }
        this.emit(Token.Type.NUMBER);
        return State.lexInsideAction;
    }

    private State lexIdentifier() {
        char c;
        while (Utils.isAlphaNumeric(c = this.next())) {
        }
        this.backup();
        String word = this.input.substring(this.start, this.pos);
        if (!this.atTerminator()) {
            return this.errorf("bad character %c", Character.valueOf(c));
        }
        Token.Type key = words.get(word);
        if (key != null) {
            this.emit(key);
        } else if (word.charAt(0) == '.') {
            this.emit(Token.Type.FIELD);
        } else if (word.equals("true") || word.equals("false")) {
            this.emit(Token.Type.BOOL);
        } else {
            this.emit(Token.Type.IDENTIFIER);
        }
        return State.lexInsideAction;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Token t : this.tokens) {
            sb.append(t).append('\n');
        }
        return sb.toString();
    }

    private static enum State {
        lexText,
        lexLeftDelim,
        lexComment,
        lexInsideAction,
        lexRightDelim,
        lexSpace,
        lexQuote,
        lexRawQuote,
        lexVariable,
        lexChar,
        lexField,
        lexNumber,
        lexIdentifier;

    }
}

