/*
 * Decompiled with CFR 0.152.
 */
package ru.proninyaroslav.template;

import java.util.ArrayList;
import ru.proninyaroslav.template.Tree;
import ru.proninyaroslav.template.exceptions.ParseException;

abstract class Node {
    public Type type;
    public int pos;
    protected Tree tree;

    public Node(Tree tree, Type type, int pos) {
        this.tree = tree;
        this.type = type;
        this.pos = pos;
    }

    public abstract Node copy();

    public static class Template
    extends Node {
        public String name;
        public Pipe pipe;

        public Template(Tree tree, int pos, String name, Pipe pipe) {
            super(tree, Type.TEMPLATE, pos);
            this.name = name;
            this.pipe = pipe;
        }

        @Override
        public Node copy() {
            return new Template(this.tree, this.pos, this.name, this.pipe != null ? this.pipe.copyPipe() : null);
        }

        public String toString() {
            if (this.pipe == null) {
                return String.format("{{template \"%s\"}}", this.name);
            }
            return String.format("{{template \"%s\" %s}}", this.name, this.pipe);
        }
    }

    public static class Continue
    extends Node {
        public Continue(Tree tree, int pos) {
            super(tree, Type.CONTINUE, pos);
        }

        @Override
        public Node copy() {
            return new Continue(this.tree, this.pos);
        }

        public String toString() {
            return "{{continue}}";
        }
    }

    public static class Break
    extends Node {
        public Break(Tree tree, int pos) {
            super(tree, Type.BREAK, pos);
        }

        @Override
        public Node copy() {
            return new Break(this.tree, this.pos);
        }

        public String toString() {
            return "{{break}}";
        }
    }

    public static class With
    extends Branch {
        public With(Tree tree, int pos, Pipe pipe, List list, List elseList) {
            super(tree, Type.WITH, pos, pipe, list, elseList);
        }

        @Override
        public Node copy() {
            return new With(this.tree, this.pos, this.pipe.copyPipe(), this.list.copyList(), this.elseList != null ? this.elseList.copyList() : null);
        }
    }

    public static class For
    extends Branch {
        public For(Tree tree, int pos, Pipe pipe, List list, List elseList) {
            super(tree, Type.FOR, pos, pipe, list, elseList);
        }

        @Override
        public Node copy() {
            return new For(this.tree, this.pos, this.pipe.copyPipe(), this.list.copyList(), this.elseList != null ? this.elseList.copyList() : null);
        }
    }

    public static class If
    extends Branch {
        public If(Tree tree, int pos, Pipe pipe, List list, List elseList) {
            super(tree, Type.IF, pos, pipe, list, elseList);
        }

        @Override
        public Node copy() {
            return new If(this.tree, this.pos, this.pipe.copyPipe(), this.list.copyList(), this.elseList != null ? this.elseList.copyList() : null);
        }
    }

    public static class Branch
    extends Node {
        Pipe pipe;
        List list;
        List elseList;

        public Branch(Tree tree, Type type, int pos, Pipe pipe, List list, List elseList) {
            super(tree, type, pos);
            this.pipe = pipe;
            this.list = list;
            this.elseList = elseList;
        }

        @Override
        public Node copy() {
            switch (this.type) {
                case IF: {
                    return new If(this.tree, this.pos, this.pipe, this.list, this.elseList);
                }
                case FOR: {
                    return new For(this.tree, this.pos, this.pipe, this.list, this.elseList);
                }
                case WITH: {
                    return new With(this.tree, this.pos, this.pipe, this.list, this.elseList);
                }
            }
            return null;
        }

        public String toString() {
            String name;
            switch (this.type) {
                case IF: {
                    name = "if";
                    break;
                }
                case FOR: {
                    name = "for";
                    break;
                }
                case WITH: {
                    name = "with";
                    break;
                }
                default: {
                    return "unknown branch type";
                }
            }
            if (this.elseList != null) {
                return String.format("{{%s %s}}%s{{else}}%s{{end}}", name, this.pipe, this.list, this.elseList);
            }
            return String.format("{{%s %s}}%s{{end}}", name, this.pipe, this.list);
        }
    }

    public static class Else
    extends Node {
        public Else(Tree tree, int pos) {
            super(tree, Type.ELSE, pos);
        }

        @Override
        public Node copy() {
            return new Else(this.tree, this.pos);
        }

        public String toString() {
            return "{{else}}";
        }
    }

    public static class End
    extends Node {
        public End(Tree tree, int pos) {
            super(tree, Type.END, pos);
        }

        @Override
        public Node copy() {
            return new End(this.tree, this.pos);
        }

        public String toString() {
            return "{{end}}";
        }
    }

    public static class StringConst
    extends Node {
        public String quoted;
        public String text;

        public StringConst(Tree tree, int pos, String quoted, String text) {
            super(tree, Type.STRING, pos);
            this.quoted = quoted;
            this.text = text;
        }

        @Override
        public Node copy() {
            return new StringConst(this.tree, this.pos, this.quoted, this.text);
        }

        public String toString() {
            return this.quoted;
        }
    }

    public static class Number
    extends Node {
        public boolean isInt;
        public boolean isFloat;
        public int intVal;
        public double floatVal;
        public String text;

        public Number(Tree tree, int pos, String text) {
            super(tree, Type.NUMBER, pos);
            this.text = text;
        }

        public Number(Number node) {
            super(node.tree, node.type, node.pos);
            this.text = node.text;
            this.isInt = node.isInt;
            this.isFloat = node.isFloat;
            this.intVal = node.intVal;
            this.floatVal = node.floatVal;
        }

        @Override
        public Node copy() {
            return new Number(this);
        }

        public String toString() {
            return this.text;
        }
    }

    public static class Bool
    extends Node {
        public boolean boolVal;

        public Bool(Tree tree, int pos, boolean boolVal) {
            super(tree, Type.BOOL, pos);
            this.boolVal = boolVal;
        }

        @Override
        public Node copy() {
            return new Bool(this.tree, this.pos, this.boolVal);
        }

        public String toString() {
            return this.boolVal ? "true" : "false";
        }
    }

    public static class Chain
    extends Node {
        public ArrayList<String> field;
        public Node node;

        public Chain(Tree tree, int pos, Node node) {
            super(tree, Type.CHAIN, pos);
            this.node = node;
            this.field = new ArrayList();
        }

        public Chain(Tree tree, int pos, Node node, java.util.List<String> field) {
            super(tree, Type.CHAIN, pos);
            this.node = node;
            this.field = new ArrayList<String>(field);
        }

        public void add(String field) throws ParseException {
            if (field.length() == 0 || field.charAt(0) != '.') {
                throw new ParseException("no dot in field");
            }
            if ((field = field.substring(1)).equals("")) {
                throw new ParseException("no dot in field");
            }
            this.field.add(field);
        }

        @Override
        public Node copy() {
            return new Chain(this.tree, this.pos, this.node, new ArrayList<String>(this.field));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.node.type == Type.PIPE) {
                sb.append("(").append(this.node).append(")");
            } else {
                sb.append(this.node);
            }
            for (String f : this.field) {
                sb.append(".").append(f);
            }
            return sb.toString();
        }
    }

    public static class Field
    extends Node {
        public ArrayList<String> ident;

        public Field(Tree tree, int pos, java.util.List<String> ident) {
            super(tree, Type.FIELD, pos);
            this.ident = new ArrayList<String>(ident);
        }

        @Override
        public Node copy() {
            return new Field(this.tree, this.pos, new ArrayList<String>(this.ident));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("");
            for (String i : this.ident) {
                sb.append(".").append(i);
            }
            return sb.toString();
        }
    }

    public static class Null
    extends Node {
        public Null(Tree tree, int pos) {
            super(tree, Type.NULL, pos);
        }

        @Override
        public Node copy() {
            return new Null(this.tree, this.pos);
        }

        public String toString() {
            return "null";
        }
    }

    public static class Dot
    extends Node {
        public Dot(Tree tree, int pos) {
            super(tree, Type.DOT, pos);
        }

        @Override
        public Node copy() {
            return new Dot(this.tree, this.pos);
        }

        public String toString() {
            return ".";
        }
    }

    public static class Identifier
    extends Node {
        public String ident;

        public Identifier(Tree tree, int pos, String ident) {
            super(tree, Type.IDENTIFIER, pos);
            this.ident = ident;
        }

        @Override
        public Node copy() {
            return new Identifier(this.tree, this.pos, this.ident);
        }

        public String toString() {
            return this.ident;
        }
    }

    public static class Action
    extends Node {
        public Pipe pipe;

        public Action(Tree tree, int pos, Pipe pipe) {
            super(tree, Type.ACTION, pos);
            this.pipe = pipe;
        }

        @Override
        public Node copy() {
            return new Action(this.tree, this.pos, this.pipe.copyPipe());
        }

        public String toString() {
            return String.format("{{%s}}", this.pipe);
        }
    }

    public static class Command
    extends Node {
        public ArrayList<Node> args = new ArrayList();

        public Command(Tree tree, int pos) {
            super(tree, Type.COMMAND, pos);
        }

        public void append(Node node) {
            this.args.add(node);
        }

        @Override
        public Node copy() {
            Command command = new Command(this.tree, this.pos);
            for (Node arg : this.args) {
                command.append(arg.copy());
            }
            return command;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < this.args.size(); ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                Node arg = this.args.get(i);
                if (arg.type == Type.PIPE) {
                    sb.append("(").append(arg).append(")");
                    continue;
                }
                sb.append(arg);
            }
            return sb.toString();
        }
    }

    public static class Assign
    extends Node {
        public ArrayList<String> ident;

        public Assign(Tree tree, int pos, java.util.List<String> ident) {
            super(tree, Type.VARIABLE, pos);
            this.ident = new ArrayList<String>(ident);
        }

        @Override
        public Node copy() {
            return new Assign(this.tree, this.pos, new ArrayList<String>(this.ident));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < this.ident.size(); ++i) {
                if (i > 0) {
                    sb.append(".");
                }
                sb.append(this.ident.get(i));
            }
            return sb.toString();
        }
    }

    public static class Pipe
    extends Node {
        ArrayList<Assign> vars;
        ArrayList<Command> cmds;
        public boolean decl;

        public Pipe(Tree tree, int pos, java.util.List<Assign> vars) {
            super(tree, Type.PIPE, pos);
            this.vars = new ArrayList<Assign>(vars);
            this.cmds = new ArrayList();
        }

        public void append(Command cmd) {
            this.cmds.add(cmd);
        }

        public Pipe copyPipe() {
            ArrayList<Assign> copyDecl = new ArrayList<Assign>();
            for (Assign d : this.vars) {
                copyDecl.add((Assign)d.copy());
            }
            Pipe pipe = new Pipe(this.tree, this.pos, copyDecl);
            pipe.vars = new ArrayList<Assign>(this.vars);
            for (Command cmd : this.cmds) {
                pipe.append((Command)cmd.copy());
            }
            return pipe;
        }

        @Override
        public Node copy() {
            return this.copyPipe();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("");
            if (this.vars.size() == 1) {
                sb.append(this.vars.get(0));
                sb.append(" := ");
            }
            for (int i = 0; i < this.cmds.size(); ++i) {
                if (i > 0) {
                    sb.append(" | ");
                }
                sb.append(this.cmds.get(i));
            }
            return sb.toString();
        }
    }

    public static class Text
    extends Node {
        public String text;

        public Text(Tree tree, int pos, String text) {
            super(tree, Type.TEXT, pos);
            this.text = text;
        }

        @Override
        public Node copy() {
            return new Text(this.tree, this.pos, this.text);
        }

        public String toString() {
            return this.text;
        }
    }

    public static class List
    extends Node {
        public ArrayList<Node> nodes = new ArrayList();

        public List(Tree tree, int pos) {
            super(tree, Type.LIST, pos);
        }

        public void append(Node node) {
            this.nodes.add(node);
        }

        public List copyList() {
            List list = new List(this.tree, this.pos);
            for (Node node : this.nodes) {
                list.append(node.copy());
            }
            return list;
        }

        @Override
        public Node copy() {
            return this.copyList();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Node node : this.nodes) {
                sb.append(node);
            }
            return sb.toString();
        }
    }

    public static enum Type {
        TEXT,
        ACTION,
        BOOL,
        CHAIN,
        COMMAND,
        DOT,
        FIELD,
        IDENTIFIER,
        IF,
        LIST,
        NULL,
        NUMBER,
        PIPE,
        FOR,
        ELSE,
        END,
        WITH,
        BREAK,
        CONTINUE,
        STRING,
        TEMPLATE,
        VARIABLE;

    }
}

