/*
 * Decompiled with CFR 0.152.
 */
package ru.proninyaroslav.template;

class Token {
    public Type type;
    public int pos;
    public String val;
    public int line;

    public Token(Type type, int pos, String val, int line) {
        this.type = type;
        this.pos = pos;
        this.val = val;
        this.line = line;
    }

    public Token(Type type, String val) {
        this.type = type;
        this.pos = 0;
        this.val = val;
        this.line = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.type == Type.EOF) {
            sb.append("EOF");
        } else if (this.type.ordinal() > Type.KEYWORD.ordinal()) {
            sb.append(String.format("<%s>", this.val));
        } else if (this.val.length() > 50) {
            sb.append(String.format("'%.50s...'", this.val));
        } else {
            sb.append(String.format("'%s'", this.val));
        }
        return sb.toString();
    }

    public static enum Type {
        ERROR,
        TEXT,
        BOOL,
        CHAR,
        CHAR_CONSTANT,
        NUMBER,
        SPACE,
        STRING,
        RAW_STRING,
        DECLARE,
        ASSIGN,
        EOF,
        FIELD,
        IDENTIFIER,
        VARIABLE,
        LEFT_DELIM,
        RIGHT_DELIM,
        LEFT_PAREN,
        RIGHT_PAREN,
        PIPE,
        KEYWORD,
        DOT,
        NULL,
        IF,
        FOR,
        BREAK,
        CONTINUE,
        WITH,
        ELSE,
        END,
        DEFINE,
        TEMPLATE;

    }
}

