/*
 * Decompiled with CFR 0.152.
 */
package ru.proninyaroslav.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import ru.proninyaroslav.template.FuncMap;
import ru.proninyaroslav.template.Lexer;
import ru.proninyaroslav.template.Node;
import ru.proninyaroslav.template.Token;
import ru.proninyaroslav.template.Utils;
import ru.proninyaroslav.template.exceptions.InternalException;
import ru.proninyaroslav.template.exceptions.ParseException;

public class Tree {
    public String name;
    public String parseName;
    public Node.List root;
    private String text;
    private Lexer lex;
    private Token[] token = new Token[3];
    private int peekCount;
    private int forDepth;
    private FuncMap[] funcs;
    private ArrayList<String> vars;
    private HashMap<String, Tree> treeSet;

    public Tree(String name, String parseName, String text, FuncMap ... funcs) {
        this.name = name;
        this.parseName = parseName;
        this.text = text;
        this.funcs = funcs;
    }

    public Tree(String name, FuncMap ... funcs) {
        this.name = name;
        this.funcs = funcs;
    }

    public static HashMap<String, Tree> parse(String name, String text, String leftDelim, String rightDelim, FuncMap ... funcs) throws ParseException, InternalException {
        HashMap<String, Tree> treeSet = new HashMap<String, Tree>();
        Tree tree = new Tree(name, new FuncMap[0]);
        tree.text = text;
        tree.parse(text, leftDelim, rightDelim, treeSet, funcs);
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(String text, String leftDelim, String rightDelim, HashMap<String, Tree> treeSet, FuncMap ... funcs) throws ParseException, InternalException {
        try {
            this.parseName = this.name;
            this.startParse(funcs, new Lexer(this.name, text, leftDelim, rightDelim), treeSet);
            this.text = text;
            this.parse();
            this.add();
        }
        finally {
            this.lex.drain();
            this.stopParse();
        }
    }

    private void startParse(FuncMap[] funcs, Lexer lex, HashMap<String, Tree> treeSet) {
        this.lex = lex;
        this.funcs = funcs;
        this.treeSet = treeSet;
        this.vars = new ArrayList();
        this.vars.add("$");
    }

    private void stopParse() {
        this.lex = null;
        this.vars = null;
        this.funcs = null;
        this.treeSet = null;
        this.forDepth = 0;
    }

    private void add() throws ParseException {
        Tree tree = this.treeSet.get(this.name);
        if (tree == null || Tree.isEmptyTree(this.root)) {
            this.treeSet.put(this.name, this);
            return;
        }
        if (!Tree.isEmptyTree(this.root)) {
            this.errorf("template: multiple definition of template %s", this.name);
        }
    }

    public String errorLocation(Node node) {
        String text;
        int index;
        Tree tree = node.tree;
        if (tree == null) {
            tree = this;
        }
        if ((index = (text = tree.text.substring(0, node.pos)).lastIndexOf(10)) == -1) {
            index = node.pos;
        } else {
            ++index;
            index = node.pos = index;
        }
        int lineNum = Utils.countChars(text, '\n');
        return String.format("%s:%d:%d", tree.parseName, lineNum, index);
    }

    public String errorContext(Node node) {
        String context = node.toString();
        if (context.length() > 20) {
            context = String.format("%.20s...", context);
        }
        return context;
    }

    private void errorf(String format, Object ... args) throws ParseException {
        this.root = null;
        throw new ParseException(String.format(String.format("%s:%d: %s", this.parseName, this.token[0].line, format), args));
    }

    public static boolean isEmptyTree(Node node) throws ParseException {
        if (node == null) {
            return true;
        }
        if (node instanceof Node.List) {
            for (Node n : ((Node.List)node).nodes) {
                if (!Tree.isEmptyTree(n)) continue;
                return false;
            }
            return true;
        }
        if (node instanceof Node.Text) {
            return ((Node.Text)node).text.trim().length() == 0;
        }
        if (!(node instanceof Node.Action || node instanceof Node.If || node instanceof Node.For || node instanceof Node.Template || node instanceof Node.With)) {
            throw new ParseException(String.format("unknown node: %s", node));
        }
        return false;
    }

    private void backup() {
        ++this.peekCount;
    }

    private void backupTwo(Token t) {
        this.token[1] = t;
        this.peekCount = 2;
    }

    private void backupThree(Token t2, Token t1) {
        this.token[1] = t1;
        this.token[2] = t2;
        this.peekCount = 3;
    }

    private Token peek() throws InternalException {
        if (this.peekCount > 0) {
            return this.token[this.peekCount - 1];
        }
        this.peekCount = 1;
        this.token[0] = this.lex.nextToken();
        return this.token[0];
    }

    private Token peekNonSpace() throws InternalException {
        Token token = this.next();
        while (token.type == Token.Type.SPACE) {
            token = this.next();
        }
        this.backup();
        return token;
    }

    private Token next() throws InternalException {
        if (this.peekCount > 0) {
            --this.peekCount;
        } else {
            this.token[0] = this.lex.nextToken();
        }
        return this.token[this.peekCount];
    }

    private Token nextNonSpace() throws InternalException {
        Token token = this.next();
        while (token.type == Token.Type.SPACE) {
            token = this.next();
        }
        return token;
    }

    private Token expect(Token.Type expected, String context) throws ParseException, InternalException {
        Token token = this.nextNonSpace();
        if (token.type != expected) {
            this.unexpected(token, context);
        }
        return token;
    }

    private Token expectOneOf(Token.Type expected1, Token.Type expected2, String context) throws ParseException, InternalException {
        Token token = this.nextNonSpace();
        if (token.type != expected1 && token.type != expected2) {
            this.unexpected(token, context);
        }
        return token;
    }

    private void unexpected(Token token, String context) throws ParseException {
        this.errorf("unexpected %s in %s", token, context);
    }

    private boolean hasFunction(String name) {
        for (FuncMap funcMap : this.funcs) {
            if (funcMap == null || !funcMap.contains(name)) continue;
            return true;
        }
        return false;
    }

    private Node useVar(int pos, String name) throws ParseException {
        Node.Assign var = this.newVariable(pos, name);
        for (String varName : this.vars) {
            if (!var.ident.get(0).equals(varName)) continue;
            return var;
        }
        this.errorf("undefined variable %s", name);
        return null;
    }

    private void popVars(int n) {
        this.vars = new ArrayList<String>(this.vars.subList(0, n));
    }

    private void parse() throws ParseException, InternalException {
        this.root = this.newList(this.peek().pos);
        while (this.peek().type != Token.Type.EOF) {
            Node n;
            if (this.peek().type == Token.Type.LEFT_DELIM) {
                Token delim = this.next();
                if (this.nextNonSpace().type == Token.Type.DEFINE) {
                    Tree newTree = new Tree("definition", this.parseName, this.text, new FuncMap[0]);
                    newTree.startParse(this.funcs, this.lex, this.treeSet);
                    newTree.parseDefinition();
                    continue;
                }
                this.backupTwo(delim);
            }
            if ((n = this.textOrAction()) == null || n.type == Node.Type.END || n.type == Node.Type.ELSE) {
                this.errorf("unexpected %s", n);
                continue;
            }
            this.root.append(n);
        }
    }

    private void parseDefinition() throws ParseException, InternalException {
        String context = "define clause";
        Token name = this.expectOneOf(Token.Type.STRING, Token.Type.RAW_STRING, "define clause");
        try {
            this.name = Utils.unquote(name.val);
        }
        catch (IllegalArgumentException e) {
            this.errorf("%s", e.getMessage());
        }
        this.expect(Token.Type.RIGHT_DELIM, "define clause");
        Node.List[] outRoot = new Node.List[1];
        Node[] outEnd = new Node[1];
        this.tokenList(outRoot, outEnd);
        this.root = outRoot[0];
        if (outEnd[0].type != Node.Type.END) {
            this.errorf("unexpected %s in %s", outEnd[0], "define clause");
        }
        this.add();
        this.stopParse();
    }

    private void tokenList(Node.List[] outList, Node[] outNode) throws ParseException, InternalException {
        outList[0] = this.newList(this.peekNonSpace().pos);
        while (this.peekNonSpace().type != Token.Type.EOF) {
            outNode[0] = this.textOrAction();
            if (outNode[0] != null && (outNode[0].type == Node.Type.END || outNode[0].type == Node.Type.ELSE)) {
                return;
            }
            outList[0].append(outNode[0]);
        }
        this.errorf("unexpected EOF", new Object[0]);
    }

    private Node textOrAction() throws ParseException, InternalException {
        Token token = this.nextNonSpace();
        switch (token.type) {
            case TEXT: {
                return this.newText(token.pos, token.val);
            }
            case LEFT_DELIM: {
                return this.action();
            }
        }
        this.unexpected(token, "input");
        return null;
    }

    private Node action() throws ParseException, InternalException {
        Token token = this.nextNonSpace();
        switch (token.type) {
            case ELSE: {
                return this.elseControl();
            }
            case END: {
                return this.endControl();
            }
            case IF: {
                return this.ifControl();
            }
            case FOR: {
                return this.forControl();
            }
            case TEMPLATE: {
                return this.templateControl();
            }
            case WITH: {
                return this.withControl();
            }
            case BREAK: {
                return this.breakControl();
            }
            case CONTINUE: {
                return this.continueControl();
            }
        }
        this.backup();
        token = this.peek();
        return this.newAction(token.pos, this.pipeline("command"));
    }

    private Node.Pipe pipeline(String context) throws ParseException, InternalException {
        ArrayList<Node.Assign> vars = new ArrayList<Node.Assign>();
        boolean decl = false;
        int pos = this.peekNonSpace().pos;
        Token v = this.peekNonSpace();
        if (v.type == Token.Type.VARIABLE) {
            this.next();
            Token tokenAfterVariable = this.peek();
            Token next = this.peekNonSpace();
            if (next.type == Token.Type.ASSIGN || next.type == Token.Type.DECLARE) {
                this.nextNonSpace();
                vars.add(this.newVariable(v.pos, v.val));
                this.vars.add(v.val);
                decl = next.type == Token.Type.DECLARE;
            } else if (tokenAfterVariable.type == Token.Type.SPACE) {
                this.backupThree(v, tokenAfterVariable);
            } else {
                this.backupTwo(v);
            }
        }
        Node.Pipe pipe = this.newPipeline(pos, vars);
        pipe.decl = decl;
        block4: while (true) {
            Token token = this.nextNonSpace();
            switch (token.type) {
                case RIGHT_DELIM: 
                case RIGHT_PAREN: {
                    this.checkPipeline(pipe, context);
                    if (token.type == Token.Type.RIGHT_PAREN) {
                        this.backup();
                    }
                    return pipe;
                }
                case BOOL: 
                case CHAR_CONSTANT: 
                case DOT: 
                case FIELD: 
                case IDENTIFIER: 
                case NUMBER: 
                case NULL: 
                case STRING: 
                case RAW_STRING: 
                case VARIABLE: 
                case LEFT_PAREN: {
                    this.backup();
                    pipe.append(this.command());
                    continue block4;
                }
            }
            this.unexpected(token, context);
        }
    }

    private void checkPipeline(Node.Pipe pipe, String context) throws ParseException {
        if (pipe.cmds.size() == 0) {
            this.errorf("missing value for %s", context);
        }
        for (int i = 1; i < pipe.cmds.size(); ++i) {
            Node.Command c = pipe.cmds.get(i);
            switch (c.args.get((int)0).type) {
                case BOOL: 
                case DOT: 
                case NULL: 
                case NUMBER: 
                case STRING: {
                    this.errorf("non executable command in pipeline stage %d", i + 1);
                }
            }
        }
    }

    private Node.Command command() throws ParseException, InternalException {
        Node.Command cmd = this.newCommand(this.peekNonSpace().pos);
        block6: while (true) {
            this.peekNonSpace();
            Node operand = this.operand();
            if (operand != null) {
                cmd.append(operand);
            }
            Token token = this.next();
            switch (token.type) {
                case SPACE: {
                    continue block6;
                }
                case ERROR: {
                    this.errorf("%s", token.val);
                    break block6;
                }
                case RIGHT_DELIM: 
                case RIGHT_PAREN: {
                    this.backup();
                    break block6;
                }
                case PIPE: {
                    break block6;
                }
                default: {
                    this.errorf("unexpected %s in operand", token);
                    break block6;
                }
            }
            break;
        }
        if (cmd.args.size() == 0) {
            this.errorf("empty command", new Object[0]);
        }
        return cmd;
    }

    private Node operand() throws ParseException, InternalException {
        Node node = this.term();
        if (node == null) {
            return null;
        }
        if (this.peek().type == Token.Type.FIELD) {
            Node.Chain chain = this.newChain(this.peek().pos, node);
            while (this.peek().type == Token.Type.FIELD) {
                chain.add(this.next().val);
            }
            switch (node.type) {
                case FIELD: {
                    node = this.newField(chain.pos, chain.toString());
                    break;
                }
                case VARIABLE: {
                    node = this.newVariable(chain.pos, chain.toString());
                    break;
                }
                case BOOL: 
                case DOT: 
                case NULL: 
                case NUMBER: {
                    this.errorf("unexpected . after term %s", node);
                }
                default: {
                    node = chain;
                }
            }
        }
        return node;
    }

    private Node term() throws ParseException, InternalException {
        Token token = this.nextNonSpace();
        switch (token.type) {
            case ERROR: {
                this.errorf("%s", token.val);
            }
            case IDENTIFIER: {
                if (!this.hasFunction(token.val)) {
                    this.errorf("function '%s' not defined", token.val);
                }
                Node.Identifier i = this.newIdentifier(token.pos, token.val);
                i.tree = this;
                return i;
            }
            case DOT: {
                return this.newDot(token.pos);
            }
            case NULL: {
                return this.newNull(token.pos);
            }
            case VARIABLE: {
                return this.useVar(token.pos, token.val);
            }
            case FIELD: {
                return this.newField(token.pos, token.val);
            }
            case BOOL: {
                return this.newBool(token.pos, token.val.equals("true"));
            }
            case CHAR_CONSTANT: 
            case NUMBER: {
                return this.newNumber(token.pos, token.val, token.type);
            }
            case LEFT_PAREN: {
                Node.Pipe pipe = this.pipeline("parenthesized pipeline");
                Token t = this.next();
                if (t.type != Token.Type.RIGHT_PAREN) {
                    this.errorf("unclosed right paren: unexpected %s", token);
                }
                return pipe;
            }
            case STRING: 
            case RAW_STRING: {
                String s;
                try {
                    s = Utils.unquote(token.val);
                }
                catch (IllegalArgumentException e) {
                    throw new ParseException(e.getMessage());
                }
                return this.newString(token.pos, token.val, s);
            }
        }
        this.backup();
        return null;
    }

    private Node elseControl() throws ParseException, InternalException {
        Token peek = this.peekNonSpace();
        if (peek.type == Token.Type.IF) {
            return this.newElse(peek.pos);
        }
        return this.newElse(this.expect((Token.Type)Token.Type.RIGHT_DELIM, (String)"else").pos);
    }

    private Node endControl() throws ParseException, InternalException {
        return this.newEnd(this.expect((Token.Type)Token.Type.RIGHT_DELIM, (String)"end").pos);
    }

    private Node templateControl() throws ParseException, InternalException {
        String context = "template clause";
        Token token = this.nextNonSpace();
        String name = this.parseTemplateName(token, "template clause");
        Node.Pipe pipe = null;
        if (this.nextNonSpace().type != Token.Type.RIGHT_DELIM) {
            this.backup();
            pipe = this.pipeline("template clause");
        }
        return this.newTemplate(token.pos, name, pipe);
    }

    private String parseTemplateName(Token token, String context) throws ParseException {
        String name = "";
        if (token.type == Token.Type.STRING || token.type == Token.Type.RAW_STRING) {
            name = Utils.unquote(token.val);
        } else {
            this.unexpected(token, context);
        }
        return name;
    }

    private Node ifControl() throws ParseException, InternalException {
        int[] outPos = new int[1];
        Node.Pipe[] outPipe = new Node.Pipe[1];
        Node.List[] outList = new Node.List[1];
        Node.List[] outElseList = new Node.List[1];
        this.parseControl(true, "if", outPos, outPipe, outList, outElseList);
        return this.newIf(outPos[0], outPipe[0], outList[0], outElseList[0]);
    }

    private Node forControl() throws ParseException, InternalException {
        int[] outPos = new int[1];
        Node.Pipe[] outPipe = new Node.Pipe[1];
        Node.List[] outList = new Node.List[1];
        Node.List[] outElseList = new Node.List[1];
        this.parseControl(false, "for", outPos, outPipe, outList, outElseList);
        return this.newFor(outPos[0], outPipe[0], outList[0], outElseList[0]);
    }

    private Node breakControl() throws ParseException, InternalException {
        if (this.forDepth == 0) {
            this.errorf("unexpected break outside of for", new Object[0]);
        }
        return this.newBreak(this.expect((Token.Type)Token.Type.RIGHT_DELIM, (String)"break").pos);
    }

    private Node continueControl() throws ParseException, InternalException {
        if (this.forDepth == 0) {
            this.errorf("unexpected continue outside of for", new Object[0]);
        }
        return this.newContinue(this.expect((Token.Type)Token.Type.RIGHT_DELIM, (String)"continue").pos);
    }

    private Node withControl() throws ParseException, InternalException {
        int[] outPos = new int[1];
        Node.Pipe[] outPipe = new Node.Pipe[1];
        Node.List[] outList = new Node.List[1];
        Node.List[] outElseList = new Node.List[1];
        this.parseControl(false, "with", outPos, outPipe, outList, outElseList);
        return this.newWith(outPos[0], outPipe[0], outList[0], outElseList[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseControl(boolean allowElseIf, String context, int[] outPos, Node.Pipe[] outPipe, Node.List[] outList, Node.List[] outElseList) throws ParseException, InternalException {
        int varsSize = this.vars.size();
        try {
            outPipe[0] = this.pipeline(context);
            Node[] next = new Node[1];
            if (context.equals("for")) {
                ++this.forDepth;
            }
            this.tokenList(outList, next);
            if (context.equals("for")) {
                --this.forDepth;
            }
            if (next[0].type == Node.Type.ELSE) {
                if (allowElseIf && this.peek().type == Token.Type.IF) {
                    this.next();
                    outElseList[0] = this.newList(next[0].pos);
                    outElseList[0].append(this.ifControl());
                } else {
                    this.tokenList(outElseList, next);
                    if (next[0].type != Node.Type.END) {
                        this.errorf("expected end; found %s", next[0]);
                    }
                }
            }
        }
        finally {
            this.popVars(varsSize);
        }
        outPos[0] = outPipe[0].pos;
    }

    Node.List newList(int pos) {
        return new Node.List(this, pos);
    }

    Node.Text newText(int pos, String text) {
        return new Node.Text(this, pos, text);
    }

    Node.Pipe newPipeline(int pos, List<Node.Assign> decl) {
        return new Node.Pipe(this, pos, decl);
    }

    Node.Assign newVariable(int pos, String ident) {
        return new Node.Assign(this, pos, Arrays.asList(ident.split("\\.")));
    }

    Node.Command newCommand(int pos) {
        return new Node.Command(this, pos);
    }

    Node.Action newAction(int pos, Node.Pipe pipe) {
        return new Node.Action(this, pos, pipe);
    }

    Node.Identifier newIdentifier(int pos, String ident) {
        return new Node.Identifier(this, pos, ident);
    }

    Node.Dot newDot(int pos) {
        return new Node.Dot(this, pos);
    }

    Node.Null newNull(int pos) {
        return new Node.Null(this, pos);
    }

    Node.Field newField(int pos, String ident) {
        return new Node.Field(this, pos, Arrays.asList(ident.substring(1).split("\\.")));
    }

    Node.Chain newChain(int pos, Node node) {
        return new Node.Chain(this, pos, node);
    }

    Node.Bool newBool(int pos, boolean boolVal) {
        return new Node.Bool(this, pos, boolVal);
    }

    Node.Number newNumber(int pos, String text, Token.Type type) throws ParseException {
        Node.Number n = new Node.Number(this, pos, text);
        if (type == Token.Type.CHAR_CONSTANT) {
            char c;
            StringBuilder tail = new StringBuilder();
            try {
                c = Utils.unquoteChar(text.substring(1, text.length()), text.charAt(0), tail);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(e);
            }
            if (!tail.toString().equals("'")) {
                throw new ParseException(String.format("malformed character constant: %s", text));
            }
            n.isInt = true;
            n.intVal = c;
            n.isFloat = true;
            n.floatVal = c;
            return n;
        }
        boolean isNegative = text.startsWith("-");
        String unsignedNum = isNegative || text.startsWith("+") ? text.substring(1, text.length()) : text;
        if (!isNegative && unsignedNum.startsWith("-")) {
            throw new ParseException(String.format("illegal number syntax: %s", text));
        }
        try {
            long i = unsignedNum.toLowerCase().startsWith("0x") ? Long.parseLong(unsignedNum.substring(2), 16) : (text.charAt(0) == '0' ? Long.parseLong(unsignedNum, 8) : Long.parseLong(unsignedNum));
            if (i > Integer.MAX_VALUE || i < Integer.MIN_VALUE) {
                throw new ParseException(String.format("integer overflow: %s", text));
            }
            n.isInt = true;
            n.intVal = (int)i;
        }
        catch (NumberFormatException i) {
            // empty catch block
        }
        if (n.isInt) {
            n.isFloat = true;
            n.floatVal = n.intVal;
        } else {
            try {
                double f = Double.parseDouble(unsignedNum);
                if (!Utils.containsAny(unsignedNum, ".eE")) {
                    throw new ParseException(String.format("integer overflow: %s", text));
                }
                n.isFloat = true;
                n.floatVal = f;
                if (!n.isInt && (double)((int)f) == f) {
                    n.isInt = true;
                    n.intVal = (int)f;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (isNegative) {
            n.intVal = -n.intVal;
            n.floatVal = -n.floatVal;
        }
        if (!n.isInt && !n.isFloat) {
            throw new ParseException(String.format("illegal number syntax: %s", text));
        }
        return n;
    }

    Node.StringConst newString(int pos, String orig, String text) {
        return new Node.StringConst(this, pos, orig, text);
    }

    Node.End newEnd(int pos) {
        return new Node.End(this, pos);
    }

    Node.Else newElse(int pos) {
        return new Node.Else(this, pos);
    }

    Node.If newIf(int pos, Node.Pipe pipe, Node.List list, Node.List elseList) {
        return new Node.If(this, pos, pipe, list, elseList);
    }

    Node.For newFor(int pos, Node.Pipe pipe, Node.List list, Node.List elseList) {
        return new Node.For(this, pos, pipe, list, elseList);
    }

    Node.Break newBreak(int pos) {
        return new Node.Break(this, pos);
    }

    Node.Continue newContinue(int pos) {
        return new Node.Continue(this, pos);
    }

    Node.With newWith(int pos, Node.Pipe pipe, Node.List list, Node.List elseList) {
        return new Node.With(this, pos, pipe, list, elseList);
    }

    Node.Template newTemplate(int pos, String name, Node.Pipe pipe) {
        return new Node.Template(this, pos, name, pipe);
    }
}

