/*
 * Decompiled with CFR 0.152.
 */
package ru.proninyaroslav.template;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import ru.proninyaroslav.template.FileUtils;

class Utils {
    Utils() {
    }

    static boolean isSpace(char c) {
        return c == ' ' || c == '\t';
    }

    static boolean isEndOfLine(char c) {
        return c == '\r' || c == '\n';
    }

    static boolean isAlphaNumeric(char c) {
        return c == '_' || Character.isLetterOrDigit(c);
    }

    static char unquoteChar(String s, char quote, StringBuilder tail) {
        String err = String.format("malformed character constant: %s", s);
        char c = s.charAt(0);
        if (c == quote && (quote == '\'' || quote == '\"')) {
            throw new IllegalArgumentException(err);
        }
        if (c != '\\') {
            if (tail != null) {
                tail.setLength(0);
                tail.append(s.substring(1, s.length()));
            }
            return c;
        }
        if (s.length() <= 1) {
            throw new IllegalArgumentException(err);
        }
        c = s.charAt(1);
        s = s.substring(2, s.length());
        if (tail != null) {
            tail.setLength(0);
            tail.append(s);
        }
        ArrayList<Integer> chars = new ArrayList<Integer>();
        switch (c) {
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case '\\': {
                return '\\';
            }
            case '\"': 
            case '\'': {
                if (c != quote) {
                    throw new IllegalArgumentException(err);
                }
                return c;
            }
            case 'u': {
                int maxLength = 4;
                if (s.length() < 4) {
                    throw new IllegalArgumentException(err);
                }
                int val = 0;
                for (int i = 0; i < 4; ++i) {
                    int n;
                    try {
                        n = Utils.unhex(s.charAt(i));
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(err);
                    }
                    val = val << 4 | n;
                }
                if (val > 65535) {
                    throw new IllegalArgumentException(err);
                }
                if (tail != null) {
                    tail.setLength(0);
                    tail.append(s.substring(4, s.length()));
                }
                return (char)val;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                int val = c - 48;
                for (int i = 0; i < s.length(); ++i) {
                    int n = s.charAt(i) - 48;
                    if (n < 0 || n > 7) continue;
                    chars.add(n);
                }
                int length = chars.size();
                Iterator iterator = chars.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    val = val << length + 1 | n;
                }
                if (val > 65535) {
                    throw new IllegalArgumentException(err);
                }
                if (tail != null) {
                    tail.setLength(0);
                    tail.append(s.substring(length, s.length()));
                }
                return (char)val;
            }
        }
        throw new IllegalArgumentException(err);
    }

    private static int unhex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException();
    }

    static String unquote(String s) {
        int n = s.length();
        String err = String.format("malformed string constant: %s", s);
        if (n < 2) {
            throw new IllegalArgumentException(err);
        }
        char quote = s.charAt(0);
        if (quote != s.charAt(n - 1)) {
            throw new IllegalArgumentException(err);
        }
        s = s.substring(1, n - 1);
        if (quote == '`') {
            if (s.indexOf(96) >= 0) {
                throw new IllegalArgumentException(err);
            }
            if (s.indexOf(13) >= 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < s.length(); ++i) {
                    if (s.charAt(i) == '\r') continue;
                    sb.append(s.charAt(i));
                }
                return sb.toString();
            }
            return s;
        }
        if (quote != '\"' && quote != '\'') {
            throw new IllegalArgumentException(err);
        }
        if (s.indexOf(10) >= 0) {
            throw new IllegalArgumentException(err);
        }
        if (s.indexOf(92) < 0 && s.indexOf(quote) < 0) {
            switch (quote) {
                case '\"': {
                    return s;
                }
                case '\'': {
                    if (s.length() != 1) break;
                    return s;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        while (s.length() > 0) {
            StringBuilder tail = new StringBuilder();
            char c = Utils.unquoteChar(s, quote, tail);
            s = tail.toString();
            sb.append(c);
            if (quote != '\'' || s.length() == 0) continue;
            throw new IllegalArgumentException(err);
        }
        return sb.toString();
    }

    static String doublePercent(String s) {
        if (s.contains("%")) {
            s = s.replaceAll("%", "%%");
        }
        return s;
    }

    static int countChars(String s, char c) {
        int n = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    static boolean containsAny(String s, String chars) {
        boolean match = false;
        for (char c : chars.toCharArray()) {
            if (s.indexOf(c) < 0) continue;
            match = true;
            break;
        }
        return match;
    }

    static boolean isHexConstant(String s) {
        return s.length() > 2 && s.charAt(0) == '0' && (s.charAt(1) == 'x' || s.charAt(1) == 'X');
    }

    static boolean isTrue(Object val) throws IllegalArgumentException {
        if (val == null) {
            return false;
        }
        boolean truth = true;
        if (Boolean.class.isInstance(val)) {
            truth = (Boolean)val;
        } else if (String.class.isInstance(val)) {
            truth = !((String)val).isEmpty();
        } else if (Integer.class.isInstance(val)) {
            truth = (Integer)val > 0;
        } else if (Double.class.isInstance(val)) {
            truth = (Double)val > 0.0;
        } else if (Long.class.isInstance(val)) {
            truth = (Long)val > 0L;
        } else if (Collection.class.isInstance(val)) {
            truth = !((Collection)val).isEmpty();
        } else if (Map.class.isInstance(val)) {
            truth = !((Map)val).isEmpty();
        } else if (val.getClass().isArray()) {
            truth = Array.getLength(val) > 0;
        } else if (Float.class.isInstance(val)) {
            truth = ((Float)val).floatValue() > 0.0f;
        } else if (Short.class.isInstance(val)) {
            truth = (Short)val > 0;
        } else if (Byte.class.isInstance(val)) {
            truth = (Byte)val > 0;
        }
        return truth;
    }

    static Map<String, String> filesToString(File ... files) throws IOException {
        HashMap<String, String> s = new HashMap<String, String>();
        for (File file : files) {
            s.put(file.getName(), new String(FileUtils.bytes(file)));
        }
        return s;
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        StringBuilder joiner = new StringBuilder();
        Iterator<? extends CharSequence> i = elements.iterator();
        while (i.hasNext()) {
            CharSequence cs = i.next();
            joiner.append(cs);
            if (!i.hasNext()) continue;
            joiner.append(delimiter);
        }
        return joiner.toString();
    }

    public static String join(CharSequence delimiter, CharSequence ... elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        StringBuilder joiner = new StringBuilder();
        for (int i = 0; i < elements.length; ++i) {
            CharSequence cs = elements[i];
            joiner.append(cs);
            if (i + 1 == elements.length) continue;
            joiner.append(delimiter);
        }
        return joiner.toString();
    }
}

