/*
 * Decompiled with CFR 0.152.
 */
package ru.DmN.bul;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ru.DmN.bul.BytecodeTransformer;

@SupportedAnnotationTypes(value={"ru.DmN.bul.BytecodeProcessor"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u00020\u000b2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001bH\u0002J\b\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lru/DmN/bul/BytecodeAnnotationProcessor;", "Ljavax/annotation/processing/AbstractProcessor;", "<init>", "()V", "filer", "Ljavax/annotation/processing/Filer;", "messager", "Ljavax/annotation/processing/Messager;", "processed", "", "init", "", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "process", "annotations", "", "Ljavax/lang/model/element/TypeElement;", "roundEnv", "Ljavax/annotation/processing/RoundEnvironment;", "processAnnotatedClasses", "elements", "processClass", "classElement", "transformer", "Lru/DmN/bul/BytecodeTransformer;", "readClassBytes", "", "classFileName", "", "writeClassFile", "className", "bytes", "createClassLoader", "Ljava/lang/ClassLoader;", "BytecodeUtilsLibrary"})
@SourceDebugExtension(value={"SMAP\nBytecodeAnnotationProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BytecodeAnnotationProcessor.kt\nru/DmN/bul/BytecodeAnnotationProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1869#2,2:167\n1#3:169\n*S KotlinDebug\n*F\n+ 1 BytecodeAnnotationProcessor.kt\nru/DmN/bul/BytecodeAnnotationProcessor\n*L\n79#1:167,2\n*E\n"})
public final class BytecodeAnnotationProcessor
extends AbstractProcessor {
    private Filer filer;
    private Messager messager;
    private boolean processed;

    @Override
    public void init(@NotNull ProcessingEnvironment processingEnv) {
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        super.init(processingEnv);
        Filer filer = processingEnv.getFiler();
        Intrinsics.checkNotNullExpressionValue((Object)filer, (String)"getFiler(...)");
        this.filer = filer;
        Messager messager = processingEnv.getMessager();
        Intrinsics.checkNotNullExpressionValue((Object)messager, (String)"getMessager(...)");
        this.messager = messager;
    }

    @Override
    public boolean process(@NotNull Set<? extends TypeElement> annotations, @NotNull RoundEnvironment roundEnv) {
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)roundEnv, (String)"roundEnv");
        if (this.processed || annotations.isEmpty()) {
            return false;
        }
        try {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(this.processingEnv.getElementUtils().getTypeElement("ru.DmN.bul.BytecodeProcessor"));
            Intrinsics.checkNotNull(annotatedElements);
            if (!((Collection)annotatedElements).isEmpty()) {
                this.processAnnotatedClasses(annotatedElements);
                this.processed = true;
            }
        }
        catch (Exception e) {
            Messager messager = this.messager;
            if (messager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messager");
                messager = null;
            }
            messager.printMessage(Diagnostic.Kind.ERROR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0431\u0430\u0439\u0442\u043a\u043e\u0434\u0430: " + e.getMessage());
            e.printStackTrace();
        }
        return true;
    }

    private final void processAnnotatedClasses(Set<?> elements) {
        Messager messager = this.messager;
        if (messager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messager");
            messager = null;
        }
        messager.printMessage(Diagnostic.Kind.NOTE, "\u041d\u0430\u0447\u0430\u043b\u043e \u0442\u0440\u0430\u043d\u0441\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0431\u0430\u0439\u0442\u043a\u043e\u0434\u0430...");
        ClassLoader classLoader = this.createClassLoader();
        Messager messager2 = this.messager;
        if (messager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messager");
            messager2 = null;
        }
        BytecodeTransformer transformer = new BytecodeTransformer(classLoader, messager2);
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object element = element$iv = iterator.next();
            boolean bl = false;
            if (!(element instanceof TypeElement)) continue;
            this.processClass((TypeElement)element, transformer);
        }
        Messager messager3 = this.messager;
        if (messager3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messager");
            messager3 = null;
        }
        messager3.printMessage(Diagnostic.Kind.NOTE, "\u0422\u0440\u0430\u043d\u0441\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u0431\u0430\u0439\u0442\u043a\u043e\u0434\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
    }

    private final void processClass(TypeElement classElement, BytecodeTransformer transformer) {
        String className = classElement.getQualifiedName().toString();
        String internalName = StringsKt.replace$default((String)className, (char)'.', (char)'/', (boolean)false, (int)4, null);
        String classFileName = internalName + ".class";
        Messager messager = this.messager;
        if (messager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messager");
            messager = null;
        }
        messager.printMessage(Diagnostic.Kind.NOTE, "\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043a\u043b\u0430\u0441\u0441\u0430: " + className);
        try {
            byte[] originalBytes = this.readClassBytes(classFileName);
            if (originalBytes != null) {
                byte[] transformedBytes = transformer.transform(originalBytes);
                this.writeClassFile(className, transformedBytes);
            }
        }
        catch (Exception e) {
            Messager messager2 = this.messager;
            if (messager2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messager");
                messager2 = null;
            }
            messager2.printMessage(Diagnostic.Kind.ERROR, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043a\u043b\u0430\u0441\u0441\u0430 " + className + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] readClassBytes(String classFileName) {
        byte[] byArray;
        try {
            byte[] byArray2;
            Filer filer = this.filer;
            if (filer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"filer");
                filer = null;
            }
            FileObject resource = filer.getResource(StandardLocation.CLASS_OUTPUT, "", classFileName);
            Closeable closeable = resource.openInputStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                byArray2 = it.readAllBytes();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            byArray = byArray2;
        }
        catch (Exception e) {
            Messager messager = this.messager;
            if (messager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messager");
                messager = null;
            }
            messager.printMessage(Diagnostic.Kind.WARNING, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u043a\u043b\u0430\u0441\u0441 " + classFileName + ": " + e.getMessage());
            byArray = null;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeClassFile(String className, byte[] bytes) {
        Filer filer = this.filer;
        if (filer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filer");
            filer = null;
        }
        JavaFileObject classFile = filer.createClassFile(className, new Element[0]);
        Closeable closeable = classFile.openOutputStream();
        Throwable throwable = null;
        try {
            OutputStream output = (OutputStream)closeable;
            boolean bl = false;
            output.write(bytes);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final ClassLoader createClassLoader() {
        return new ClassLoader(this){
            final /* synthetic */ BytecodeAnnotationProcessor this$0;
            {
                this.this$0 = $receiver;
            }

            protected Class<?> findClass(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String classFileName = StringsKt.replace$default((String)name, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class";
                byte[] byArray = BytecodeAnnotationProcessor.access$readClassBytes(this.this$0, classFileName);
                if (byArray == null) {
                    throw new ClassNotFoundException("\u041a\u043b\u0430\u0441\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: " + name);
                }
                byte[] bytes = byArray;
                Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"defineClass(...)");
                return clazz;
            }
        };
    }

    public static final /* synthetic */ byte[] access$readClassBytes(BytecodeAnnotationProcessor $this, String classFileName) {
        return $this.readClassBytes(classFileName);
    }
}

