package ru.DmN.bul.processor

import javax.annotation.processing.AbstractProcessor
import javax.annotation.processing.RoundEnvironment
import javax.annotation.processing.SupportedAnnotationTypes
import javax.annotation.processing.SupportedSourceVersion
import javax.lang.model.SourceVersion
import javax.lang.model.element.ElementKind
import javax.lang.model.element.ExecutableElement
import javax.lang.model.element.TypeElement
import javax.tools.Diagnostic

@SupportedAnnotationTypes("ru.DmN.bul.BytecodeProcessor")
@SupportedSourceVersion(SourceVersion.RELEASE_8)
class BytecodeUtilsProcessor : AbstractProcessor() {
    override fun process(annotations: MutableSet<out TypeElement?>, roundEnv: RoundEnvironment): Boolean {
        for (annotation in annotations) {
            val annotatedElements = roundEnv.getElementsAnnotatedWith(annotation)

            for (element in annotatedElements) {
                if (element.kind == ElementKind.CLASS) {
                    val classElement = element as TypeElement
                    processingEnv.messager.printMessage(
                        Diagnostic.Kind.NOTE,
                        "Обрабатываем класс: " + classElement.qualifiedName
                    )

                    // Получаем все методы класса
                    val enclosedElements = classElement.enclosedElements
                    for (enclosed in enclosedElements) {
                        if (enclosed.kind == ElementKind.METHOD) {
                            val methodElement = enclosed as ExecutableElement
                            processingEnv.messager.printMessage(
                                Diagnostic.Kind.NOTE,
                                "Метод: " + methodElement.simpleName +
                                        " (параметры: " + methodElement.parameters + ")" +
                                        " возвращает: " + methodElement.returnType
                            )
                        }
                    }
                }
            }
        }
        return true
    }
}