/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.javasqliteutils;

import ch.framedev.javasqliteutils.Callback;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLiteV2 {
    private final Logger LOGGER = Logger.getLogger(SQLiteV2.class.getName());
    public Connection connection;
    private final String fileName;
    private final String path;
    private final ExecutorService executor = Executors.newFixedThreadPool(10);

    protected SQLiteV2(String path, String database) {
        this.path = path;
        this.fileName = database;
    }

    public void connectAsync(Callback<Connection> callback) {
        this.executor.execute(() -> {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    callback.onResult(this.connection);
                    return;
                }
                Class.forName("org.sqlite.JDBC");
                String url = "jdbc:sqlite:" + this.path + "/" + this.fileName;
                this.connection = DriverManager.getConnection(url);
                callback.onResult(this.connection);
            }
            catch (ClassNotFoundException | SQLException e) {
                callback.onError(e);
            }
        });
    }

    public Connection connect() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return this.connection;
            }
            Class.forName("org.sqlite.JDBC");
            String url = "jdbc:sqlite:" + this.path + "/" + this.fileName;
            this.connection = DriverManager.getConnection(url);
            return this.connection;
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new RuntimeException("Failed to connect to SQLite database", e);
        }
    }

    public void close() {
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (SQLException ex) {
                this.LOGGER.log(Level.SEVERE, "Failed to close SQLite connection", ex);
            }
            finally {
                this.connection = null;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean isTableExists(String table) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void isTableExistsAsync(final String table, final Callback<Boolean> callback) {
        final String sql = "SELECT name FROM sqlite_master WHERE type = 'table' AND name = ? AND name NOT LIKE 'sqlite_%';";
        this.executor.execute(() -> this.connectAsync(new Callback<Connection>(){
            final /* synthetic */ SQLiteV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Connection result) {
                try (Connection conn = result;
                     PreparedStatement pstmt = Objects.requireNonNull(conn).prepareStatement(sql);){
                    pstmt.setString(1, table);
                    try (ResultSet rs = pstmt.executeQuery();){
                        callback.onResult(rs.next());
                    }
                }
                catch (SQLException ex) {
                    callback.onError(ex);
                }
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        }));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean createTable(String tableName, boolean date, String[] columns) {
        String sql = SQLiteV2.getString(tableName, date, columns);
        try (Connection conn = this.connect();){
            boolean bl;
            block14: {
                Statement stmt = conn.createStatement();
                try {
                    bl = stmt.execute(sql);
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.SEVERE, "Failed to create table: " + tableName, e);
            return false;
        }
    }

    public void createTableAsync(String tableName, boolean date, String[] columns, final Callback<Boolean> callback) {
        final String sql = SQLiteV2.getString(tableName, date, columns);
        this.executor.execute(() -> this.connectAsync(new Callback<Connection>(){
            final /* synthetic */ SQLiteV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Connection result) {
                try (Connection conn = result;
                     Statement stmt = conn.createStatement();){
                    stmt.execute(sql);
                    callback.onResult(true);
                }
                catch (SQLException e) {
                    callback.onError(e);
                }
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        }));
    }

    private static String getString(String tableName, boolean date, String[] columns) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            stringBuilder.append(columns[i]);
            if (i >= columns.length - 1) continue;
            stringBuilder.append(",");
        }
        String sql = date ? "CREATE TABLE IF NOT EXISTS " + tableName + " (ID INTEGER PRIMARY KEY AUTOINCREMENT, " + stringBuilder.toString() + ", created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP);" : "CREATE TABLE IF NOT EXISTS " + tableName + " (ID INTEGER PRIMARY KEY AUTOINCREMENT, " + stringBuilder.toString() + ");";
        return sql;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean insertData(String table, Object[] data, String[] columns) {
        if (columns.length == 0 || data.length == 0 || columns.length != data.length) {
            throw new IllegalArgumentException("Columns and data arrays must not be empty and must have the same length.");
        }
        String columnNames = String.join((CharSequence)",", columns);
        String placeholders = String.join((CharSequence)",", Collections.nCopies(columns.length, "?"));
        String sql = "INSERT INTO " + table + " (" + columnNames + ") VALUES (" + placeholders + ")";
        try (Connection conn = this.connect();){
            boolean bl;
            block16: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    for (int i = 0; i < data.length; ++i) {
                        stmt.setObject(i + 1, data[i]);
                    }
                    boolean bl2 = bl = stmt.executeUpdate() > 0;
                    if (stmt == null) break block16;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.SEVERE, "Failed to insert data into table: " + table, e);
            return false;
        }
    }

    public void insertDataAsync(String table, final Object[] data, String[] columns, final Callback<Boolean> callback) {
        if (columns.length == 0 || data.length == 0 || columns.length != data.length) {
            throw new IllegalArgumentException("Columns and data arrays must not be empty and must have the same length.");
        }
        String columnNames = String.join((CharSequence)",", columns);
        String placeholders = String.join((CharSequence)",", Collections.nCopies(columns.length, "?"));
        final String sql = "INSERT INTO " + table + " (" + columnNames + ") VALUES (" + placeholders + ")";
        this.executor.execute(() -> this.connectAsync(new Callback<Connection>(){
            final /* synthetic */ SQLiteV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Connection result) {
                try (Connection conn = result;
                     PreparedStatement stmt = conn.prepareStatement(sql);){
                    for (int i = 0; i < data.length; ++i) {
                        stmt.setObject(i + 1, data[i]);
                    }
                    stmt.executeUpdate();
                    callback.onResult(true);
                }
                catch (SQLException e) {
                    callback.onError(e);
                }
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        }));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean updateData(String table, String selected, Object data, String where) {
        String sql = "UPDATE " + table + " SET " + selected + " = ? WHERE " + where;
        try (Connection conn = this.connect();){
            boolean bl;
            block14: {
                PreparedStatement pstmt = Objects.requireNonNull(conn).prepareStatement(sql);
                try {
                    pstmt.setObject(1, data);
                    boolean bl2 = bl = pstmt.executeUpdate() > 0;
                    if (pstmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.SEVERE, "Failed to update data in table: " + table, e);
            return false;
        }
    }

    public void updateDataAsync(String table, String selected, final Object data, String where, final Callback<Boolean> callback) {
        final String sql = "UPDATE " + table + " SET " + selected + " = ? WHERE " + where;
        this.executor.execute(() -> this.connectAsync(new Callback<Connection>(){
            final /* synthetic */ SQLiteV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Connection result) {
                try (Connection conn = result;
                     PreparedStatement pstmt = Objects.requireNonNull(conn).prepareStatement(sql);){
                    pstmt.setObject(1, data);
                    pstmt.executeUpdate();
                    callback.onResult(pstmt.executeUpdate() > 0);
                }
                catch (SQLException e) {
                    callback.onError(e);
                }
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        }));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean updateData(String table, String[] columns, Object[] values, String where) {
        if (columns.length == 0 || values.length == 0 || columns.length != values.length) {
            throw new IllegalArgumentException("Columns and values arrays must not be empty and must have the same length.");
        }
        StringBuilder setClause = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            setClause.append(columns[i]).append(" = ?");
            if (i >= columns.length - 1) continue;
            setClause.append(", ");
        }
        String sql = "UPDATE " + table + " SET " + setClause.toString() + " WHERE " + where;
        try (Connection conn = this.connect();){
            boolean bl;
            block17: {
                PreparedStatement pstmt = Objects.requireNonNull(conn).prepareStatement(sql);
                try {
                    for (int i = 0; i < values.length; ++i) {
                        pstmt.setObject(i + 1, values[i]);
                    }
                    boolean bl2 = bl = pstmt.executeUpdate() > 0;
                    if (pstmt == null) break block17;
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.SEVERE, "Failed to update data in table: " + table, e);
            return false;
        }
    }

    public void updateDataAsync(String table, String[] columns, final Object[] values, String where, final Callback<Boolean> callback) {
        if (columns.length == 0 || values.length == 0 || columns.length != values.length) {
            throw new IllegalArgumentException("Columns and values arrays must not be empty and must have the same length.");
        }
        StringBuilder setClause = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            setClause.append(columns[i]).append(" = ?");
            if (i >= columns.length - 1) continue;
            setClause.append(", ");
        }
        final String sql = "UPDATE " + table + " SET " + setClause.toString() + " WHERE " + where;
        this.executor.execute(() -> this.connectAsync(new Callback<Connection>(){
            final /* synthetic */ SQLiteV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Connection result) {
                try (Connection conn = result;
                     PreparedStatement pstmt = Objects.requireNonNull(conn).prepareStatement(sql);){
                    for (int i = 0; i < values.length; ++i) {
                        pstmt.setObject(i + 1, values[i]);
                    }
                    callback.onResult(pstmt.executeUpdate() > 0);
                }
                catch (SQLException e) {
                    callback.onError(e);
                }
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        }));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean deleteDataInTable(String table, String where) {
        String sql = "DELETE FROM " + table + " WHERE " + where;
        try (Connection conn = this.connect();){
            boolean bl;
            block14: {
                PreparedStatement pstmt = Objects.requireNonNull(conn).prepareStatement(sql);
                try {
                    boolean bl2 = bl = pstmt.executeUpdate() > 0;
                    if (pstmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.SEVERE, "Failed to delete data in table: " + table, e);
            return false;
        }
    }

    public void deleteDataInTableAsync(String table, String where, final Callback<Boolean> callback) {
        final String sql = "DELETE FROM " + table + " WHERE " + where;
        this.executor.execute(() -> this.connectAsync(new Callback<Connection>(){
            final /* synthetic */ SQLiteV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Connection result) {
                try (Connection conn = result;
                     PreparedStatement pstmt = Objects.requireNonNull(conn).prepareStatement(sql);){
                    callback.onResult(pstmt.executeUpdate() > 0);
                }
                catch (SQLException e) {
                    callback.onError(e);
                }
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        }));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean deleteDataInTable(String table, String whereColumn, String whereValue, String andColumn, String andValue) {
        String sql = "DELETE FROM " + table + " WHERE " + whereColumn + " = ? AND " + andColumn + " = ?";
        try (Connection conn = this.connect();){
            boolean bl;
            block14: {
                PreparedStatement pstmt = Objects.requireNonNull(conn).prepareStatement(sql);
                try {
                    pstmt.setString(1, whereValue);
                    pstmt.setString(2, andValue);
                    boolean bl2 = bl = pstmt.executeUpdate() > 0;
                    if (pstmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.SEVERE, "Failed to delete data in table: " + table, e);
            return false;
        }
    }

    public void deleteDataInTableAsync(String table, String whereColumn, final String whereValue, String andColumn, final String andValue, final Callback<Boolean> callback) {
        final String sql = "DELETE FROM " + table + " WHERE " + whereColumn + " = ? AND " + andColumn + " = ?";
        this.executor.execute(() -> this.connectAsync(new Callback<Connection>(){
            final /* synthetic */ SQLiteV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Connection result) {
                try (Connection conn = result;
                     PreparedStatement pstmt = Objects.requireNonNull(conn).prepareStatement(sql);){
                    pstmt.setString(1, whereValue);
                    pstmt.setString(2, andValue);
                    callback.onResult(pstmt.executeUpdate() > 0);
                }
                catch (SQLException e) {
                    callback.onError(e);
                }
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        }));
    }

    /*
     * Exception decompiling
     */
    public boolean exists(String table, String column, String data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void existsAsync(String table, String column, final String data, final Callback<Boolean> callback) {
        final String sql = "SELECT * FROM " + table + " WHERE " + column + " = ?";
        this.executor.execute(() -> this.connectAsync(new Callback<Connection>(){
            final /* synthetic */ SQLiteV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Connection result) {
                try (Connection conn = result;
                     PreparedStatement pstmt = Objects.requireNonNull(conn).prepareStatement(sql);){
                    pstmt.setString(1, data);
                    try (ResultSet res = pstmt.executeQuery();){
                        callback.onResult(res.next());
                    }
                }
                catch (SQLException e) {
                    callback.onError(e);
                }
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        }));
    }

    /*
     * Exception decompiling
     */
    public boolean exists(String table, String column, String data, String andColumn, String andValue) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean exists(String table, String[] column, String[] data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void existsAsync(String table, String column, final String data, String andColumn, final String andValue, final Callback<Boolean> callback) {
        final String sql = "SELECT * FROM " + table + " WHERE " + column + " = ? AND " + andColumn + " = ?";
        this.executor.execute(() -> this.connectAsync(new Callback<Connection>(){
            final /* synthetic */ SQLiteV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Connection result) {
                try (Connection conn = result;
                     PreparedStatement pstmt = Objects.requireNonNull(conn).prepareStatement(sql);){
                    pstmt.setString(1, data);
                    pstmt.setString(2, andValue);
                    try (ResultSet res = pstmt.executeQuery();){
                        callback.onResult(res.next());
                    }
                }
                catch (SQLException e) {
                    callback.onError(e);
                }
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        }));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(String table, String selected, String column, Object data) {
        String sql = "SELECT " + selected + " FROM " + table + " WHERE " + column + " = ?";
        try (Connection conn = this.connect();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setObject(1, data);
            try (ResultSet res = pstmt.executeQuery();){
                if (!res.next()) return null;
                Object object = res.getObject(selected);
                return object;
            }
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.SEVERE, "Database query failed: " + sql, e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(String table, String selected, String[] column, Object[] data) {
        if (column == null) throw new IllegalArgumentException("Columns and data arrays must not be empty and must have the same length.");
        if (data == null) throw new IllegalArgumentException("Columns and data arrays must not be empty and must have the same length.");
        if (column.length == 0) throw new IllegalArgumentException("Columns and data arrays must not be empty and must have the same length.");
        if (data.length == 0) throw new IllegalArgumentException("Columns and data arrays must not be empty and must have the same length.");
        if (column.length != data.length) {
            throw new IllegalArgumentException("Columns and data arrays must not be empty and must have the same length.");
        }
        StringBuilder whereClause = new StringBuilder();
        for (int i = 0; i < column.length; ++i) {
            whereClause.append(column[i]).append(" = ?");
            if (i >= column.length - 1) continue;
            whereClause.append(" AND ");
        }
        String sql = "SELECT " + selected + " FROM " + table + " WHERE " + whereClause;
        try (Connection conn = this.connect();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            for (int i = 0; i < data.length; ++i) {
                pstmt.setObject(i + 1, data[i]);
            }
            try (ResultSet res = pstmt.executeQuery();){
                if (!res.next()) return null;
                Object object = res.getObject(selected);
                return object;
            }
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.SEVERE, "Database query failed: " + sql, e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Object> getOptional(String table, String selected, String[] column, Object[] data) {
        if (column == null) throw new IllegalArgumentException("Columns and data arrays must not be empty and must have the same length.");
        if (data == null) throw new IllegalArgumentException("Columns and data arrays must not be empty and must have the same length.");
        if (column.length == 0) throw new IllegalArgumentException("Columns and data arrays must not be empty and must have the same length.");
        if (data.length == 0) throw new IllegalArgumentException("Columns and data arrays must not be empty and must have the same length.");
        if (column.length != data.length) {
            throw new IllegalArgumentException("Columns and data arrays must not be empty and must have the same length.");
        }
        StringBuilder whereClause = new StringBuilder();
        for (int i = 0; i < column.length; ++i) {
            whereClause.append(column[i]).append(" = ?");
            if (i >= column.length - 1) continue;
            whereClause.append(" AND ");
        }
        String sql = "SELECT " + selected + " FROM " + table + " WHERE " + whereClause;
        try (Connection conn = this.connect();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            for (int i = 0; i < data.length; ++i) {
                pstmt.setObject(i + 1, data[i]);
            }
            try (ResultSet res = pstmt.executeQuery();){
                if (!res.next()) return Optional.empty();
                Optional<Object> optional = Optional.ofNullable(res.getObject(selected));
                return optional;
            }
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.SEVERE, "Database query failed: " + sql, e);
        }
        return Optional.empty();
    }

    public void getAsync(String table, final String selected, String column, final Object data, final Callback<Object> callback) {
        final String sql = "SELECT " + selected + " FROM " + table + " WHERE " + column + " = ?";
        this.executor.execute(() -> this.connectAsync(new Callback<Connection>(){
            final /* synthetic */ SQLiteV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Connection result) {
                try (PreparedStatement pstmt = result.prepareStatement(sql);){
                    pstmt.setObject(1, data);
                    try (ResultSet res = pstmt.executeQuery();){
                        if (res.next()) {
                            callback.onResult(res.getObject(selected));
                        }
                    }
                }
                catch (SQLException e) {
                    callback.onError(e);
                }
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        }));
    }

    public List<Object> get(String table, String[] selectedColumns, String column, Object data) {
        String columns = String.join((CharSequence)", ", selectedColumns);
        String sql = "SELECT " + columns + " FROM " + table + " WHERE " + column + " = ?";
        ArrayList<Object> results = new ArrayList<Object>();
        try (Connection conn = this.connect();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setObject(1, data);
            try (ResultSet res = pstmt.executeQuery();){
                while (res.next()) {
                    Object row = null;
                    for (String selectedColumn : selectedColumns) {
                        row = res.getObject(selectedColumn);
                        results.add(row);
                    }
                }
            }
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.SEVERE, "Database query failed: " + sql, e);
        }
        return results;
    }

    public List<Object> get(String table, String[] selectedColumns, String[] column, Object[] data) {
        if (selectedColumns == null || selectedColumns.length == 0 || column == null || data == null || column.length == 0 || data.length == 0 || column.length != data.length) {
            throw new IllegalArgumentException("Selected columns, columns, and data arrays must not be empty and must have the same length.");
        }
        String columnsStr = String.join((CharSequence)", ", selectedColumns);
        StringBuilder whereClause = new StringBuilder();
        for (int i = 0; i < column.length; ++i) {
            whereClause.append(column[i]).append(" = ?");
            if (i >= column.length - 1) continue;
            whereClause.append(" AND ");
        }
        String sql = "SELECT " + columnsStr + " FROM " + table + " WHERE " + whereClause;
        ArrayList<Object> results = new ArrayList<Object>();
        try (Connection conn = this.connect();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            for (int i = 0; i < data.length; ++i) {
                pstmt.setObject(i + 1, data[i]);
            }
            try (ResultSet res = pstmt.executeQuery();){
                while (res.next()) {
                    for (String selectedColumn : selectedColumns) {
                        results.add(res.getObject(selectedColumn));
                    }
                }
            }
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.SEVERE, "Database query failed: " + sql, e);
        }
        return results;
    }

    public void getAsync(String table, final String[] selectedColumns, String column, final Object data, final Callback<List<Object>> callback) {
        String columns = String.join((CharSequence)", ", selectedColumns);
        final String sql = "SELECT " + columns + " FROM " + table + " WHERE " + column + " = ?";
        final ArrayList results = new ArrayList();
        this.executor.execute(() -> this.connectAsync(new Callback<Connection>(){
            final /* synthetic */ SQLiteV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Connection result) {
                try (PreparedStatement pstmt = result.prepareStatement(sql);){
                    pstmt.setObject(1, data);
                    try (ResultSet res = pstmt.executeQuery();){
                        while (res.next()) {
                            Object row = null;
                            for (String selectedColumn : selectedColumns) {
                                row = res.getObject(selectedColumn);
                                results.add(row);
                            }
                        }
                        callback.onResult(results);
                    }
                }
                catch (SQLException e) {
                    callback.onError(e);
                }
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        }));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T get(String table, String selected, String column, Object data, Class<T> type) {
        String sql = "SELECT " + selected + " FROM " + table + " WHERE " + column + " = ?";
        try (Connection conn = this.connect();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setObject(1, data);
            try (ResultSet res = pstmt.executeQuery();){
                if (!res.next()) return null;
                Object value = res.getObject(selected);
                if (type.isInstance(value)) {
                    T t = type.cast(value);
                    return t;
                }
                this.LOGGER.warning("Type mismatch: Expected " + type.getSimpleName() + " but got " + (value != null ? value.getClass().getSimpleName() : "null"));
                return null;
            }
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.SEVERE, "Database query failed: " + sql, e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> Optional<T> getOptional(String table, String selected, String column, Object data, Class<T> type) {
        String sql = "SELECT " + selected + " FROM " + table + " WHERE " + column + " = ?";
        try (Connection conn = this.connect();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setObject(1, data);
            try (ResultSet res = pstmt.executeQuery();){
                if (!res.next()) return Optional.empty();
                Object value = res.getObject(selected);
                if (type.isInstance(value)) {
                    Optional<T> optional = Optional.of(type.cast(value));
                    return optional;
                }
                this.LOGGER.warning("Type mismatch: Expected " + type.getSimpleName() + " but got " + (value != null ? value.getClass().getSimpleName() : "null"));
                return Optional.empty();
            }
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.SEVERE, "Database query failed: " + sql, e);
        }
        return Optional.empty();
    }

    public <T> void getAsync(String table, final String selected, String column, final Object data, final Class<T> type, final Callback<T> callback) {
        final String sql = "SELECT " + selected + " FROM " + table + " WHERE " + column + " = ?";
        this.executor.execute(() -> this.connectAsync(new Callback<Connection>(){
            final /* synthetic */ SQLiteV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Connection result) {
                try (PreparedStatement pstmt = result.prepareStatement(sql);){
                    pstmt.setObject(1, data);
                    try (ResultSet res = pstmt.executeQuery();){
                        if (res.next()) {
                            Object value = res.getObject(selected);
                            if (type.isInstance(value)) {
                                callback.onResult(type.cast(value));
                            } else {
                                this.this$0.LOGGER.warning("Type mismatch: Expected " + type.getSimpleName() + " but got " + (value != null ? value.getClass().getSimpleName() : "null"));
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    callback.onError(e);
                }
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        }));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean addColumn(String table, String column) {
        String sql = "ALTER TABLE " + table + " ADD COLUMN " + column;
        if (!this.isTableExists(table)) {
            return false;
        }
        try (Connection conn = this.connect();){
            boolean bl;
            block15: {
                PreparedStatement statement = Objects.requireNonNull(conn).prepareStatement(sql);
                try {
                    boolean bl2 = bl = statement.executeUpdate() > 0;
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.SEVERE, "Failed to add column: " + column + " to table: " + table, e);
            return false;
        }
    }

    public void addColumnAsync(String table, String column, final Callback<Boolean> callback) {
        final String sql = "ALTER TABLE " + table + " ADD COLUMN " + column;
        this.isTableExistsAsync(table, new Callback<Boolean>(){
            final /* synthetic */ SQLiteV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (!result.booleanValue()) {
                    callback.onResult(false);
                    return;
                }
                this.this$0.connectAsync(new Callback<Connection>(){

                    @Override
                    public void onResult(Connection result) {
                        try (Connection conn = result;
                             PreparedStatement statement = Objects.requireNonNull(conn).prepareStatement(sql);){
                            callback.onResult(statement.executeUpdate() > 0);
                        }
                        catch (SQLException e) {
                            callback.onError(e);
                        }
                    }

                    @Override
                    public void onError(Exception e) {
                        callback.onError(e);
                    }
                });
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeColumn(String table, String column) {
        if (!this.isTableExists(table)) {
            return false;
        }
        try (Connection conn = this.connect();){
            conn.setAutoCommit(false);
            String getColumnsSql = "PRAGMA table_info(" + table + ")";
            StringBuilder columns = new StringBuilder();
            try (PreparedStatement getColumnsStmt = conn.prepareStatement(getColumnsSql);
                 ResultSet rs = getColumnsStmt.executeQuery();){
                while (rs.next()) {
                    String colName = rs.getString("name");
                    if (colName.equalsIgnoreCase(column)) continue;
                    if (columns.length() > 0) {
                        columns.append(", ");
                    }
                    columns.append(colName);
                }
                if (columns.length() == 0) {
                    boolean colName = false;
                    return colName;
                }
                String columnsStr = columns.toString();
                String renameSql = "ALTER TABLE " + table + " RENAME TO " + table + "_old";
                try (PreparedStatement renameStmt = conn.prepareStatement(renameSql);){
                    renameStmt.executeUpdate();
                }
                String createSql = "CREATE TABLE " + table + " AS SELECT " + columnsStr + " FROM " + table + "_old";
                try (PreparedStatement createStmt = conn.prepareStatement(createSql);){
                    createStmt.executeUpdate();
                }
                String dropSql = "DROP TABLE " + table + "_old";
                try (PreparedStatement dropStmt = conn.prepareStatement(dropSql);){
                    dropStmt.executeUpdate();
                }
                conn.commit();
                return true;
            }
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.SEVERE, "Failed to remove column: " + column + " from table: " + table, e);
        }
        return true;
    }

    public void removeColumnAsync(final String table, final String column, final Callback<Boolean> callback) {
        this.isTableExistsAsync(table, new Callback<Boolean>(){
            final /* synthetic */ SQLiteV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (!result.booleanValue()) {
                    callback.onResult(false);
                    return;
                }
                this.this$0.connectAsync(new Callback<Connection>(){

                    @Override
                    public void onResult(Connection result) {
                        try (Connection conn = result;){
                            conn.setAutoCommit(false);
                            String getColumnsSql = "PRAGMA table_info(" + table + ")";
                            StringBuilder columns = new StringBuilder();
                            try (PreparedStatement getColumnsStmt = conn.prepareStatement(getColumnsSql);
                                 ResultSet rs = getColumnsStmt.executeQuery();){
                                while (rs.next()) {
                                    String colName = rs.getString("name");
                                    if (colName.equalsIgnoreCase(column)) continue;
                                    if (columns.length() > 0) {
                                        columns.append(", ");
                                    }
                                    columns.append(colName);
                                }
                                if (columns.length() == 0) {
                                    callback.onResult(false);
                                    return;
                                }
                                String columnsStr = columns.toString();
                                String renameSql = "ALTER TABLE " + table + " RENAME TO " + table + "_old";
                                try (PreparedStatement renameStmt = conn.prepareStatement(renameSql);){
                                    renameStmt.executeUpdate();
                                }
                                String createSql = "CREATE TABLE " + table + " AS SELECT " + columnsStr + " FROM " + table + "_old";
                                try (PreparedStatement createStmt = conn.prepareStatement(createSql);){
                                    createStmt.executeUpdate();
                                }
                                String dropSql = "DROP TABLE " + table + "_old";
                                try (PreparedStatement dropStmt = conn.prepareStatement(dropSql);){
                                    dropStmt.executeUpdate();
                                }
                                conn.commit();
                            }
                        }
                        catch (SQLException e) {
                            callback.onError(e);
                        }
                    }

                    @Override
                    public void onError(Exception e) {
                        callback.onError(e);
                    }
                });
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }

    /*
     * Exception decompiling
     */
    public List<String> showColumns(String table) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void showColumnsAsync(String table, final Callback<List<String>> callback) {
        final ArrayList columns = new ArrayList();
        final String sql = "SELECT * FROM " + table;
        this.connectAsync(new Callback<Connection>(){
            final /* synthetic */ SQLiteV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Connection result) {
                this.this$0.executor.execute(() -> {
                    try (Connection conn = result;
                         Statement statement = Objects.requireNonNull(conn).createStatement();
                         ResultSet rs = statement.executeQuery(sql);){
                        ResultSetMetaData mrs = rs.getMetaData();
                        for (int i = 1; i <= mrs.getColumnCount(); ++i) {
                            columns.add(mrs.getColumnLabel(i));
                        }
                        callback.onResult(columns);
                    }
                    catch (SQLException e) {
                        callback.onError(e);
                    }
                });
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }

    public static class Builder {
        private String fileName;
        private String path;

        public Builder setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public SQLiteV2 build() {
            if (this.fileName == null || this.path == null) {
                throw new IllegalArgumentException("File name and path must be set.");
            }
            new File(this.path).mkdirs();
            return new SQLiteV2(this.path, this.fileName);
        }
    }
}

