/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

import ch.framedev.simplejavautils.Cooldown;
import ch.framedev.simplejavautils.SimpleJavaUtils;

public class CooldownMilliSeconds
extends Cooldown {
    private final int id;
    private final long milliSecs;
    private long millisecondsLeft;
    private long milliSeconds;
    private final long actualTime;

    public CooldownMilliSeconds(int id, long milliSecs, long actualTime) {
        this.id = id;
        this.milliSecs = milliSecs;
        this.actualTime = actualTime;
    }

    public CooldownMilliSeconds(int id, long milliSecs) {
        this.id = id;
        this.milliSecs = milliSecs;
        this.actualTime = System.currentTimeMillis();
    }

    @Override
    public long getMilliSecondsLeft() {
        return this.millisecondsLeft;
    }

    public long getMilliSecs() {
        return this.milliSecs;
    }

    @Override
    public long getMilliSeconds() {
        return this.milliSeconds;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean check() {
        this.millisecondsLeft = this.actualTime + this.milliSecs - System.currentTimeMillis();
        this.milliSeconds = this.actualTime + this.milliSecs - System.currentTimeMillis();
        return this.millisecondsLeft <= 0L;
    }

    @Override
    public void sendInformation() {
        new SimpleJavaUtils().getLogger().info("ID : " + this.id);
        new SimpleJavaUtils().getLogger().info("MilliSeconds Left : " + this.millisecondsLeft);
        new SimpleJavaUtils().getLogger().info("Is Expired : " + this.isExpired());
    }
}

